/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.features.macelimiter;

import im.ghosty.kamoof.KamoofPlugin;
import im.ghosty.kamoof.deps.xyz.haoshoku.nick.NickAPI;
import im.ghosty.kamoof.features.Feature;
import im.ghosty.kamoof.utils.CompatibilityUtils;
import im.ghosty.kamoof.utils.Message;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public final class MaceLimiter
extends Feature {
    public Listener listener;

    public MaceLimiter() {
        try {
            this.listener = new Listener(this){

                @EventHandler(priority=EventPriority.HIGHEST)
                public void onCrafter(CrafterCraftEvent event) {
                    if (event.getResult().getType() != Material.MACE) {
                        return;
                    }
                    if (MaceLimiter.canCraft()) {
                        MaceLimiter.add();
                    } else {
                        event.setCancelled(true);
                    }
                }
            };
        }
        catch (Throwable exc) {
            exc.printStackTrace();
        }
    }

    public static void add() {
        KamoofPlugin.data().set("maces", (Object)(KamoofPlugin.data().getInt("maces", 0) + 1));
        KamoofPlugin.saveData();
    }

    public static boolean canCraft() {
        return KamoofPlugin.data().getInt("maces", 0) < KamoofPlugin.config().getInt("macelimiter.limit");
    }

    @Override
    public boolean isEnabled() {
        return CompatibilityUtils.isMinecraft1_21() && KamoofPlugin.config().getBoolean("macelimiter.enabled");
    }

    @Override
    public void onDisable() {
        super.onDisable();
        if (this.listener != null) {
            HandlerList.unregisterAll((Listener)this.listener);
        }
    }

    @Override
    public void onEnable() {
        super.onEnable();
        if (this.listener != null) {
            Bukkit.getPluginManager().registerEvents(this.listener, (Plugin)KamoofPlugin.getInstance());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        ItemStack result = event.getInventory().getResult();
        if (result != null && result.getType() == Material.MACE && !MaceLimiter.canCraft()) {
            event.getInventory().setResult(null);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCraft(CraftItemEvent event) {
        if (event.getCurrentItem().getType() != Material.MACE) {
            return;
        }
        switch (event.getAction()) {
            case PICKUP_ALL: 
            case PICKUP_HALF: 
            case PICKUP_SOME: 
            case PICKUP_ONE: {
                break;
            }
            default: {
                event.setCancelled(true);
                return;
            }
        }
        if (MaceLimiter.canCraft()) {
            String string;
            int old = KamoofPlugin.data().getInt("maces", 0);
            int limit = KamoofPlugin.config().getInt("macelimiter.limit");
            MaceLimiter.add();
            HumanEntity player = event.getView().getPlayer();
            if (player instanceof Player) {
                Player p = (Player)player;
                string = NickAPI.getOriginalName(p);
            } else {
                string = player.getName();
            }
            Message.send((CommandSender)player, "messages.craft-mace", Map.of("player", string, "old", old, "now", old + 1, "limit", limit));
        } else {
            event.setCancelled(true);
        }
    }
}

