/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.features.ritual;

import im.ghosty.kamoof.KamoofPlugin;
import im.ghosty.kamoof.utils.Message;
import im.ghosty.kamoof.utils.Placeholder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public final class RitualBook {
    private static final NamespacedKey keyUuid = new NamespacedKey("kamoofsmp", "uuid");

    public static ItemStack getBook(UUID uuid) {
        ItemStack item = new ItemStack(Material.WRITTEN_BOOK);
        BookMeta meta = (BookMeta)item.getItemMeta();
        meta.setGeneration(BookMeta.Generation.TATTERED);
        try {
            meta.setItemName(KamoofPlugin.config().getString("ritual.name"));
        }
        catch (Throwable exc) {
            meta.setDisplayName(KamoofPlugin.config().getString("ritual.name"));
        }
        meta.setLore(KamoofPlugin.config().getStringList("ritual.lore"));
        meta.setTitle(null);
        meta.setFireResistant(true);
        meta.spigot().setPages(RitualBook.getPages());
        meta.getPersistentDataContainer().set(keyUuid, PersistentDataType.STRING, (Object)uuid.toString());
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public static UUID getUUID(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        String uuid = (String)meta.getPersistentDataContainer().get(keyUuid, PersistentDataType.STRING);
        if (uuid == null) {
            return null;
        }
        return UUID.fromString(uuid);
    }

    private static List<BaseComponent[]> getPages() {
        ArrayList<String> pages = Placeholder.apply(KamoofPlugin.config().getStringList("ritual.pages"), Map.of("command1", "/kamoofsmp pacte 1", "command2", "/kamoofsmp pacte 2"));
        ArrayList<BaseComponent[]> result = new ArrayList<BaseComponent[]>();
        for (String page : pages) {
            result.add(Message.toBaseComponent(page));
        }
        return result;
    }

    @Generated
    private RitualBook() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

