/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.features.ritual;

import im.ghosty.kamoof.KamoofPlugin;
import im.ghosty.kamoof.api.KamoofSMP;
import im.ghosty.kamoof.features.ritual.RitualAnimation;
import im.ghosty.kamoof.utils.CompatibilityUtils;
import im.ghosty.kamoof.utils.Lang;
import im.ghosty.kamoof.utils.Message;
import im.ghosty.kamoof.utils.SLocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.joml.Vector2d;

public final class RitualHandler {
    public static final ArrayList<ArmorStand> armorStands = new ArrayList();
    public static final List<Vector2d> offsets = Arrays.asList(new Vector2d(0.0, -6.0), new Vector2d(4.0, -4.0), new Vector2d(6.0, 0.0), new Vector2d(4.0, 4.0), new Vector2d(0.0, 6.0), new Vector2d(-4.0, 4.0), new Vector2d(-6.0, 0.0), new Vector2d(-4.0, -4.0));
    public static final NamespacedKey key = new NamespacedKey("kamoofsmp", "ritualstand");
    public static boolean setup = false;
    public static Location location;

    public static void load() {
        setup = false;
        location = KamoofPlugin.data().getLocation("ritual.data.location");
        if (location == null) {
            return;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                location.getWorld().loadChunk(location.getBlockX() / 16 + x, location.getBlockZ() / 16 + z);
            }
        }
        armorStands.clear();
        for (ArmorStand entity : location.getWorld().getEntitiesByClass(ArmorStand.class)) {
            if (!entity.getPersistentDataContainer().has(key)) continue;
            armorStands.add(entity);
        }
        if (armorStands.size() < 9) {
            armorStands.forEach(Entity::remove);
            return;
        }
        setup = true;
    }

    public static void runAnimation(Player player) {
        for (ArmorStand entity : armorStands) {
            entity.getPersistentDataContainer().set(key, PersistentDataType.BOOLEAN, (Object)true);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)KamoofPlugin.getInstance(), task -> {
            for (ArmorStand entity : armorStands) {
                if (entity.getEquipment() != null && entity.getEquipment().getHelmet() != null) continue;
                return;
            }
            RitualAnimation.execute(location);
        }, 5L);
    }

    public static void setRitual(Location loc, Player player) {
        armorStands.forEach(Entity::remove);
        armorStands.clear();
        location = loc;
        HashSet<Integer> entities = new HashSet<Integer>();
        float angle = -45.0f;
        for (Vector2d offset : offsets) {
            double x = (double)loc.getBlockX() + offset.x + 0.5;
            double y = (double)loc.getBlockY() - 1.45;
            double z = (double)loc.getBlockZ() + offset.y + 0.5;
            player.spawnParticle(Particle.DUST, x, (double)loc.getBlockY() + 0.5, z, 4, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.DustOptions(Color.YELLOW, 3.0f), true);
            Location location = new Location(player.getWorld(), x, y, z, angle += 45.0f, 0.0f);
            ArmorStand entity = RitualHandler.makeArmorStand(location);
            entities.add(entity.getEntityId());
            armorStands.add(entity);
        }
        Location location = new Location(player.getWorld(), (double)loc.getBlockX() + 0.5, (double)loc.getBlockY() - 1.45, (double)loc.getBlockZ() + 0.5);
        ArmorStand entity = RitualHandler.makeArmorStand(location);
        entities.add(entity.getEntityId());
        armorStands.add(entity);
        setup = true;
        Lang.send((CommandSender)player, "NEW_RITUAL_LOCATION", loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        KamoofPlugin.data().set("ritual.data.location", (Object)loc.add(0.5, 0.5, 0.5));
        KamoofPlugin.saveData();
    }

    private static ArmorStand makeArmorStand(Location location) {
        ArmorStand entity = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        entity.setArms(false);
        entity.setBasePlate(false);
        entity.setVisible(false);
        entity.setCollidable(false);
        entity.setInvulnerable(true);
        entity.setGravity(false);
        entity.setAI(false);
        entity.getPersistentDataContainer().set(key, PersistentDataType.BOOLEAN, (Object)false);
        return entity;
    }

    public static UUID addNewUUID() {
        UUID uuid = UUID.randomUUID();
        List list = KamoofPlugin.data().getStringList("pactes");
        list.add(uuid.toString());
        KamoofPlugin.data().set("pactes", (Object)list);
        KamoofPlugin.saveData();
        return uuid;
    }

    public static boolean isValidUUID(UUID uuid) {
        List list = KamoofPlugin.data().getStringList("pactes");
        if (!list.contains(uuid.toString())) {
            return false;
        }
        list.remove(uuid.toString());
        KamoofPlugin.data().set("pactes", (Object)list);
        KamoofPlugin.saveData();
        return true;
    }

    public static void setPacte(Player player, String pacte) {
        KamoofPlugin.data().set("pacte." + String.valueOf(player.getUniqueId()), (Object)pacte);
        KamoofPlugin.saveData();
        if (pacte == null) {
            return;
        }
        switch (pacte) {
            case "1": {
                player.getAttribute(CompatibilityUtils.getMaxHealthAttribute()).addModifier(CompatibilityUtils.getMaxHealthAttributeModifier());
                Message.send((CommandSender)player, "messages.chose-bloody", Map.of("player", KamoofSMP.getInstance().getName((OfflinePlayer)player)));
                break;
            }
            case "2": {
                int level = KamoofPlugin.config().getInt("ritual.pactes.forgotten.weakness") - 1;
                if (level >= 0) {
                    player.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, -1, level));
                }
                Message.send((CommandSender)player, "messages.chose-forgotten", Map.of("player", KamoofSMP.getInstance().getName((OfflinePlayer)player)));
            }
        }
        Particle lavaParticle = KamoofPlugin.config().getBoolean("ritual.accepted.lava-sound") ? Particle.DRIPPING_DRIPSTONE_LAVA : Particle.DRIPPING_LAVA;
        World world = player.getWorld();
        double radius = KamoofPlugin.config().getDouble("ritual.accepted.lava-radius");
        double particles = KamoofPlugin.config().getDouble("ritual.accepted.lava-quantity");
        SLocation loc = new SLocation(player.getLocation()).plus(0.0, 0.9, 0.0);
        int i = 0;
        while ((double)i < particles) {
            double rand1 = Math.random();
            double rand2 = Math.random();
            double phi = Math.PI * 2 * rand1;
            double posY = loc.getY() + radius * Math.cos(phi);
            double phiSin = Math.sin(phi);
            double angle = Math.PI * 2 * rand2;
            double posX = loc.getX() + radius * Math.cos(angle) * phiSin;
            double posZ = loc.getZ() + radius * Math.sin(angle) * phiSin;
            world.spawnParticle(lavaParticle, posX, posY, posZ, 1, 0.0, 0.0, 0.0, 0.0, null, true);
            ++i;
        }
        world.spawnParticle(KamoofPlugin.config().getBoolean("ritual.accepted.flame-soul") ? Particle.SOUL_FIRE_FLAME : Particle.FLAME, (Location)loc, KamoofPlugin.config().getInt("ritual.accepted.flame-quantity"), 0.0, 0.0, 0.0, KamoofPlugin.config().getDouble("ritual.accepted.flame-speed"), null, true);
    }

    public static String getPacte(Player player) {
        return KamoofPlugin.data().getString("pacte." + String.valueOf(player.getUniqueId()));
    }
}

