/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.features.ritual;

import im.ghosty.kamoof.KamoofPlugin;
import im.ghosty.kamoof.api.KamoofSMP;
import im.ghosty.kamoof.api.events.KamoofRitualHeadEvent;
import im.ghosty.kamoof.features.Feature;
import im.ghosty.kamoof.features.drophead.SkullManager;
import im.ghosty.kamoof.features.ritual.RitualHandler;
import im.ghosty.kamoof.utils.CompatibilityUtils;
import im.ghosty.kamoof.utils.Message;
import java.util.ArrayList;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public final class RitualListener
extends Feature {
    @Override
    public boolean isEnabled() {
        return CompatibilityUtils.isMinecraft1_21() && KamoofPlugin.config().getBoolean("ritual.enabled");
    }

    @Override
    public void onEnable() {
        super.onEnable();
        RitualHandler.load();
    }

    @EventHandler
    public void onPlaceHead(PlayerArmorStandManipulateEvent event) {
        Player player = event.getPlayer();
        ArmorStand entity = event.getRightClicked();
        if (((Boolean)entity.getPersistentDataContainer().getOrDefault(RitualHandler.key, PersistentDataType.BOOLEAN, (Object)false)).booleanValue()) {
            event.setCancelled(true);
            return;
        }
        boolean contains = false;
        for (ArmorStand stand2 : RitualHandler.armorStands) {
            if (entity.getEntityId() != stand2.getEntityId()) continue;
            contains = true;
            break;
        }
        if (!contains) {
            return;
        }
        if (event.getPlayerItem().getType() != Material.PLAYER_HEAD) {
            if (entity.getEquipment() != null && entity.getEquipment().getHelmet() != null && entity.getEquipment().getHelmet().getType() == Material.PLAYER_HEAD && event.getPlayerItem().getType() == Material.AIR) {
                return;
            }
            event.setCancelled(true);
            return;
        }
        long minTime = KamoofPlugin.config().getInt("ritual.min-time");
        long maxTime = KamoofPlugin.config().getInt("ritual.max-time");
        long time = player.getWorld().getTime();
        if (time < minTime || time > maxTime) {
            Message.send((CommandSender)player, "messages.ritual-wrong-time", Map.of("player", KamoofSMP.getInstance().getName((OfflinePlayer)player)));
            event.setCancelled(true);
            return;
        }
        String comparable = SkullManager.getName(event.getPlayerItem());
        ArrayList<ArmorStand> dupes = new ArrayList<ArmorStand>();
        boolean canRunRitual = true;
        for (ArmorStand stand3 : RitualHandler.armorStands) {
            if (stand3.getEntityId() == entity.getEntityId()) continue;
            if (stand3.getEquipment() == null) {
                canRunRitual = false;
                continue;
            }
            ItemStack helmet = stand3.getEquipment().getHelmet();
            if (helmet == null || !helmet.hasItemMeta() || helmet.getType() != Material.PLAYER_HEAD) {
                canRunRitual = false;
                continue;
            }
            String comparator = SkullManager.getName(helmet);
            if (!comparable.equalsIgnoreCase(comparator)) continue;
            dupes.add(stand3);
        }
        if (dupes.size() >= KamoofPlugin.config().getInt("ritual.dupelimit")) {
            dupes.forEach(stand -> player.spawnParticle(Particle.DUST, stand.getLocation().add(0.0, 1.9, 0.0), 4, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.DustOptions(Color.ORANGE, 3.0f), true));
            player.spawnParticle(Particle.DUST, entity.getLocation().add(0.0, 1.9, 0.0), 4, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.DustOptions(Color.ORANGE, 3.0f), true);
            event.setCancelled(true);
            return;
        }
        KamoofRitualHeadEvent headEvent = new KamoofRitualHeadEvent(player, event.getPlayerItem(), entity, canRunRitual);
        Bukkit.getPluginManager().callEvent((Event)headEvent);
        if (headEvent.isCancelled()) {
            event.setCancelled(true);
            return;
        }
        if (canRunRitual) {
            RitualHandler.runAnimation(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        String pacte = RitualHandler.getPacte(player);
        if (pacte == null) {
            return;
        }
        if (pacte.equalsIgnoreCase("1")) {
            pacte = "bloody";
            player.getAttribute(CompatibilityUtils.getMaxHealthAttribute()).removeModifier(CompatibilityUtils.getMaxHealthAttributeModifier());
        } else if (pacte.equalsIgnoreCase("2")) {
            pacte = "forgotten";
        } else {
            return;
        }
        Message.send((CommandSender)player, "messages.death-" + pacte, Map.of("player", KamoofSMP.getInstance().getName((OfflinePlayer)player)));
        RitualHandler.setPacte(player, null);
    }

    @EventHandler
    public void onMilk(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTaskLater((Plugin)KamoofPlugin.getInstance(), () -> {
            if (!player.isOnline()) {
                return;
            }
            this.applyWeakness(player);
        }, 0L);
    }

    @EventHandler
    public void onTotem(EntityResurrectEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!player.isOnline()) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)KamoofPlugin.getInstance(), () -> {
            if (!player.isOnline()) {
                return;
            }
            this.applyWeakness(player);
        }, 0L);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.applyWeakness(player);
    }

    private void applyWeakness(Player player) {
        String pacte = RitualHandler.getPacte(player);
        if (pacte == null || !pacte.equalsIgnoreCase("2")) {
            return;
        }
        player.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, -1, KamoofPlugin.config().getInt("ritual.pactes.forgotten.weakness") - 1));
    }
}

