/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.utils;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.HashMap;
import lombok.Generated;

public final class ColorResolver {
    private static final HashMap<String, org.bukkit.Color> colors = new HashMap();

    public static org.bukkit.Color getColor(String color) {
        if (color == null || color.length() < 2) {
            return null;
        }
        org.bukkit.Color stored = colors.get(color.toLowerCase().trim());
        if (stored != null) {
            return stored;
        }
        try {
            return ColorResolver.toBukkit(ColorResolver.getJavaColor(color));
        }
        catch (Throwable exc) {
            return null;
        }
    }

    public static Color getJavaColor(String color) {
        return Color.decode(color);
    }

    public static org.bukkit.Color toBukkit(Color color) {
        if (color == null) {
            return null;
        }
        return org.bukkit.Color.fromARGB((int)color.getRGB());
    }

    public static String toLegacy(org.bukkit.Color color) {
        if (color == null) {
            return "";
        }
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        return "\u00a7x\u00a7" + Integer.toHexString(red >> 4) + "\u00a7" + Integer.toHexString(red & 0xF) + "\u00a7" + Integer.toHexString(green >> 4) + "\u00a7" + Integer.toHexString(green & 0xF) + "\u00a7" + Integer.toHexString(blue >> 4) + "\u00a7" + Integer.toHexString(blue & 0xF);
    }

    @Generated
    private ColorResolver() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        for (Field field : org.bukkit.Color.class.getDeclaredFields()) {
            try {
                if (field.getType() != org.bukkit.Color.class || !field.canAccess(null)) continue;
                colors.put(field.getName().toLowerCase().trim(), (org.bukkit.Color)field.get(null));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
            }
            catch (Throwable exc) {
                exc.printStackTrace();
            }
        }
    }
}

