/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.utils;

import im.ghosty.kamoof.KamoofPlugin;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.inventory.EquipmentSlotGroup;

public final class CompatibilityUtils {
    public static final boolean IS_RUNNING_PAPER;
    private static final boolean IS_MINECRAFT_1_21;
    private static final boolean DO_BUNDLES_EXIST;
    private static Attribute MAX_HEALTH_ATTRIBUTE;
    private static AttributeModifier MAX_HEALTH_ATTRIBUTE_MODIFIER;
    private static InventoryAction PAPER_PLACE_INTO_BUNDLE_ACTION;
    private static InventoryAction PAPER_PLACE_FROM_BUNDLE_ACTION;

    public static boolean isMinecraft1_21() {
        return IS_MINECRAFT_1_21;
    }

    public static boolean doBundlesExist() {
        return DO_BUNDLES_EXIST;
    }

    public static Attribute getMaxHealthAttribute() {
        if (MAX_HEALTH_ATTRIBUTE != null) {
            return MAX_HEALTH_ATTRIBUTE;
        }
        try {
            MAX_HEALTH_ATTRIBUTE = Attribute.MAX_HEALTH;
        }
        catch (Throwable exc) {
            MAX_HEALTH_ATTRIBUTE = Attribute.valueOf((String)"GENERIC_MAX_HEALTH");
        }
        return MAX_HEALTH_ATTRIBUTE;
    }

    public static AttributeModifier getMaxHealthAttributeModifier() {
        if (MAX_HEALTH_ATTRIBUTE_MODIFIER != null) {
            return MAX_HEALTH_ATTRIBUTE_MODIFIER;
        }
        int hpBoost = KamoofPlugin.config().getInt("ritual.pactes.bloody.hpboost");
        try {
            MAX_HEALTH_ATTRIBUTE_MODIFIER = new AttributeModifier(new NamespacedKey("kamoofsmp", "pacte"), (double)hpBoost, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ANY);
        }
        catch (Throwable exc) {
            MAX_HEALTH_ATTRIBUTE_MODIFIER = new AttributeModifier("kamoofsmp:pacte", (double)hpBoost, AttributeModifier.Operation.ADD_NUMBER);
        }
        return MAX_HEALTH_ATTRIBUTE_MODIFIER;
    }

    public static InventoryAction getPaperPlaceIntoBundleAction() {
        if (PAPER_PLACE_INTO_BUNDLE_ACTION != null) {
            return PAPER_PLACE_INTO_BUNDLE_ACTION;
        }
        try {
            PAPER_PLACE_INTO_BUNDLE_ACTION = InventoryAction.valueOf((String)"PLACE_ALL_INTO_BUNDLE");
        }
        catch (Throwable exc) {
            PAPER_PLACE_INTO_BUNDLE_ACTION = InventoryAction.UNKNOWN;
        }
        return PAPER_PLACE_INTO_BUNDLE_ACTION;
    }

    public static InventoryAction getPaperPlaceFromBundleAction() {
        if (PAPER_PLACE_FROM_BUNDLE_ACTION != null) {
            return PAPER_PLACE_FROM_BUNDLE_ACTION;
        }
        try {
            PAPER_PLACE_FROM_BUNDLE_ACTION = InventoryAction.valueOf((String)"PLACE_FROM_BUNDLE");
        }
        catch (Throwable exc) {
            PAPER_PLACE_FROM_BUNDLE_ACTION = InventoryAction.UNKNOWN;
        }
        return PAPER_PLACE_FROM_BUNDLE_ACTION;
    }

    @Generated
    private CompatibilityUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        boolean isPaper;
        IS_MINECRAFT_1_21 = Material.getMaterial((String)"MACE") != null;
        DO_BUNDLES_EXIST = Material.getMaterial((String)"BUNDLE") != null;
        try {
            Class.forName("com.destroystokyo.paper.ParticleBuilder");
            isPaper = true;
        }
        catch (ClassNotFoundException ignored) {
            isPaper = false;
        }
        IS_RUNNING_PAPER = isPaper;
    }
}

