/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public final class HTTPUtils {
    public static Response get(@NonNull String urlString) throws IOException {
        if (urlString == null) {
            throw new NullPointerException("urlString is marked non-null but is null");
        }
        return HTTPUtils.get(urlString, null);
    }

    public static Response get(@NonNull String urlString, Map<String, String> headers) throws IOException {
        String line;
        int status;
        if (urlString == null) {
            throw new NullPointerException("urlString is marked non-null but is null");
        }
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(30000);
        connection.setReadTimeout(30000);
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                connection.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        InputStreamReader streamReader = new InputStreamReader((status = connection.getResponseCode()) > 299 ? connection.getErrorStream() : connection.getInputStream());
        BufferedReader bufferedReader = new BufferedReader(streamReader);
        StringBuilder content = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            content.append(line);
        }
        ((Reader)streamReader).close();
        bufferedReader.close();
        connection.disconnect();
        return new Response(status, content.toString());
    }

    public static RawResponse getRaw(@NonNull String urlString) throws IOException {
        if (urlString == null) {
            throw new NullPointerException("urlString is marked non-null but is null");
        }
        return HTTPUtils.getRaw(urlString, null);
    }

    public static RawResponse getRaw(@NonNull String urlString, Map<String, String> headers) throws IOException {
        int status;
        if (urlString == null) {
            throw new NullPointerException("urlString is marked non-null but is null");
        }
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(30000);
        connection.setReadTimeout(30000);
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                connection.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        InputStream inputStream = (status = connection.getResponseCode()) > 299 ? connection.getErrorStream() : connection.getInputStream();
        byte[] data = inputStream.readAllBytes();
        connection.disconnect();
        return new RawResponse(status, data);
    }

    @Generated
    private HTTPUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public record Response(int status, String response) {
    }

    public record RawResponse(int status, byte[] response) {
    }
}

