/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.utils;

import im.ghosty.kamoof.utils.CompatibilityUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public final class InventoryUtils {
    public static Set<ItemStack> scanInventory(@NotNull Inventory inventory, Material ... types) {
        return InventoryUtils.scanInventory(inventory, 0, types);
    }

    public static Set<ItemStack> scanInventory(@NotNull Inventory inventory, @NotNull @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) int maxDepth, Material ... types) {
        Set<ItemStack> items = Arrays.stream(inventory.getStorageContents()).filter(item -> {
            if (item == null) {
                return false;
            }
            for (Material type : types) {
                if (item.getType() != type) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
        if (maxDepth > 0) {
            ItemMeta[] metaItems = (ItemMeta[])Arrays.stream(inventory.getStorageContents()).filter(Objects::nonNull).filter(ItemStack::hasItemMeta).map(ItemStack::getItemMeta).distinct().toArray(ItemMeta[]::new);
            Arrays.stream(metaItems).filter(meta -> {
                BlockStateMeta bsMeta;
                return meta instanceof BlockStateMeta && (bsMeta = (BlockStateMeta)meta).hasBlockState() && bsMeta.getBlockState() instanceof Container;
            }).map(meta -> (Container)((BlockStateMeta)meta).getBlockState()).map(Container::getInventory).forEach(inv -> items.addAll(InventoryUtils.scanInventory(inv, maxDepth - 1, types)));
            if (CompatibilityUtils.doBundlesExist()) {
                Arrays.stream(metaItems).filter(meta -> meta instanceof BundleMeta).map(meta -> (BundleMeta)meta).map(BundleMeta::getItems).forEach(itemList -> itemList.forEach(item -> items.addAll(InventoryUtils.scanItem(item, maxDepth - 1, types))));
            }
        }
        return items;
    }

    public static Set<ItemStack> scanItem(@NotNull ItemStack item, @NotNull @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) int maxDepth, Material ... types) {
        HashSet<ItemStack> items = new HashSet<ItemStack>();
        if (Arrays.stream(types).anyMatch(type -> item.getType() == type)) {
            items.add(item);
        }
        if (maxDepth > 0 && item.hasItemMeta()) {
            BlockState blockState;
            BlockStateMeta bsMeta;
            ItemMeta meta = item.getItemMeta();
            if (meta instanceof BlockStateMeta && (bsMeta = (BlockStateMeta)meta).hasBlockState() && (blockState = bsMeta.getBlockState()) instanceof Container) {
                Container cont = (Container)blockState;
                items.addAll(InventoryUtils.scanInventory(cont.getInventory(), maxDepth - 1, types));
            }
            if (CompatibilityUtils.doBundlesExist() && meta instanceof BundleMeta) {
                BundleMeta bMeta = (BundleMeta)meta;
                for (ItemStack it : bMeta.getItems()) {
                    items.addAll(InventoryUtils.scanItem(it, maxDepth - 1, types));
                }
            }
        }
        return items;
    }

    public static boolean hasInventory(@NotNull Inventory inventory, Material ... types) {
        return InventoryUtils.hasInventory(inventory, 0, types);
    }

    public static boolean hasInventory(@NotNull Inventory inventory, @NotNull @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) int maxDepth, Material ... types) {
        for (ItemStack item : inventory.getStorageContents()) {
            if (item == null) continue;
            for (Material type : types) {
                if (item.getType() != type) continue;
                return true;
            }
        }
        if (maxDepth > 0) {
            ItemMeta[] metaItems = (ItemMeta[])Arrays.stream(inventory.getStorageContents()).filter(Objects::nonNull).filter(ItemStack::hasItemMeta).map(ItemStack::getItemMeta).distinct().toArray(ItemMeta[]::new);
            Set invs = Arrays.stream(metaItems).filter(meta -> {
                BlockStateMeta bsMeta;
                return meta instanceof BlockStateMeta && (bsMeta = (BlockStateMeta)meta).hasBlockState() && bsMeta.getBlockState() instanceof Container;
            }).map(meta -> (Container)((BlockStateMeta)meta).getBlockState()).map(Container::getInventory).collect(Collectors.toSet());
            for (Inventory inv : invs) {
                if (!InventoryUtils.hasInventory(inv, maxDepth - 1, types)) continue;
                return true;
            }
            if (CompatibilityUtils.doBundlesExist()) {
                Set bundles = Arrays.stream(metaItems).filter(meta -> meta instanceof BundleMeta).map(meta -> (BundleMeta)meta).map(BundleMeta::getItems).collect(Collectors.toSet());
                for (List bundle : bundles) {
                    for (ItemStack it : bundle) {
                        if (!InventoryUtils.hasItem(it, maxDepth - 1, types)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean hasItem(@NotNull ItemStack item, @NotNull @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) int maxDepth, Material ... types) {
        if (Arrays.stream(types).anyMatch(type -> item.getType() == type)) {
            return true;
        }
        if (maxDepth > 0 && item.hasItemMeta()) {
            Container cont;
            BlockState blockState;
            BlockStateMeta bsMeta;
            ItemMeta meta = item.getItemMeta();
            if (meta instanceof BlockStateMeta && (bsMeta = (BlockStateMeta)meta).hasBlockState() && (blockState = bsMeta.getBlockState()) instanceof Container && InventoryUtils.hasInventory((cont = (Container)blockState).getInventory(), maxDepth - 1, types)) {
                return true;
            }
            if (CompatibilityUtils.doBundlesExist() && meta instanceof BundleMeta) {
                BundleMeta bMeta = (BundleMeta)meta;
                for (ItemStack it : bMeta.getItems()) {
                    if (!InventoryUtils.hasItem(it, maxDepth - 1, types)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Generated
    private InventoryUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

