/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.commands;

import im.ghosty.kamoof.KamoofPlugin;
import im.ghosty.kamoof.deps.com.samjakob.spigui.buttons.SGButton;
import im.ghosty.kamoof.deps.com.samjakob.spigui.menu.SGMenu;
import im.ghosty.kamoof.deps.net.wesjd.anvilgui.AnvilGUI;
import im.ghosty.kamoof.features.FeatureManager;
import im.ghosty.kamoof.utils.ColorResolver;
import im.ghosty.kamoof.utils.CompatibilityUtils;
import im.ghosty.kamoof.utils.Duo;
import im.ghosty.kamoof.utils.Lang;
import im.ghosty.kamoof.utils.Message;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.md_5.bungee.api.ChatMessageType;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public final class ConfigGUI {
    private static void fill(SGMenu menu, Material material) {
        ItemStack item = new ItemStack(material);
        try {
            ItemMeta meta = item.getItemMeta();
            meta.setHideTooltip(true);
            item.setItemMeta(meta);
        }
        catch (Throwable meta) {
            // empty catch block
        }
        SGButton glassPaneBtn = new SGButton(item);
        for (int i = 0; i < menu.getPageSize(); ++i) {
            menu.setButton(i, glassPaneBtn);
        }
    }

    public static SGMenu getMainMenu() {
        SGMenu menu = KamoofPlugin.getSpiGUI().create("\u00a7a\u00a7l" + Lang.get("CFG_TITLE_MAIN"), 3);
        ConfigGUI.fill(menu, Material.BLACK_STAINED_GLASS_PANE);
        ItemStack itemLang = new ItemStack(Material.DIAMOND);
        ItemMeta metaLang = itemLang.getItemMeta();
        metaLang.addItemFlags(ItemFlag.values());
        metaLang.setDisplayName("\u00a7b\u00a7l" + Lang.languages.get(Lang.getLocale()));
        metaLang.setLore(List.of("\u00a7bClick to switch language."));
        itemLang.setItemMeta(metaLang);
        menu.setButton(10, new SGButton(itemLang).withListener(event -> {
            List keys = Lang.languages.keySet().stream().toList();
            int index = (keys.indexOf(Lang.getLocale()) + 1) % keys.size();
            KamoofPlugin.config().set("language", keys.get(index));
            KamoofPlugin.getInstance().saveConfig();
            Lang.init();
            event.getWhoClicked().openInventory(ConfigGUI.getMainMenu().getInventory());
        }));
        ItemStack itemDisguise = new ItemStack(Material.IRON_INGOT);
        ItemMeta metaDisguise = itemDisguise.getItemMeta();
        metaDisguise.addItemFlags(ItemFlag.values());
        metaDisguise.setDisplayName("\u00a7f\u00a7l" + Lang.get("CFG_TITLE_DISGUISE"));
        itemDisguise.setItemMeta(metaDisguise);
        menu.setButton(12, new SGButton(itemDisguise).withListener(event -> event.getWhoClicked().openInventory(ConfigGUI.getDisguiseMenu().getInventory())));
        ItemStack itemRitual = new ItemStack(Material.REDSTONE);
        ItemMeta metaRitual = itemRitual.getItemMeta();
        metaRitual.addItemFlags(ItemFlag.values());
        metaRitual.setDisplayName("\u00a7c\u00a7l" + Lang.get("CFG_TITLE_RITUAL"));
        itemRitual.setItemMeta(metaRitual);
        menu.setButton(14, new SGButton(itemRitual).withListener(event -> {
            if (!CompatibilityUtils.isMinecraft1_21()) {
                Lang.send((CommandSender)event.getWhoClicked(), "NOT_MINECRAFT_1_21", new Object[0]);
            }
            event.getWhoClicked().openInventory(ConfigGUI.getRitualMenu().getInventory());
        }));
        ItemStack itemOther = new ItemStack(Material.COAL);
        ItemMeta metaOther = itemOther.getItemMeta();
        metaOther.addItemFlags(ItemFlag.values());
        metaOther.setDisplayName("\u00a77\u00a7l" + Lang.get("CFG_TITLE_OTHER"));
        itemOther.setItemMeta(metaOther);
        menu.setButton(16, new SGButton(itemOther).withListener(event -> event.getWhoClicked().openInventory(ConfigGUI.getOtherMenu().getInventory())));
        ConfigGUI.setButtonNote(menu, 4, "CFG_NOTE_MESSAGES");
        return menu;
    }

    public static SGMenu getDisguiseMenu() {
        SGMenu menu = KamoofPlugin.getSpiGUI().create("\u00a7a\u00a7l" + Lang.get("CFG_TITLE") + ": \u00a7f\u00a7l" + Lang.get("CFG_TITLE_DISGUISE"), 3);
        ConfigGUI.fill(menu, Material.BLACK_STAINED_GLASS_PANE);
        ConfigGUI.setButtonMainMenu(menu, 4);
        ConfigGUI.setButtonBool(menu, 10, "disguise.place-head", ConfigGUI.getStrings("CFG_DISGUISE_PLACEHEAD"));
        ConfigGUI.setButtonBool(menu, 11, "disguise.give-back", ConfigGUI.getStrings("CFG_DISGUISE_GIVEBACK"));
        ConfigGUI.setButtonBool(menu, 13, "disguise.restaure", ConfigGUI.getStrings("CFG_RESTAURE"));
        ConfigGUI.setButtonBool(menu, 15, "drophead.enabled", ConfigGUI.getStrings("CFG_DROPHEAD_ENABLED"));
        ConfigGUI.setButtonBool(menu, 16, "drophead.stackable", ConfigGUI.getStrings("CFG_DROPHEAD_STACKABLE"));
        return menu;
    }

    public static SGMenu getRitualMenu() {
        SGMenu menu = KamoofPlugin.getSpiGUI().create("\u00a7a\u00a7l" + Lang.get("CFG_TITLE") + ": \u00a7c\u00a7l" + Lang.get("CFG_TITLE_RITUAL"), 6);
        ConfigGUI.fill(menu, Material.BLACK_STAINED_GLASS_PANE);
        ConfigGUI.setButtonMainMenu(menu, 4);
        ConfigGUI.setButtonBool(menu, 9, "ritual.enabled", ConfigGUI.getStrings("CFG_RITUAL_ENABLED"));
        ConfigGUI.setButtonInt(menu, 10, "ritual.dupelimit", value -> Math.max(1, Math.min(9, value)), 1, ConfigGUI.getStrings("CFG_RITUAL_DUPELIMIT"));
        ConfigGUI.setButtonInt(menu, 11, "ritual.min-time", value -> Math.max(0, Math.min(value, Math.min(24000, KamoofPlugin.config().getInt("ritual.max-time")))), 500, ConfigGUI.getStrings("CFG_RITUAL_MINTIME"));
        ConfigGUI.setButtonInt(menu, 12, "ritual.max-time", value -> Math.min(24000, Math.max(value, Math.max(0, KamoofPlugin.config().getInt("ritual.min-time")))), 500, ConfigGUI.getStrings("CFG_RITUAL_MAXTIME"));
        ConfigGUI.setButtonInt(menu, 14, "ritual.pactes.bloody.hpboost", value -> Math.max(0, value), 1, ConfigGUI.getStrings("CFG_RITUAL_BLOODY_HPBOOST"));
        ConfigGUI.setButtonInt(menu, 15, "ritual.pactes.bloody.heads", value -> Math.max(0, Math.min(64, value)), 1, ConfigGUI.getStrings("CFG_RITUAL_BLOODY_HEADS"));
        ConfigGUI.setButtonInt(menu, 17, "ritual.pactes.forgotten.weakness", value -> Math.max(0, Math.min(255, value)), 1, ConfigGUI.getStrings("CFG_RITUAL_FORGOTTEN_WEAKNESS"));
        ConfigGUI.setButtonValues(menu, 28, "ritual.animation.time-incr", Arrays.asList(1, 2, 3, 4, 5, 6, 8, 9, 10, 12, 15, 16, 18, 20, 24, 25, 30, 36, 40, 45, 48, 50, 60, 72, 75, 80, 90, 100, 120, 125, 144, 150, 180, 200, 225, 240, 250, 300, 360, 375, 400, 450, 500, 600, 720, 750, 900, 1000, 1125, 1200, 1500, 1800, 2000, 2250, 3000, 3600, 4500, 6000, 9000, 18000), ConfigGUI.getStrings("CFG_RITUAL_ANIM_TIMEINCR"));
        ConfigGUI.setButtonColor(menu, 29, "ritual.animation.color", ConfigGUI.getStrings("CFG_RITUAL_ANIM_COLOR"));
        ConfigGUI.setButtonDouble(menu, 30, "ritual.animation.size", value -> Math.max(0.1, Math.min(10.0, value)), 0.1, ConfigGUI.getStrings("CFG_RITUAL_ANIM_SIZE"));
        ConfigGUI.setButtonInt(menu, 32, "ritual.animation.lightning-quantity", value -> Math.max(0, value), 1, ConfigGUI.getStrings("CFG_RITUAL_ANIM_LIGHTNING_QT"));
        ConfigGUI.setButtonInt(menu, 33, "ritual.animation.lightning-interval", value -> Math.max(0, value), 1, ConfigGUI.getStrings("CFG_RITUAL_ANIM_LIGHTNING_INTERVAL"));
        ConfigGUI.setButtonDouble(menu, 37, "ritual.animation.sphere.radius", value -> Math.max(0.5, Math.min(5.0, value)), 0.1, ConfigGUI.getStrings("CFG_RITUAL_SPH_RADIUS"));
        ConfigGUI.setButtonInt(menu, 38, "ritual.animation.sphere.quantity", value -> Math.max(0, value), 50, ConfigGUI.getStrings("CFG_RITUAL_SPH_QT"));
        ConfigGUI.setButtonColor(menu, 39, "ritual.animation.sphere.color", ConfigGUI.getStrings("CFG_RITUAL_SPH_COLOR"));
        ConfigGUI.setButtonNote(menu, 40, "CFG_RITUAL_SPH_NOTE");
        ConfigGUI.setButtonDouble(menu, 41, "ritual.animation.sphere.size", value -> Math.max(0.1, Math.min(10.0, value)), 0.1, ConfigGUI.getStrings("CFG_RITUAL_SPH_SIZE"));
        ConfigGUI.setButtonInt(menu, 42, "ritual.animation.sphere.lava-chance", value -> Math.max(0, Math.min(100, value)), 1, ConfigGUI.getStrings("CFG_RITUAL_SPH_LAVACHANCE"));
        ConfigGUI.setButtonBool(menu, 43, "ritual.animation.sphere.lava-sound", ConfigGUI.getStrings("CFG_RITUAL_SPH_LAVASOUND"));
        ConfigGUI.setButtonDouble(menu, 46, "ritual.accepted.lava-radius", value -> Math.max(0.5, Math.min(5.0, value)), 0.1, ConfigGUI.getStrings("CFG_RITUAL_ACC_LAVARADIUS"));
        ConfigGUI.setButtonInt(menu, 47, "ritual.accepted.lava-quantity", value -> Math.max(0, value), 50, ConfigGUI.getStrings("CFG_RITUAL_ACC_LAVAQT"));
        ConfigGUI.setButtonBool(menu, 48, "ritual.accepted.lava-sound", ConfigGUI.getStrings("CFG_RITUAL_ACC_LAVASOUND"));
        ConfigGUI.setButtonNote(menu, 49, "CFG_RITUAL_ACC_NOTE");
        ConfigGUI.setButtonInt(menu, 50, "ritual.accepted.flame-quantity", value -> Math.max(0, value), 50, ConfigGUI.getStrings("CFG_RITUAL_ACC_FLAMEQT"));
        ConfigGUI.setButtonDouble(menu, 51, "ritual.accepted.flame-speed", value -> Math.max(0.1, Math.min(5.0, value)), 0.1, ConfigGUI.getStrings("CFG_RITUAL_ACC_FLAMESPEED"));
        ConfigGUI.setButtonBool(menu, 52, "ritual.accepted.flame-soul", ConfigGUI.getStrings("CFG_RITUAL_ACC_FLAMESOUL"));
        return menu;
    }

    public static SGMenu getOtherMenu() {
        SGMenu menu = KamoofPlugin.getSpiGUI().create("\u00a7a\u00a7l" + Lang.get("CFG_TITLE") + ": \u00a77\u00a7l" + Lang.get("CFG_TITLE_OTHER"), 3);
        ConfigGUI.fill(menu, Material.BLACK_STAINED_GLASS_PANE);
        ConfigGUI.setButtonMainMenu(menu, 4);
        ConfigGUI.setButtonBool(menu, 10, "macelimiter.enabled", ConfigGUI.getStrings("CFG_MACELIMIT_ENABLED"));
        ConfigGUI.setButtonInt(menu, 11, "macelimiter.limit", value -> Math.max(0, value), 1, ConfigGUI.getStrings("CFG_MACELIMIT_LIMIT"));
        ConfigGUI.setButtonBool(menu, 12, "macelimiter.no-enderchest", ConfigGUI.getStrings("CFG_MACELIMIT_EC"));
        ConfigGUI.setButtonBool(menu, 15, "autoupdate.fetch", ConfigGUI.getStrings("CFG_AUTOUPDATE_FETCH"));
        ConfigGUI.setButtonBool(menu, 16, "autoupdate.download", ConfigGUI.getStrings("CFG_AUTOUPDATE_DOWNLOAD"));
        return menu;
    }

    private static void setButtonMainMenu(SGMenu menu, int slot) {
        ItemStack item = new ItemStack(Material.ARROW);
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(ItemFlag.values());
        meta.setDisplayName("\u00a77" + Lang.get("CFG_GO_BACK"));
        item.setItemMeta(meta);
        menu.setButton(slot, new SGButton(item).withListener(event -> event.getWhoClicked().openInventory(ConfigGUI.getMainMenu().getInventory())));
    }

    private static void setButtonNote(SGMenu menu, int slot, String key) {
        ItemStack item = new ItemStack(Material.SPECTRAL_ARROW);
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(ItemFlag.values());
        meta.setDisplayName("\u00a7a\u00a7l" + Lang.get("CFG_NOTE"));
        ArrayList<CallSite> lore = new ArrayList<CallSite>();
        for (String part : Lang.get(key).replace("\u00a7r", "\u00a7a").split("\\|")) {
            String[] partSplit = part.split("\\s");
            int i = 0;
            while (i < partSplit.length) {
                StringBuilder line = new StringBuilder();
                while (line.length() < 40 && i < partSplit.length) {
                    line.append(partSplit[i]).append(" ");
                    ++i;
                }
                lore.add((CallSite)((Object)("\u00a7a" + String.valueOf(line))));
            }
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        menu.setButton(slot, new SGButton(item));
    }

    private static void setButtonBool(SGMenu menu, int slot, String path, Duo<String, ArrayList<String>> strings) {
        boolean enabled = KamoofPlugin.config().getBoolean(path);
        ItemStack item = new ItemStack(enabled ? Material.LIME_WOOL : Material.RED_WOOL);
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(ItemFlag.values());
        meta.setDisplayName((enabled ? "\u00a7a" : "\u00a7c") + "\u00a7l" + strings.getA());
        meta.setLore((List)strings.getB());
        item.setItemMeta(meta);
        menu.setButton(slot, new SGButton(item).withListener(event -> {
            KamoofPlugin.config().set(path, (Object)(!enabled ? 1 : 0));
            KamoofPlugin.getInstance().saveConfig();
            FeatureManager.refresh();
            ConfigGUI.setButtonBool(menu, slot, path, strings);
            menu.refreshInventory(event.getWhoClicked());
        }));
    }

    private static void setButtonInt(SGMenu menu, int slot, String path, Function<Integer, Integer> validate, int incr, Duo<String, ArrayList<String>> strings) {
        int value = KamoofPlugin.config().getInt(path);
        ItemStack item = new ItemStack(Material.YELLOW_WOOL, Math.max(1, Math.min(64, (int)Math.floor((double)value / (double)incr))));
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(ItemFlag.values());
        meta.setDisplayName("\u00a7e\u00a7l" + strings.getA() + ": \u00a76\u00a7l" + value);
        meta.setLore((List)strings.getB());
        item.setItemMeta(meta);
        menu.setButton(slot, new SGButton(item).withListener(event -> {
            int newValue = value;
            switch (event.getClick()) {
                case LEFT: {
                    newValue += incr;
                    break;
                }
                case RIGHT: {
                    newValue -= incr;
                }
            }
            newValue = (Integer)validate.apply(newValue);
            KamoofPlugin.config().set(path, (Object)newValue);
            KamoofPlugin.getInstance().saveConfig();
            ConfigGUI.setButtonInt(menu, slot, path, validate, incr, strings);
            menu.refreshInventory(event.getWhoClicked());
        }));
    }

    private static void setButtonDouble(SGMenu menu, int slot, String path, Function<Double, Double> validate, double incr, Duo<String, ArrayList<String>> strings) {
        double value = KamoofPlugin.config().getDouble(path);
        ItemStack item = new ItemStack(Material.ORANGE_WOOL, Math.max(1, Math.min(64, (int)Math.floor(value / incr))));
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(ItemFlag.values());
        meta.setDisplayName("\u00a7e\u00a7l" + strings.getA() + ": \u00a76\u00a7l" + value);
        meta.setLore((List)strings.getB());
        item.setItemMeta(meta);
        menu.setButton(slot, new SGButton(item).withListener(event -> {
            double newValue = value;
            switch (event.getClick()) {
                case LEFT: {
                    newValue += incr;
                    break;
                }
                case RIGHT: {
                    newValue -= incr;
                }
            }
            newValue = (double)Math.round(newValue * 1000.0) / 1000.0;
            newValue = (Double)validate.apply(newValue);
            KamoofPlugin.config().set(path, (Object)newValue);
            KamoofPlugin.getInstance().saveConfig();
            ConfigGUI.setButtonDouble(menu, slot, path, validate, incr, strings);
            menu.refreshInventory(event.getWhoClicked());
        }));
    }

    private static void setButtonValues(SGMenu menu, int slot, String path, List<?> values, Duo<String, ArrayList<String>> strings) {
        Object value = KamoofPlugin.config().get(path);
        ItemStack item = new ItemStack(Material.WHITE_WOOL);
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(ItemFlag.values());
        meta.setDisplayName("\u00a7e\u00a7l" + strings.getA() + ": \u00a76\u00a7l" + String.valueOf(value));
        meta.setLore((List)strings.getB());
        item.setItemMeta(meta);
        menu.setButton(slot, new SGButton(item).withListener(event -> {
            int index = 0;
            switch (event.getClick()) {
                case LEFT: {
                    try {
                        index = (values.indexOf(value) + 1) % values.size();
                    }
                    catch (Throwable exc) {
                        index = 0;
                    }
                    break;
                }
                case RIGHT: {
                    try {
                        index = (values.indexOf(value) - 1) % values.size();
                        if (index >= 0) break;
                        index = values.size() - 1;
                        break;
                    }
                    catch (Throwable exc) {
                        index = 0;
                    }
                }
            }
            KamoofPlugin.config().set(path, values.get(index));
            KamoofPlugin.getInstance().saveConfig();
            ConfigGUI.setButtonValues(menu, slot, path, values, strings);
            menu.refreshInventory(event.getWhoClicked());
        }));
    }

    private static void setButtonString(SGMenu menu, int slot, String path, Predicate<String> predicate, Duo<String, ArrayList<String>> strings) {
        String value = KamoofPlugin.config().getString(path);
        ItemStack item = new ItemStack(Material.CYAN_WOOL);
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(ItemFlag.values());
        meta.setDisplayName("\u00a73\u00a7l" + strings.getA() + ": \u00a76\u00a7l" + value);
        meta.setLore((List)strings.getB());
        item.setItemMeta(meta);
        menu.setButton(slot, new SGButton(item).withListener(event -> {
            HumanEntity patt0$temp = event.getWhoClicked();
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = (Player)patt0$temp;
            new AnvilGUI.Builder().plugin((Plugin)KamoofPlugin.getInstance()).title("\u00a73\u00a7l" + (String)strings.getA()).text(value).onClick((clickedSlot, stateSnapshot) -> {
                if (clickedSlot != 2) {
                    return List.of();
                }
                String newValue = stateSnapshot.getText().trim();
                if (predicate.test(newValue)) {
                    KamoofPlugin.config().set(path, (Object)newValue);
                    KamoofPlugin.getInstance().saveConfig();
                    ConfigGUI.setButtonString(menu, slot, path, predicate, strings);
                    return List.of(AnvilGUI.ResponseAction.close());
                }
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, Message.toBaseComponent(Lang.get("CFG_INVALID_VALUE")));
                player.playSound(player.getLocation(), Sound.ITEM_SHIELD_BLOCK, SoundCategory.MASTER, 0.3f, 1.5f);
                return List.of(AnvilGUI.ResponseAction.close());
            }).onClose(stateSnapshot -> stateSnapshot.getPlayer().openInventory(menu.getInventory())).open(player);
        }));
    }

    private static void setButtonColor(SGMenu menu, int slot, String path, Duo<String, ArrayList<String>> strings) {
        String value = KamoofPlugin.config().getString(path).toLowerCase().trim();
        Color color = ColorResolver.getColor(value);
        ItemStack item = new ItemStack(Material.CYAN_WOOL);
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(ItemFlag.values());
        meta.setDisplayName("\u00a73\u00a7l" + strings.getA() + ": " + ColorResolver.toLegacy(color) + "\u00a7l" + value);
        meta.setLore((List)strings.getB());
        item.setItemMeta(meta);
        menu.setButton(slot, new SGButton(item).withListener(event -> {
            HumanEntity patt0$temp = event.getWhoClicked();
            if (!(patt0$temp instanceof Player)) {
                return;
            }
            Player player = (Player)patt0$temp;
            new AnvilGUI.Builder().plugin((Plugin)KamoofPlugin.getInstance()).title("\u00a73\u00a7l" + (String)strings.getA()).text(value).onClick((clickedSlot, stateSnapshot) -> {
                if (clickedSlot != 2) {
                    return List.of();
                }
                String newValue = stateSnapshot.getText().trim();
                Color newColor = ColorResolver.getColor(newValue);
                if (newColor != null) {
                    KamoofPlugin.config().set(path, (Object)newValue);
                    KamoofPlugin.getInstance().saveConfig();
                    ConfigGUI.setButtonColor(menu, slot, path, strings);
                    return List.of(AnvilGUI.ResponseAction.close());
                }
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, Message.toBaseComponent(Lang.get("CFG_INVALID_VALUE")));
                player.playSound(player.getLocation(), Sound.ITEM_SHIELD_BLOCK, SoundCategory.MASTER, 0.3f, 1.5f);
                return List.of(AnvilGUI.ResponseAction.close());
            }).onClose(stateSnapshot -> stateSnapshot.getPlayer().openInventory(menu.getInventory())).open(player);
        }));
    }

    private static Duo<String, ArrayList<String>> getStrings(String key) {
        ArrayList<CallSite> lore = new ArrayList<CallSite>();
        String[] split = Lang.get(key).split("\\|", 2);
        for (String part : split[1].replace("\u00a7r", "\u00a77").split("\\|")) {
            String[] partSplit = part.split("\\s");
            int i = 0;
            while (i < partSplit.length) {
                StringBuilder line = new StringBuilder();
                while (line.length() < 40 && i < partSplit.length) {
                    line.append(partSplit[i]).append(" ");
                    ++i;
                }
                lore.add((CallSite)((Object)("\u00a77" + String.valueOf(line))));
            }
        }
        return new Duo<String, ArrayList<String>>(split[0], lore);
    }
}

