/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.commands;

import im.ghosty.kamoof.KamoofPlugin;
import im.ghosty.kamoof.api.KamoofSMP;
import im.ghosty.kamoof.commands.ConfigGUI;
import im.ghosty.kamoof.commands.GiveHeadCMD;
import im.ghosty.kamoof.deps.xyz.haoshoku.nick.NickAPI;
import im.ghosty.kamoof.features.other.JoinMessages;
import im.ghosty.kamoof.features.ritual.RitualBook;
import im.ghosty.kamoof.features.ritual.RitualHandler;
import im.ghosty.kamoof.features.ritual.RitualSetup;
import im.ghosty.kamoof.utils.CompatibilityUtils;
import im.ghosty.kamoof.utils.Lang;
import im.ghosty.kamoof.utils.Message;
import im.ghosty.kamoof.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class KamoofCMD
implements CommandExecutor,
TabCompleter {
    private static final List<String> validArgs = Arrays.asList("info", "config", "reload", "setup", "givehead", "undisguise");
    private static final List<String> devArgs = new ArrayList<String>(validArgs);

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            Lang.send(sender, "PLAYER_ONLY", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 2 && args[0].equalsIgnoreCase("pacte")) {
            if (!args[1].equalsIgnoreCase("1") && !args[1].equalsIgnoreCase("2")) {
                return true;
            }
            ItemStack book = player.getInventory().getItemInMainHand();
            UUID uuid = RitualBook.getUUID(book);
            if (uuid == null && (uuid = RitualBook.getUUID(book = player.getInventory().getItemInOffHand())) == null) {
                return true;
            }
            if (RitualHandler.getPacte(player) != null) {
                Message.send((CommandSender)player, "messages.already-chose", Map.of("player", KamoofSMP.getInstance().getName((OfflinePlayer)player)));
                return true;
            }
            if (!RitualHandler.isValidUUID(uuid)) {
                return true;
            }
            book.setAmount(0);
            RitualHandler.setPacte(player, args[1]);
            return true;
        }
        if (!player.hasPermission("kamoofsmp.admin")) {
            return this.showCredits(sender);
        }
        if (args.length == 0) {
            return this.showArgs(sender);
        }
        switch (args[0].toLowerCase()) {
            case "info": {
                return this.showCredits((CommandSender)player);
            }
            case "config": {
                player.openInventory(ConfigGUI.getMainMenu().getInventory());
                return true;
            }
            case "givehead": {
                if (args.length < 2) {
                    player.sendMessage(String.format("\u00a7a\u00a7l[KamoofSMP] \u00a7cUsage: /%s givehead <username>", label.toLowerCase()));
                    return true;
                }
                GiveHeadCMD.execute(player, args[1]);
                return true;
            }
            case "reload": {
                KamoofPlugin.getInstance().reloadConfig();
                try {
                    NickAPI.setupConfig(new File(KamoofPlugin.getInstance().getDataFolder(), "nickapi.yml"));
                }
                catch (IOException e) {
                    NickAPI.setupConfig((ConfigurationSection)null);
                }
                Lang.init();
                Lang.send((CommandSender)player, "CONFIG_RELOADED", new Object[0]);
                return true;
            }
            case "setup": {
                if (!CompatibilityUtils.isMinecraft1_21()) {
                    Lang.send((CommandSender)player, "NOT_MINECRAFT_1_21", new Object[0]);
                    return true;
                }
                if (!KamoofPlugin.config().getBoolean("ritual.enabled")) {
                    Lang.send((CommandSender)player, "RITUAL_DISABLED", new Object[0]);
                    return true;
                }
                if (player.getInventory().addItem(RitualSetup.getItems()).isEmpty()) {
                    Lang.send((CommandSender)player, "SETUP_GIVEN", new Object[0]);
                } else {
                    Lang.send((CommandSender)player, "INVENTORY_FULL", new Object[0]);
                }
                return true;
            }
            case "undisguise": {
                if (args.length < 2) {
                    StringBuilder message = new StringBuilder("<green><b>[KamoofSMP] <reset><yellow><b>Undisguise:<reset>");
                    HashMap<String, String> disguises = this.getDisguised();
                    if (!disguises.isEmpty()) {
                        List keys = disguises.keySet().stream().toList();
                        List<String> values = disguises.values().stream().toList();
                        for (int i = 0; i < disguises.size(); ++i) {
                            String key = (String)keys.get(i);
                            String value = values.get(i);
                            message.append(String.format("<br><click:run_command:'/kamoofsmp undisguise %s'><hover:show_text:\"" + Lang.get("UNDISGUISE_HOVER") + "\"><white>%s <gray>\u2192 <#ffddff>%s</hover></click>", key, key, key, value));
                        }
                    } else {
                        message.append(Lang.get("UNDISGUISE_NONE"));
                    }
                    Message.send((CommandSender)player, message.toString());
                    return true;
                }
                String name = args[1];
                OfflinePlayer target = Bukkit.getOfflinePlayer((String)name);
                KamoofSMP.getInstance().disguise(target, null);
                Lang.send((CommandSender)player, "UNDISGUISED", KamoofSMP.getInstance().getName(target));
                return true;
            }
            case "english": {
                KamoofPlugin.config().set("language", (Object)"en");
                KamoofPlugin.getInstance().saveConfig();
                Lang.init();
                JoinMessages.done = false;
                KamoofPlugin.data().set("firstJoinMsg", (Object)false);
                KamoofPlugin.saveData();
                String message = "<green><b>[KamoofSMP] <reset><white>The language has been set to <b>English</b>!<br>Reconnect to receive the first-time instructions in English as well.";
                Message.send((CommandSender)player, message);
                return true;
            }
            case "pacterun": {
                RitualHandler.runAnimation(player);
                return true;
            }
            case "pactebook": {
                player.getWorld().dropItemNaturally(player.getLocation(), RitualBook.getBook(RitualHandler.addNewUUID()));
                return true;
            }
            case "ignorespigotcrash": {
                JoinMessages.ignoreSpigot = true;
                KamoofPlugin.data().set("ignoreSpigotCrash", (Object)true);
                KamoofPlugin.saveData();
                Lang.send((CommandSender)player, "SPIGOT_IGNORED", new Object[0]);
                return true;
            }
            case "removenickapi": {
                String fileName = null;
                try {
                    File file = Utils.findNickAPIFile();
                    fileName = file.getName();
                    file = Utils.getParentPluginFile(file.toURI().toURL());
                    Files.delete(Path.of(file.getPath(), new String[0]));
                    Lang.send((CommandSender)player, "NICKAPI_REMOVED", new Object[0]);
                }
                catch (Throwable exc) {
                    exc.printStackTrace();
                    Lang.send((CommandSender)player, "NICKAPI_REMOVE_FAIL" + (fileName == null ? "_WHAT" : ""), fileName);
                }
                return true;
            }
            case "debug": {
                boolean val = !KamoofPlugin.data().getBoolean("debug", false);
                KamoofPlugin.data().set("debug", (Object)val);
                KamoofPlugin.saveData();
                Message.send((CommandSender)player, "<green><b>[KamoofSMP] <reset>" + (val ? "<b><white>DEBUG MODE!! :3" : "<red>Debug Mode disabled."));
                return true;
            }
        }
        return this.showArgs((CommandSender)player);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (sender.hasPermission("kamoofsmp.admin")) {
            if (args.length <= 1) {
                return KamoofPlugin.data().getBoolean("debug", false) ? devArgs : validArgs;
            }
            if (args[0].equalsIgnoreCase("givehead")) {
                ArrayList<String> values = new ArrayList<String>();
                for (OfflinePlayer player2 : Bukkit.getOfflinePlayers()) {
                    if (player2 == null || player2.getName() == null) continue;
                    values.add(player2.getName());
                }
                if (args.length == 2) {
                    String toCheck = args[1].toLowerCase().trim();
                    values.removeIf(player -> !player.toLowerCase().trim().contains(toCheck));
                }
                return values;
            }
            if (args[0].equalsIgnoreCase("undisguise")) {
                ArrayList<String> values = new ArrayList<String>(this.getDisguised().keySet());
                if (args.length == 2) {
                    String toCheck = args[1].toLowerCase().trim();
                    values.removeIf(player -> !player.toLowerCase().trim().contains(toCheck));
                }
                return values;
            }
        }
        return List.of();
    }

    public HashMap<String, String> getDisguised() {
        HashMap<String, String> values = new HashMap<String, String>();
        for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
            String disguise;
            if (player == null || player.getName() == null || (disguise = KamoofSMP.getInstance().getDisguise(player)) == null) continue;
            values.put(KamoofSMP.getInstance().getName(player), disguise);
        }
        return values;
    }

    public boolean showArgs(CommandSender sender) {
        String version = KamoofPlugin.getInstance().getDescription().getVersion();
        Lang.send(sender, "MAIN_ARGUMENTS", version);
        return true;
    }

    public boolean showCredits(CommandSender sender) {
        String version = KamoofPlugin.getInstance().getDescription().getVersion();
        Lang.send(sender, "CREDITS", version, "https://ghosty.im/discord?from=camouf2");
        return true;
    }

    static {
        devArgs.addAll(Arrays.asList("english", "pacterun", "pactebook", "ignorespigotcrash", "removenickapi", "debug"));
    }
}

