/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.deps.xyz.haoshoku.nick;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import im.ghosty.kamoof.deps.xyz.haoshoku.nick.NickAPI;
import im.ghosty.kamoof.deps.xyz.haoshoku.nick.user.NickHandler;
import im.ghosty.kamoof.deps.xyz.haoshoku.nick.user.NickUser;
import im.ghosty.kamoof.deps.xyz.haoshoku.nick.utils.Profile;
import im.ghosty.kamoof.deps.xyz.haoshoku.nick.utils.Reflection;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class NickListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onPreLogin(AsyncPlayerPreLoginEvent event) {
        UUID uuid = event.getUniqueId();
        String name = event.getName();
        for (Player online : Bukkit.getOnlinePlayers()) {
            if (!online.getUniqueId().equals(uuid)) continue;
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, "You *are* already online.");
            return;
        }
        NickUser user = NickHandler.createUser(uuid);
        if (NickAPI.getConfig().isCracked()) {
            UUID originalUUID = NickAPI.getUUIDFetcher().getUUIDByName(name);
            String[] data = NickAPI.getSkinFetcher().getSkinDataByUUID(originalUUID);
            if (data[0].equals("NoValue") && data[1].equals("NoSignature")) {
                data = new String[]{"ewogICJ0aW1lc3RhbXAiIDogMTYwMTU3NzgwNTM1MywKICAicHJvZmlsZUlkIiA6ICI4NTdmNGRkYjlkMTM0ZWZmYWE1Zjk0NWE0YWEyYWJmNiIsCiAgInByb2ZpbGVOYW1lIiA6ICIxMzM3RW1wdHkxMzM3IiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLzFhNGFmNzE4NDU1ZDRhYWI1MjhlN2E2MWY4NmZhMjVlNmEzNjlkMTc2OGRjYjEzZjdkZjMxOWE3MTNlYjgxMGIiCiAgICB9CiAgfQp9", "WFMBccFE/QDje43+G3cToZGasu6mYQW//QvN9J5u+wDPNq1S1DZylkyrLMywNuUV2xy7GXLJVYtY5MJteaWK2tkq43h3IheVVFGAyb6W9m56gOwKNItDU5IZs2JpZ/6W78HjhX3HOsPWYRXDW4GbRBpdKrpp+4FQfktPv1OabBEF0jrwMx2q7W1rw4s9BensyB1D3dJK0+mrnGFbJ4pZzn9WfjsNLBJrJZp5OCEwgLasK8s7Z4JoGETzErRdqcXVJZZe2Rt4GYWCzo+cSqYLeWrS7uuevVEoazpu/v8WlzcQ+TzGmRuZVYYcpZJHIgd+2qQPALCIEk8o0mKdWQ7QaBM/TMk1eiynaj2vofoVYuIbs3ye6WasgBmmjQbvISTwOFheecoJ9nAcRkdgfmj8zg2o8Sxju8Vb8nv9duTU7iJ3LrTQplgOZlJBz2fWGbwVZDvFkf2mVJPQASQgFl6nM6orBXgFkki3Xqq25kSfTJEj4ISO83yxq5ZSyUEuiB6ul/TrMBzDtBwcrZ8K3jHfHFCttZ6hffKKnOxF1iLWRDh0Gg9favqIdLYSQ9wEBEWG0lqBRNxOgl0itMx7Lr57f/1Mo6UpUscUSZUZt3zN+eF1NIwLy+C4NT9nQV93Hsqe/XPw9ZEuCaph6z5NRzILZBhPMi8Mn/n/mKYwS7l2Aq8="};
            }
            user.setOriginalSkinData(data);
        }
        user.setLogin(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        String message = event.getMessage();
        for (Map.Entry<UUID, String> entry : NickAPI.getNickedPlayers().entrySet()) {
            Player target = Bukkit.getPlayer((UUID)entry.getKey());
            String name = entry.getValue();
            if (NickAPI.getConfig().isCommandSupportRemoveOriginalName() && NickAPI.getConfig().getCommandOriginalPlayerReplacement() != null) {
                message = message.replaceAll("(?i)" + NickAPI.getOriginalName(target), NickAPI.getConfig().getCommandOriginalPlayerReplacement());
            }
            if (message.toLowerCase().contains(name.toLowerCase()) && NickAPI.getConfig().isCommandSupportForNickNames()) {
                message = message.replaceAll("(?i)" + name, NickAPI.getOriginalName(target));
            }
            event.setMessage(message);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        NickUser user = NickHandler.getUser(player);
        if (user != null) {
            NickAPI.getHandler().getIInject().inject(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onJoinHighest(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        NickUser user = NickHandler.getUser(player);
        user.setNickAble(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onKick(PlayerKickEvent event) {
        Player player = event.getPlayer();
        NickUser user = NickHandler.getUser(player);
        if (user != null) {
            NickAPI.resetGameProfileName(player);
        }
        NickAPI.getHandler().getIInject().uninject(player);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onLogin(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        for (Player online : Bukkit.getOnlinePlayers()) {
            if (!online.getUniqueId().equals(player.getUniqueId())) continue;
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, "You *are* already online.");
            return;
        }
        NickUser user = NickHandler.getUser(player);
        if (user == null) {
            user = NickHandler.createUser(player.getUniqueId());
        }
        if (!user.isLogin()) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, "The server is starting up.");
            return;
        }
        user.setPlayer(player);
        if (NickAPI.getConfig().isCracked()) {
            GameProfile profile = Reflection.getGameProfile(player);
            PropertyMap prop = Profile.prop(profile);
            prop.removeAll((Object)"textures");
            prop.put((Object)"textures", (Object)new Property("textures", user.getOriginalSkinData()[0], user.getOriginalSkinData()[1]));
        }
        NickAPI.getHandler().getIInject().applyGameProfile(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        NickUser user = NickHandler.getUser(player);
        if (user != null) {
            NickAPI.resetGameProfileName(player);
        }
        NickAPI.getHandler().getIInject().uninject(player);
    }
}

