/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.deps.xyz.haoshoku.nick.impl;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import im.ghosty.kamoof.deps.xyz.haoshoku.nick.NickAPI;
import im.ghosty.kamoof.deps.xyz.haoshoku.nick.user.NickHandler;
import im.ghosty.kamoof.deps.xyz.haoshoku.nick.user.NickUser;
import im.ghosty.kamoof.deps.xyz.haoshoku.nick.utils.NickUtils;
import im.ghosty.kamoof.deps.xyz.haoshoku.nick.utils.Profile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public abstract class AImplement {
    public void nick(Player player, String toNick) {
        if (player == null || !player.isOnline()) {
            return;
        }
        NickUser user = NickHandler.getUser(player);
        if (toNick.length() >= 16) {
            toNick = toNick.substring(0, 16);
        }
        user.getQueueMap().put("SetTag", toNick);
        Profile.changeName(user, toNick);
        user.setNickSet(true);
    }

    public void resetNick(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        NickUser user = NickHandler.getUser(player);
        user.getQueueMap().put("ResetTag", true);
        user.setNickSet(false);
    }

    public boolean isNicked(Player player) {
        return player != null && player.isOnline() && NickHandler.getUser(player).isNickSet();
    }

    public boolean isSkinChanged(Player player) {
        return player != null && player.isOnline() && NickHandler.getUser(player).isSkinSet();
    }

    public void setSkin(Player player, String toSkin) {
        if (player == null || !player.isOnline()) {
            return;
        }
        NickUser user = NickHandler.getUser(player);
        user.getQueueMap().put("SetSkin", toSkin);
        user.setSkinSet(true);
    }

    public void setSkin(Player player, String value, String signature) {
        if (player == null || !player.isOnline()) {
            return;
        }
        NickUser user = NickHandler.getUser(player);
        user.getQueueMap().put("SetSkin", new String[]{value, signature});
        user.setSkinSet(true);
    }

    public void resetSkin(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        NickUser user = NickHandler.getUser(player);
        user.getQueueMap().put("ResetSkin", true);
        user.setSkinSet(false);
    }

    public String getOriginalGameProfileName(Player player) {
        if (player == null || !player.isOnline()) {
            return "null";
        }
        return NickHandler.getUser(player).getOriginalName();
    }

    public String[] getSkinData(Player player) {
        if (player == null || !player.isOnline()) {
            return new String[]{"null", "null"};
        }
        NickUser user = NickHandler.getUser(player);
        GameProfile profile = user.getNickProfile();
        String value = "";
        String signature = "";
        for (Property property : Profile.prop(profile).get((Object)"textures")) {
            String[] properties = NickUtils.getSkinProperties(property);
            value = properties[0];
            signature = properties[1];
        }
        return new String[]{value, signature};
    }

    public String getGameProfileName(Player player) {
        if (player == null || !player.isOnline()) {
            return "null";
        }
        return Profile.name(NickHandler.getUser(player).getOriginalProfile());
    }

    public void setGameProfileName(Player player, String name) {
        if (player == null || !player.isOnline()) {
            return;
        }
        if (name.length() > 16) {
            name = name.substring(0, 16);
        }
        if (NickAPI.getConfig().isGameProfileChanges()) {
            Profile.changeNameOrig(NickHandler.getUser(player), name);
        }
    }

    public void resetGameProfileName(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        if (NickAPI.getConfig().isGameProfileChanges()) {
            Profile.changeNameOrig(NickHandler.getUser(player), NickAPI.getOriginalGameProfileName(player));
        }
    }

    public UUID getUniqueId(Player player) {
        if (player == null || !player.isOnline()) {
            return null;
        }
        return Profile.id(NickHandler.getUser(player).getNickProfile());
    }

    public void setUniqueId(Player player, UUID uuid) {
        if (player == null || !player.isOnline()) {
            return;
        }
        NickHandler.getUser(player).getQueueMap().put("SetUUID", uuid);
    }

    public void setUniqueId(Player player, String name) {
        if (player == null || !player.isOnline()) {
            return;
        }
        NickHandler.getUser(player).getQueueMap().put("SetUUID", name);
    }

    public void resetUniqueId(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        NickHandler.getUser(player).getQueueMap().put("ResetUUID", true);
    }

    public Player getPlayerOfOriginalName(String name) {
        for (NickUser user : NickHandler.getUsers()) {
            if (user == null || user.getOriginalName() == null || !user.getOriginalName().equalsIgnoreCase(name)) continue;
            return user.getPlayer();
        }
        return null;
    }

    public Player getPlayerOfNickedName(String name) {
        for (NickUser user : NickHandler.getUsers()) {
            if (user == null || user.getNickProfile() == null || !Profile.name(user.getNickProfile()).equalsIgnoreCase(name)) continue;
            return user.getPlayer();
        }
        return null;
    }

    public boolean nickExists(String name) {
        for (NickUser user : NickHandler.getUsers()) {
            if (user == null || user.getOriginalProfile() == null || user.getNickProfile() == null || !Profile.name(user.getOriginalProfile()).equalsIgnoreCase(name) && !Profile.name(user.getNickProfile()).equalsIgnoreCase(name) && !NickAPI.getOriginalName(user.getPlayer()).equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isNickedName(String name) {
        for (NickUser user : NickHandler.getUsers()) {
            if (user == null || user.getNickProfile() == null || Profile.name(user.getNickProfile()) == null || !Profile.name(user.getNickProfile()).equalsIgnoreCase(name) || NickAPI.getOriginalName(user.getPlayer()).equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public Map<UUID, String> getNickedPlayers() {
        HashMap map = Maps.newHashMap();
        for (Player online : Bukkit.getOnlinePlayers()) {
            NickUser user = NickHandler.getUser(online);
            if (user == null || user.getOriginalName() == null || user.getNickProfile() == null || user.getOriginalName().equals(Profile.name(user.getNickProfile()))) continue;
            map.put(online.getUniqueId(), Profile.name(user.getNickProfile()));
        }
        return map;
    }

    public String getName(Player player) {
        if (player == null || !player.isOnline()) {
            return "null";
        }
        return Profile.name(NickHandler.getUser(player).getNickProfile());
    }

    public void refreshPlayerSync(Player player, boolean async) {
        NickUser user = NickHandler.getUser(player);
        if (user == null) {
            return;
        }
        Logger logger = Bukkit.getLogger();
        if (!player.isOnline()) {
            logger.log(Level.WARNING, "[NickAPI] Failed to nick player " + NickAPI.getOriginalName(player));
            logger.log(Level.WARNING, "[NickAPI] Player has not gone through PlayerJoinEvent");
            return;
        }
        if (user.getNickProfile() == null) {
            return;
        }
        if (!user.isNickAble()) {
            if (user.getNickAbleLoop() >= 5) {
                logger.log(Level.WARNING, "[NickAPI] Failed to nick player " + NickAPI.getOriginalName(player));
                logger.log(Level.WARNING, "[NickAPI] Tried several times to nick the player, but it failed because of the user data is not loaded correctly");
                logger.log(Level.WARNING, "[NickAPI] To prevent an infinite loop by calling delayed scheduler for an automatic fix, the nick process has been stopped now");
                logger.log(Level.WARNING, "[NickAPI] Please execute the method on PlayerJoinEvent at the earliest time");
                user.setNickAbleLoop(0);
                return;
            }
            Bukkit.getScheduler().runTaskLater(NickAPI.getPlugin(), () -> {
                if (player.isOnline()) {
                    this.refreshPlayerSync(player, async);
                    user.setNickAbleLoop(user.getNickAbleLoop() + 1);
                }
            }, 3L);
            return;
        }
        boolean respawnPacket = false;
        for (Map.Entry<String, Object> entry : user.getQueueMap().entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            switch (key) {
                case "AddBypass": {
                    UUID[] bypassPlayerArr;
                    for (UUID uuid : bypassPlayerArr = (UUID[])value) {
                        Player target = Bukkit.getPlayer((UUID)uuid);
                        if (target == null) continue;
                        this.removeInfoPacket(player, target);
                    }
                    break;
                }
                case "SetTag": {
                    String tag = (String)value;
                    Profile.changeName(user, tag);
                    respawnPacket = true;
                    break;
                }
                case "SetUUID": {
                    UUID uuid = UUID.randomUUID();
                    if (value instanceof String) {
                        String uuidName = (String)value;
                        uuid = NickAPI.getUUIDFetcher().getUUIDByName(uuidName);
                    }
                    for (Player online : Bukkit.getOnlinePlayers()) {
                        if (online == player) continue;
                        this.removeInfoPacket(player, online);
                    }
                    if (value instanceof UUID) {
                        uuid = (UUID)value;
                    }
                    Profile.changeId(user, uuid);
                    break;
                }
                case "SetSkin": {
                    Profile.prop(user.getNickProfile()).removeAll((Object)"textures");
                    String[] data = null;
                    if (value instanceof String[]) {
                        data = (String[])value;
                    }
                    if (value instanceof String) {
                        String name = (String)value;
                        UUID uuid = NickAPI.getUUIDFetcher().getUUIDByName(name);
                        data = NickAPI.getSkinFetcher().getSkinDataByUUID(uuid);
                        if (data[0].equals("NoValue") && data[1].equals("NoSignature")) {
                            data = new String[]{"ewogICJ0aW1lc3RhbXAiIDogMTYwMTU3NzgwNTM1MywKICAicHJvZmlsZUlkIiA6ICI4NTdmNGRkYjlkMTM0ZWZmYWE1Zjk0NWE0YWEyYWJmNiIsCiAgInByb2ZpbGVOYW1lIiA6ICIxMzM3RW1wdHkxMzM3IiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLzFhNGFmNzE4NDU1ZDRhYWI1MjhlN2E2MWY4NmZhMjVlNmEzNjlkMTc2OGRjYjEzZjdkZjMxOWE3MTNlYjgxMGIiCiAgICB9CiAgfQp9", "WFMBccFE/QDje43+G3cToZGasu6mYQW//QvN9J5u+wDPNq1S1DZylkyrLMywNuUV2xy7GXLJVYtY5MJteaWK2tkq43h3IheVVFGAyb6W9m56gOwKNItDU5IZs2JpZ/6W78HjhX3HOsPWYRXDW4GbRBpdKrpp+4FQfktPv1OabBEF0jrwMx2q7W1rw4s9BensyB1D3dJK0+mrnGFbJ4pZzn9WfjsNLBJrJZp5OCEwgLasK8s7Z4JoGETzErRdqcXVJZZe2Rt4GYWCzo+cSqYLeWrS7uuevVEoazpu/v8WlzcQ+TzGmRuZVYYcpZJHIgd+2qQPALCIEk8o0mKdWQ7QaBM/TMk1eiynaj2vofoVYuIbs3ye6WasgBmmjQbvISTwOFheecoJ9nAcRkdgfmj8zg2o8Sxju8Vb8nv9duTU7iJ3LrTQplgOZlJBz2fWGbwVZDvFkf2mVJPQASQgFl6nM6orBXgFkki3Xqq25kSfTJEj4ISO83yxq5ZSyUEuiB6ul/TrMBzDtBwcrZ8K3jHfHFCttZ6hffKKnOxF1iLWRDh0Gg9favqIdLYSQ9wEBEWG0lqBRNxOgl0itMx7Lr57f/1Mo6UpUscUSZUZt3zN+eF1NIwLy+C4NT9nQV93Hsqe/XPw9ZEuCaph6z5NRzILZBhPMi8Mn/n/mKYwS7l2Aq8="};
                        }
                    }
                    if (data == null) break;
                    user.setSkinData((String[])data.clone());
                    Profile.prop(user.getNickProfile()).put((Object)"textures", (Object)new Property("textures", data[0], data[1]));
                    respawnPacket = true;
                }
            }
        }
        for (Map.Entry<String, Object> entry : user.getQueueMap().entrySet()) {
            switch (entry.getKey()) {
                case "ResetUUID": {
                    for (Player online : Bukkit.getOnlinePlayers()) {
                        if (online == player) continue;
                        this.removeInfoPacket(player, online);
                    }
                    Profile.changeId(user, player.getUniqueId());
                    break;
                }
                case "ResetSkin": {
                    Profile.prop(user.getNickProfile()).removeAll((Object)"textures");
                    Profile.prop(user.getNickProfile()).put((Object)"textures", (Object)new Property("textures", user.getOriginalSkinData()[0], user.getOriginalSkinData()[1]));
                    user.setSkinData((String[])user.getOriginalSkinData().clone());
                    respawnPacket = true;
                    break;
                }
                case "ResetTag": {
                    Profile.changeName(user, user.getOriginalName());
                    respawnPacket = true;
                }
            }
        }
        user.getQueueMap().clear();
        if (async) {
            boolean finalRespawnPacket = respawnPacket;
            Bukkit.getScheduler().runTask(NickAPI.getPlugin(), () -> {
                if (!player.isOnline()) {
                    return;
                }
                this.sendPackets(player, finalRespawnPacket, NickAPI.getConfig().isSkinChanging());
                ArrayList<Player> canSeeList = new ArrayList<Player>();
                for (Player online : Bukkit.getOnlinePlayers()) {
                    if (!online.canSee(player)) continue;
                    canSeeList.add(online);
                    online.hidePlayer(player);
                }
                for (Player online : canSeeList) {
                    online.showPlayer(player);
                }
            });
        } else {
            this.sendPackets(player, respawnPacket, NickAPI.getConfig().isSkinChanging());
            ArrayList<Player> canSeeList = new ArrayList<Player>();
            for (Player online : Bukkit.getOnlinePlayers()) {
                if (!online.canSee(player)) continue;
                canSeeList.add(online);
                online.hidePlayer(player);
            }
            for (Player online : canSeeList) {
                online.showPlayer(player);
            }
        }
    }

    public void refreshPlayer(Player player) {
        Bukkit.getScheduler().runTaskLaterAsynchronously(NickAPI.getPlugin(), () -> this.refreshPlayerSync(player, true), 2L);
    }

    public void hidePlayer(Player player, Player toHide) {
        NickUser user = NickHandler.getUser(player);
        if (user == null) {
            return;
        }
        if (!player.isOnline() || !toHide.isOnline()) {
            return;
        }
        if (user.getFakeUUID() != null && user.getFakeUUID() != player.getUniqueId() && player != toHide) {
            this.removeInfoPacket(player, toHide);
        }
        if (player != toHide) {
            toHide.hidePlayer(player);
        }
        this.destroyPacket(player, toHide);
    }

    public void hidePlayerDelayed(Player player, Player toHide) {
        Bukkit.getScheduler().runTaskLater(NickAPI.getPlugin(), () -> this.hidePlayer(player, toHide), 1L);
    }

    public void hidePlayer(Player player, Collection<? extends Player> playersToHide) {
        for (Player player2 : playersToHide) {
            this.hidePlayerDelayed(player, player2);
        }
    }

    public void showPlayer(Player player, Player toShow) {
        toShow.showPlayer(player);
    }

    public void showPlayerDelayed(Player player, Player toShow) {
        Bukkit.getScheduler().runTaskLater(NickAPI.getPlugin(), () -> this.showPlayer(player, toShow), 1L);
    }

    public void showPlayer(Player player, Collection<? extends Player> playersToShow) {
        for (Player player2 : playersToShow) {
            this.showPlayer(player, player2);
        }
    }

    public abstract void removeInfoPacket(Player var1, Player var2);

    public abstract void destroyPacket(Player var1, Player var2);

    public abstract void sendPackets(Player var1, boolean var2, boolean var3);
}

