/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.deps.xyz.haoshoku.nick.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import im.ghosty.kamoof.deps.xyz.haoshoku.nick.NickAPI;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Bukkit;

public final class SkinFetcher {
    private final LoadingCache<UUID, String[]> cache = CacheBuilder.newBuilder().expireAfterWrite((long)NickAPI.getConfig().getCacheResetTimeSkin(), TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<UUID, String[]>(this){

        public String[] load(UUID uuid) throws Exception {
            try {
                if (NickAPI.getConfig().isMojangAPI()) {
                    URLConnection connection = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + String.valueOf(uuid) + "?unsigned=false").openConnection();
                    connection.setReadTimeout(3000);
                    JsonElement element = JsonParser.parseReader((Reader)new BufferedReader(new InputStreamReader(connection.getInputStream())));
                    JsonArray array = element.getAsJsonObject().get("properties").getAsJsonArray();
                    JsonElement dataElement = array.get(0);
                    String value = dataElement.getAsJsonObject().get("value").toString().replace("\"", "");
                    String signature = dataElement.getAsJsonObject().get("signature").toString().replace("\"", "");
                    return new String[]{value, signature};
                }
                URLConnection connection = new URL("https://api.minetools.eu/profile/" + String.valueOf(uuid)).openConnection();
                connection.setReadTimeout(3000);
                JsonElement element = JsonParser.parseReader((Reader)new BufferedReader(new InputStreamReader(connection.getInputStream())));
                JsonElement raw = element.getAsJsonObject().get("raw");
                JsonElement properties = raw.getAsJsonObject().get("properties");
                JsonElement array2 = properties.getAsJsonArray().get(0);
                String value2 = array2.getAsJsonObject().get("value").toString().replace("\"", "");
                String signature2 = array2.getAsJsonObject().get("signature").toString().replace("\"", "");
                return new String[]{value2, signature2};
            }
            catch (Exception ignore) {
                return new String[]{"NoValue", "NoSignature"};
            }
        }
    });

    public String[] getSkinDataByUUID(UUID uuid) {
        try {
            return (String[])this.cache.get((Object)uuid);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return new String[]{"NoValue", "NoSignature"};
        }
    }

    public void getSkinDataByUUIDAsync(UUID uuid, Consumer<String[]> consumer) {
        Bukkit.getScheduler().runTaskAsynchronously(NickAPI.getPlugin(), () -> consumer.accept(this.getSkinDataByUUID(uuid)));
    }

    public LoadingCache<UUID, String[]> getDataCache() {
        return this.cache;
    }
}

