/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.deps.xyz.haoshoku.nick.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.JsonParser;
import im.ghosty.kamoof.deps.xyz.haoshoku.nick.NickAPI;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Bukkit;

public final class UUIDFetcher {
    private final LoadingCache<String, UUID> cache = CacheBuilder.newBuilder().expireAfterWrite((long)NickAPI.getConfig().getCacheResetTimeUUID(), TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, UUID>(){

        public UUID load(String name) throws Exception {
            try {
                UUID uuid;
                if (NickAPI.getConfig().isMojangAPI()) {
                    URLConnection urlConnection = new URL("https://api.mojang.com/users/profiles/minecraft/" + name).openConnection();
                    urlConnection.setReadTimeout(3000);
                    String uuidAsString = JsonParser.parseReader((Reader)new InputStreamReader(urlConnection.getInputStream())).getAsJsonObject().get("id").toString().replace("\"", "");
                    uuid = UUIDFetcher.this.applyUniqueId(uuidAsString);
                } else {
                    URLConnection urlConnection = new URL("https://api.minetools.eu/uuid/" + name).openConnection();
                    urlConnection.setReadTimeout(3000);
                    String uuidAsString = JsonParser.parseReader((Reader)new InputStreamReader(urlConnection.getInputStream())).getAsJsonObject().get("id").toString().replace("\"", "");
                    if (uuidAsString.equals("null")) {
                        UUID uuid2 = UUID.randomUUID();
                        return uuid2;
                    }
                    uuid = UUIDFetcher.this.applyUniqueId(uuidAsString);
                }
                return uuid;
            }
            catch (Exception ignore) {
                return UUID.randomUUID();
            }
        }
    });

    public UUID getUUIDByName(String name) {
        try {
            return (UUID)this.cache.get((Object)name);
        }
        catch (ExecutionException e) {
            return UUID.randomUUID();
        }
    }

    private UUID applyUniqueId(String uuidAsString) {
        return UUID.fromString(new StringBuffer(uuidAsString).insert(8, "-").insert(13, "-").insert(18, "-").insert(23, "-").toString());
    }

    public void getUUIDByNameAsync(String name, Consumer<UUID> consumer) {
        Bukkit.getScheduler().runTaskAsynchronously(NickAPI.getPlugin(), () -> consumer.accept(this.getUUIDByName(name)));
    }

    public LoadingCache<String, UUID> getDataCache() {
        return this.cache;
    }
}

