/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.features.disguise;

import im.ghosty.kamoof.KamoofPlugin;
import im.ghosty.kamoof.api.KamoofSMP;
import im.ghosty.kamoof.deps.xyz.haoshoku.nick.NickAPI;
import im.ghosty.kamoof.features.Feature;
import im.ghosty.kamoof.features.disguise.DisguiseManager;
import im.ghosty.kamoof.utils.Message;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public final class DisguiseRestaurer
extends Feature {
    @Override
    public boolean isEnabled() {
        return KamoofPlugin.config().getBoolean("disguise.restaure");
    }

    public static String get(UUID uuid) {
        return KamoofPlugin.data().getString("restaurer." + String.valueOf(uuid));
    }

    public static void set(UUID uuid, String disguise) {
        KamoofPlugin.data().set("restaurer." + String.valueOf(uuid), (Object)disguise);
        KamoofPlugin.saveData();
    }

    public static HashMap<OfflinePlayer, String> getRestaures() {
        HashMap<OfflinePlayer, String> map = new HashMap<OfflinePlayer, String>();
        AtomicBoolean shouldSaveData = new AtomicBoolean(false);
        KamoofPlugin.data().getConfigurationSection("restaurer").getValues(false).forEach((uuid, disguise) -> {
            try {
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(uuid));
                if (player.getName() == null) {
                    throw new RuntimeException();
                }
                map.put(player, (String)disguise);
            }
            catch (Throwable exc) {
                KamoofPlugin.data().set("restaurer." + uuid, null);
                shouldSaveData.set(true);
            }
        });
        if (shouldSaveData.get()) {
            KamoofPlugin.saveData();
        }
        return map;
    }

    @Override
    public void onEnable() {
        super.onEnable();
        Bukkit.getScheduler().runTaskLater((Plugin)KamoofPlugin.getInstance(), () -> {
            Bukkit.getOnlinePlayers().forEach(player -> {
                String name = player.getName();
                String disguise = DisguiseRestaurer.get(player.getUniqueId());
                if (disguise != null) {
                    DisguiseRestaurer.set(player.getUniqueId(), null);
                    if (!name.equalsIgnoreCase(disguise)) {
                        KamoofSMP.getInstance().disguise((OfflinePlayer)player, disguise);
                    }
                }
            });
            KamoofPlugin.saveData();
        }, 1L);
    }

    @Override
    public void onStop() {
        super.onStop();
        if (!this.isEnabled()) {
            KamoofPlugin.data().set("restaurer", null);
            KamoofPlugin.saveData();
            return;
        }
        Bukkit.getOnlinePlayers().forEach(player -> {
            if (NickAPI.isNicked(player) && !NickAPI.getOriginalName(player).equalsIgnoreCase(NickAPI.getName(player))) {
                DisguiseRestaurer.set(player.getUniqueId(), NickAPI.getName(player));
            }
        });
        KamoofPlugin.saveData();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        String name = player.getName();
        UUID uuid = player.getUniqueId();
        String disguise = DisguiseRestaurer.get(uuid);
        if (disguise == null) {
            return;
        }
        DisguiseRestaurer.set(uuid, null);
        DisguiseManager.disguise(player, disguise);
        String message = event.getJoinMessage();
        if (message != null) {
            event.setJoinMessage(message.replace(name, disguise));
        }
        Message.send((CommandSender)player, "messages.restaure", Map.of("player", name, "nick", disguise));
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        try {
            if (!NickAPI.isNicked(player)) {
                return;
            }
            DisguiseRestaurer.set(player.getUniqueId(), NickAPI.getName(player));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

