/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.features.macelimiter;

import im.ghosty.kamoof.KamoofPlugin;
import im.ghosty.kamoof.features.Feature;
import im.ghosty.kamoof.utils.CompatibilityUtils;
import im.ghosty.kamoof.utils.InventoryUtils;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public final class MaceNoEnderChest
extends Feature {
    @Override
    public boolean isEnabled() {
        return CompatibilityUtils.isMinecraft1_21() && KamoofPlugin.config().getBoolean("macelimiter.no-enderchest");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        boolean flags;
        InventoryAction action = event.getAction();
        if (action == InventoryAction.NOTHING || action == InventoryAction.UNKNOWN) {
            return;
        }
        ItemStack item = event.getCursor();
        Inventory inv = event.getClickedInventory();
        if (item == null || inv == null) {
            return;
        }
        if (inv.getType() == InventoryType.ENDER_CHEST) {
            if (action == InventoryAction.HOTBAR_SWAP) {
                item = event.getWhoClicked().getInventory().getItem(event.getHotbarButton());
                if (item != null && item.getType() == Material.MACE) {
                    this.cancel((InventoryInteractEvent)event);
                }
                return;
            }
            if (action == CompatibilityUtils.getPaperPlaceIntoBundleAction() || action == CompatibilityUtils.getPaperPlaceFromBundleAction()) {
                if (InventoryUtils.hasItem(item, 1, Material.MACE)) {
                    this.cancel((InventoryInteractEvent)event);
                }
                return;
            }
            if (action != InventoryAction.PLACE_ALL && action != InventoryAction.PLACE_SOME && action != InventoryAction.PLACE_ONE && action != InventoryAction.SWAP_WITH_CURSOR) {
                return;
            }
        } else {
            if (event.getInventory().getType() != InventoryType.ENDER_CHEST) {
                return;
            }
            if (action != InventoryAction.MOVE_TO_OTHER_INVENTORY) {
                return;
            }
            item = event.getCurrentItem();
        }
        if (flags = InventoryUtils.hasItem(item, 2, Material.MACE)) {
            this.cancel((InventoryInteractEvent)event);
        }
    }

    private void cancel(InventoryInteractEvent event) {
        event.setCancelled(true);
        event.setResult(Event.Result.DENY);
    }
}

