/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.features.other;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import im.ghosty.kamoof.KamoofPlugin;
import im.ghosty.kamoof.features.Feature;
import im.ghosty.kamoof.utils.HTTPUtils;
import im.ghosty.kamoof.utils.Lang;
import im.ghosty.kamoof.utils.Message;
import im.ghosty.kamoof.utils.Utils;
import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public final class UpdateChecker
extends Feature {
    private final String currentVersion = KamoofPlugin.getInstance().getDescription().getVersion().trim().toLowerCase();
    private boolean hasUpdate = false;
    private String newVersion;
    private String changelog;
    private String downloads;
    private String updateLink;
    private BaseComponent[] message;
    private BukkitTask task;

    @Override
    public boolean isEnabled() {
        return KamoofPlugin.config().getBoolean("autoupdate.fetch") && !KamoofPlugin.data().getBoolean("debug", false);
    }

    @Override
    public void onEnable() {
        super.onEnable();
        boolean[] shouldRestart = new boolean[]{true};
        this.task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)KamoofPlugin.getInstance(), () -> {
            boolean download = KamoofPlugin.config().getBoolean("autoupdate.download");
            if (!(!this.checkForUpdate() || download && this.downloadUpdate(this.updateLink, shouldRestart[0]))) {
                this.hasUpdate = true;
                Bukkit.getConsoleSender().spigot().sendMessage(this.message);
            }
            shouldRestart[0] = false;
        }, 1L, 1728000L);
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.task.cancel();
        this.task = null;
    }

    public boolean checkForUpdate() {
        try {
            this.sendMessage("UPDATE_CHECKING", new Object[0]);
            String data = HTTPUtils.get("https://api.modrinth.com/v2/project/camouf2/version", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("User-Agent", "github: @Ghosty920/KamoofSMP-S2/v" + UpdateChecker.this.currentVersion);
                }
            }).response();
            JsonObject object = JsonParser.parseString((String)data).getAsJsonArray().get(0).getAsJsonObject();
            this.newVersion = object.get("version_number").getAsString().trim().toLowerCase();
            if (Arrays.compare(this.currentVersion.getBytes(), this.newVersion.getBytes()) != 0) {
                int downloadsCount = object.get("downloads").getAsInt();
                this.downloads = downloadsCount < 1000 ? String.valueOf(downloadsCount) : (downloadsCount < 1000000 ? String.format("%.2fk", Float.valueOf(downloadsCount / 1000)) : String.format("%.2fM", Float.valueOf(downloadsCount / 1000000)));
                this.changelog = object.get("changelog").getAsString().replace("\n", "\\n");
                Pattern pattern = Pattern.compile(Lang.get("VERSION_CHANGELOG_REGEX"), 128);
                Matcher matcher = pattern.matcher(this.changelog);
                matcher.find();
                this.changelog = matcher.group().replace("\\n", "<br>").replace("\"", "\\\"");
                String hover = String.format(Lang.get("NEW_VERSION_HOVER"), this.newVersion, this.downloads, this.changelog);
                String url = "https://modrinth.com/plugin/camouf2/version/" + this.newVersion;
                String message = String.format(Lang.get("NEW_VERSION"), hover, url, this.currentVersion, this.newVersion);
                this.message = Message.toBaseComponent(message);
                this.updateLink = this.getFileURL(object);
                return true;
            }
            this.sendMessage("UPDATE_ALREADY_LAST", new Object[0]);
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            this.sendMessage("UPDATE_CHECKER_FAIL", new Object[0]);
        }
        return false;
    }

    public boolean downloadUpdate(String url, boolean restart) {
        if (url == null) {
            return false;
        }
        try {
            this.sendMessage("UPDATE_DOWNLOADING", new Object[0]);
            HTTPUtils.RawResponse response = HTTPUtils.getRaw(url, (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("User-Agent", "github: @Ghosty920/KamoofSMP-S2/v" + UpdateChecker.this.currentVersion);
                }
            });
            URL location = KamoofPlugin.class.getProtectionDomain().getCodeSource().getLocation();
            File pluginFile = Utils.getParentPluginFile(location);
            Files.write(Path.of(pluginFile.toURI()), response.response(), new OpenOption[0]);
            this.sendMessage("UPDATE_DOWNLOADED", new Object[0]);
            if (!restart) {
                String hover = String.format(Lang.get("NEW_VERSION_HOVER"), this.newVersion, this.downloads, this.changelog);
                String uUrl = "https://modrinth.com/plugin/camouf2/version/" + this.newVersion;
                String message = String.format(Lang.get("NEW_VERSION_DOWNLOADED"), hover, uUrl, this.currentVersion, this.newVersion);
                this.message = Message.toBaseComponent(message);
                this.hasUpdate = true;
                Bukkit.getConsoleSender().spigot().sendMessage(this.message);
            } else {
                Bukkit.getScheduler().runTask((Plugin)KamoofPlugin.getInstance(), () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"restart"));
            }
            return true;
        }
        catch (Throwable exc) {
            exc.printStackTrace();
            this.sendMessage("UPDATE_DOWNLOAD_FAIL", new Object[0]);
            return false;
        }
    }

    public String getFileURL(JsonObject obj) {
        JsonArray files = obj.get("files").getAsJsonArray();
        for (int i = 0; i < files.size(); ++i) {
            JsonObject file = files.get(i).getAsJsonObject();
            if (!file.get("primary").getAsBoolean()) continue;
            return file.get("url").getAsString();
        }
        return null;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (!this.hasUpdate || this.message == null) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.hasPermission("kamoofsmp.admin")) {
            return;
        }
        player.spigot().sendMessage(this.message);
    }

    private void sendMessage(String key, Object ... args) {
        Lang.send((CommandSender)Bukkit.getConsoleSender(), key, args);
    }
}

