/*
 * Decompiled with CFR 0.152.
 */
package im.ghosty.kamoof.features.ritual;

import im.ghosty.kamoof.KamoofPlugin;
import im.ghosty.kamoof.features.ritual.RitualBook;
import im.ghosty.kamoof.features.ritual.RitualHandler;
import im.ghosty.kamoof.utils.ColorResolver;
import im.ghosty.kamoof.utils.Message;
import im.ghosty.kamoof.utils.SLocation;
import im.ghosty.kamoof.utils.Utils;
import java.net.URL;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.bukkit.scheduler.BukkitTask;
import org.joml.Vector2d;

public final class RitualAnimation {
    private static final HashSet<Runnable> particles = new HashSet();
    private static boolean stopped = false;

    public static void execute(Location location) {
        World world = location.getWorld();
        double startX = (double)location.getBlockX() + 0.5;
        double startY = (double)location.getBlockY() + 0.25;
        double startZ = (double)location.getBlockZ() + 0.5;
        double height = 8.0;
        double endY = startY + 8.0;
        SLocation centeredLoc = new SLocation(location.getWorld(), startX, (double)location.getBlockY() + 4.0, startZ);
        Particle.DustOptions dust = new Particle.DustOptions(ColorResolver.getColor(KamoofPlugin.config().getString("ritual.animation.color")), (float)KamoofPlugin.config().getDouble("ritual.animation.size"));
        stopped = false;
        particles.clear();
        Object ref = new Object(){
            int currentOffset = 0;
        };
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        PlayerProfile ownerProfile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID(), (String)"_");
        PlayerTextures textures = ownerProfile.getTextures();
        textures.setSkin(new URL("http://textures.minecraft.net/texture/f8912bc1ad3ddbe39a19b734a42d8548964bb0a9ce58a52f1a6ae37121524"));
        ownerProfile.setTextures(textures);
        meta.setOwnerProfile(ownerProfile);
        skull.setItemMeta((ItemMeta)meta);
        for (ArmorStand entity : RitualHandler.armorStands) {
            entity.getPersistentDataContainer().set(RitualHandler.key, PersistentDataType.BOOLEAN, (Object)true);
            entity.getEquipment().setHelmet(skull, true);
        }
        world.setWeatherDuration(0);
        world.setThundering(false);
        world.setStorm(false);
        boolean hasDayCycle = (Boolean)world.getGameRuleValue(GameRule.DO_DAYLIGHT_CYCLE);
        world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
        long previousWorldTime = world.getTime();
        long timeIncr = KamoofPlugin.config().getLong("ritual.animation.time-incr");
        long timeStop = KamoofPlugin.config().getLong("ritual.animation.time-stop");
        long timeSpeed = KamoofPlugin.config().getLong("ritual.animation.time-speed");
        Bukkit.getScheduler().runTaskTimer((Plugin)KamoofPlugin.getInstance(), task -> {
            if (stopped) {
                task.cancel();
                return;
            }
            world.playSound((Location)centeredLoc, Sound.ITEM_GOAT_HORN_SOUND_3, SoundCategory.AMBIENT, 0.1f, 0.7f);
            world.setTime((long)Math.round((float)(world.getTime() + timeIncr) / (float)timeIncr) * timeIncr);
            if (world.getTime() == timeStop) {
                task.cancel();
            }
        }, 0L, timeSpeed);
        Consumer<Double> drawLargeCircles = y -> {
            RitualAnimation.drawCircle(world, startX, y, startZ, 4.25, 100, dust);
            RitualAnimation.drawCircle(world, startX, y, startZ, 4.5, 100, dust);
            RitualAnimation.drawCircle(world, startX, y, startZ, 7.25, 150, dust);
        };
        Consumer<BukkitTask> part4 = task -> {
            if (stopped) {
                task.cancel();
                return;
            }
            double radius = KamoofPlugin.config().getDouble("ritual.animation.sphere.radius");
            RitualAnimation.spawnSphere(world, startX, startY + 4.5, startZ, radius);
            Bukkit.getScheduler().runTaskLater((Plugin)KamoofPlugin.getInstance(), () -> {
                stopped = true;
                world.setTime(previousWorldTime);
                world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)hasDayCycle);
                Bukkit.spigot().broadcast(Message.toBaseComponent(KamoofPlugin.config().getString("messages.ritualdone")));
                world.dropItemNaturally((Location)centeredLoc, RitualBook.getBook(RitualHandler.addNewUUID()));
                world.strikeLightning((Location)centeredLoc.plus(0.0, radius, 0.0));
                world.playSound((Location)centeredLoc, Sound.ENTITY_WITHER_SPAWN, SoundCategory.HOSTILE, 0.2f, 1.0f);
                for (ArmorStand entity : RitualHandler.armorStands) {
                    entity.getPersistentDataContainer().set(RitualHandler.key, PersistentDataType.BOOLEAN, (Object)false);
                    entity.getEquipment().setHelmet(null, true);
                }
            }, 200L);
        };
        Consumer<BukkitTask> part3 = task -> {
            if (stopped) {
                task.cancel();
                return;
            }
            particles.add(() -> world.spawnParticle(Particle.FLAME, startX, startY + 4.0, startZ, 2, 5.0, 5.0, 5.0, 2.0, null, true));
            world.playSound((Location)centeredLoc, Sound.BLOCK_ANVIL_PLACE, SoundCategory.AMBIENT, 0.5f, 0.5f);
            drawLargeCircles.accept(startY);
            Bukkit.getScheduler().runTaskLater((Plugin)KamoofPlugin.getInstance(), task2 -> {
                if (stopped) {
                    task2.cancel();
                    return;
                }
                drawLargeCircles.accept(endY);
                for (int i = 0; i < RitualHandler.offsets.size(); ++i) {
                    Vector2d a = RitualHandler.offsets.get(i);
                    Vector2d b = RitualHandler.offsets.get((i + 1) % RitualHandler.offsets.size());
                    double aX = a.x + startX;
                    double aZ = a.y + startZ;
                    double bX = b.x + startX;
                    double bZ = b.y + startZ;
                    RitualAnimation.drawCircle(world, aX, endY, aZ, 1.5, 40, dust);
                    RitualAnimation.drawLine(world, endY, aX, aZ, bX, bZ, dust);
                }
                Object ref2 = new Object(){
                    int i = 0;
                };
                SLocation lightningLoc = centeredLoc.plus(0.0, 12.0, 0.0);
                int quantity = KamoofPlugin.config().getInt("ritual.animation.lightning-quantity");
                long interval = KamoofPlugin.config().getLong("ritual.animation.lightning-interval");
                Bukkit.getScheduler().runTaskTimer((Plugin)KamoofPlugin.getInstance(), arg_0 -> RitualAnimation.lambda$execute$5(ref2, quantity, world, lightningLoc, arg_0), 15L, interval);
                Bukkit.getScheduler().runTaskLater((Plugin)KamoofPlugin.getInstance(), part4, interval * (long)quantity + 10L);
            }, 20L);
        };
        Consumer<BukkitTask> part2 = arg_0 -> RitualAnimation.lambda$execute$10(world, centeredLoc, startX, startZ, startY, endY, dust, ref, part3, arg_0);
        Consumer<BukkitTask> part1 = arg_0 -> RitualAnimation.lambda$execute$11(ref, startX, startZ, world, startY, dust, centeredLoc, part2, arg_0);
        Bukkit.getScheduler().runTaskTimer((Plugin)KamoofPlugin.getInstance(), part1, 15L, 20L);
        Bukkit.getScheduler().runTaskTimer((Plugin)KamoofPlugin.getInstance(), task -> {
            if (stopped) {
                task.cancel();
                return;
            }
            particles.forEach(Runnable::run);
        }, 0L, 2L);
    }

    private static void drawLine(World world, double y, double aX, double aZ, double bX, double bZ, Particle.DustOptions dust) {
        for (int i = 0; i < 20; ++i) {
            float ratio = (float)i / 19.0f;
            double x = Utils.interpolate(aX, bX, ratio);
            double z = Utils.interpolate(aZ, bZ, ratio);
            particles.add(() -> world.spawnParticle(Particle.DUST, x, y, z, 1, 0.0, 0.0, 0.0, 0.0, (Object)dust, true));
        }
    }

    private static void drawCircle(World world, double x, double y, double z, double radius, int particlesCount, Particle.DustOptions dust) {
        for (int i = 0; i < particlesCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particlesCount;
            double posX = x + radius * Math.cos(angle);
            double posZ = z + radius * Math.sin(angle);
            particles.add(() -> world.spawnParticle(Particle.DUST, posX, y, posZ, 1, 0.0, 0.0, 0.0, 0.0, (Object)dust, true));
        }
    }

    private static void spawnSphere(World world, double x, double y, double z, double radius) {
        int particles = KamoofPlugin.config().getInt("ritual.animation.sphere.quantity");
        double lavaChance = KamoofPlugin.config().getDouble("ritual.animation.sphere.lava-chance") / 100.0;
        Particle lavaParticle = KamoofPlugin.config().getBoolean("ritual.animation.sphere.lava-sound") ? Particle.DRIPPING_DRIPSTONE_LAVA : Particle.DRIPPING_LAVA;
        Particle.DustOptions dust = new Particle.DustOptions(ColorResolver.getColor(KamoofPlugin.config().getString("ritual.animation.sphere.color")), (float)KamoofPlugin.config().getDouble("ritual.animation.sphere.size"));
        Bukkit.getScheduler().runTaskTimer((Plugin)KamoofPlugin.getInstance(), task -> {
            if (stopped) {
                task.cancel();
                return;
            }
            for (int i = 0; i < particles; ++i) {
                double rand1 = Math.random();
                double rand2 = Math.random();
                double phi = Math.PI * 2 * rand1;
                double posY = y + radius * Math.cos(phi);
                double phiSin = Math.sin(phi);
                double angle = Math.PI * 2 * rand2;
                double posX = x + radius * Math.cos(angle) * phiSin;
                double posZ = z + radius * Math.sin(angle) * phiSin;
                if (Math.random() > lavaChance) {
                    world.spawnParticle(Particle.DUST, posX, posY, posZ, 1, 0.0, 0.0, 0.0, 0.0, (Object)dust, true);
                    continue;
                }
                world.spawnParticle(lavaParticle, posX, posY, posZ, 1, 0.0, 0.0, 0.0, 0.0, null, true);
            }
        }, 0L, 5L);
    }

    private static /* synthetic */ void lambda$execute$11(1 ref, double startX, double startZ, World world, double startY, Particle.DustOptions dust, SLocation centeredLoc, Consumer part2, BukkitTask task) {
        if (stopped) {
            task.cancel();
            return;
        }
        Vector2d a = RitualHandler.offsets.get(ref.currentOffset);
        Vector2d b = RitualHandler.offsets.get((ref.currentOffset + 1) % RitualHandler.offsets.size());
        ++ref.currentOffset;
        double aX = a.x + startX;
        double aZ = a.y + startZ;
        double bX = b.x + startX;
        double bZ = b.y + startZ;
        RitualAnimation.drawLine(world, startY, aX, aZ, bX, bZ, dust);
        if (ref.currentOffset >= RitualHandler.offsets.size()) {
            task.cancel();
            ref.currentOffset = 0;
            world.playSound((Location)centeredLoc, Sound.BLOCK_ANVIL_USE, SoundCategory.AMBIENT, 1.0f, 0.3f);
            Bukkit.getScheduler().runTaskLater((Plugin)KamoofPlugin.getInstance(), part2, 40L);
        }
    }

    private static /* synthetic */ void lambda$execute$10(World world, SLocation centeredLoc, double startX, double startZ, double startY, double endY, Particle.DustOptions dust, 1 ref, Consumer part3, BukkitTask task) {
        if (stopped) {
            task.cancel();
            return;
        }
        world.playSound((Location)centeredLoc, Sound.BLOCK_BEACON_ACTIVATE, SoundCategory.AMBIENT, 0.15f, 1.0f);
        for (Vector2d offset : RitualHandler.offsets) {
            double x = startX + offset.x;
            double z = startZ + offset.y;
            for (int i = 0; i <= 30; ++i) {
                float ratio = (float)i / 30.0f;
                double y = Utils.interpolate(startY, endY, ratio);
                particles.add(() -> world.spawnParticle(Particle.DUST, x, y, z, 1, 0.0, 0.0, 0.0, 0.0, (Object)dust));
            }
        }
        Bukkit.getScheduler().runTaskTimer((Plugin)KamoofPlugin.getInstance(), task2 -> {
            if (stopped) {
                task2.cancel();
                return;
            }
            Vector2d offset = RitualHandler.offsets.get(ref.currentOffset);
            ++ref.currentOffset;
            double x = startX + offset.x;
            double z = startZ + offset.y;
            RitualAnimation.drawCircle(world, x, startY, z, 1.5, 40, dust);
            world.playSound(new Location(world, x, startY, z), Sound.BLOCK_END_PORTAL_FRAME_FILL, 0.2f, 0.95f);
            if (ref.currentOffset >= RitualHandler.offsets.size()) {
                task2.cancel();
                ref.currentOffset = 0;
                Bukkit.getScheduler().runTaskLater((Plugin)KamoofPlugin.getInstance(), part3, 10L);
            }
        }, 10L, 10L);
    }

    private static /* synthetic */ void lambda$execute$5(2 ref2, int quantity, World world, SLocation lightningLoc, BukkitTask task3) {
        if (stopped) {
            task3.cancel();
            return;
        }
        if (ref2.i >= quantity) {
            task3.cancel();
            return;
        }
        ++ref2.i;
        world.strikeLightning((Location)lightningLoc);
    }
}

