/*
 * Decompiled with CFR 0.152.
 */
package fr.solmey.kamoof;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import fr.solmey.kamoof.Kamoof;
import fr.solmey.kamoof.config.JsonConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_11755;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2247;
import net.minecraft.class_2257;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2631;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7924;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class Ritual {
    public static Map<Long, List<Runnable>> scheduledActions = new HashMap<Long, List<Runnable>>();
    public static boolean performingRitual = false;
    private static boolean phase2finished = false;
    private static boolean phase2bisfinished = false;
    private static int ref = 0;
    private static final int HEIGHT = 8;
    private static final Long END_TIME_OF_DAY = 14000L;
    private static final Long TIME_INCREMENT = 250L;
    private static final int LIGHTNING_INTERVAL = 2;
    private static final int LIGHTNING_QUANTITY = 11;
    private static final class_2390 dustEffect = class_2390.field_11188;
    private static final int particles = 750;
    private static final double lavaChance = 0.05;
    private static final int radius = 2;
    private static class_3218 serverWorld;
    private static class_243 centerPos;
    private static Long initialTime;
    private static Long initialTimeOfDay;
    private static MinecraftServer minecraftServer;

    public static boolean isRitualPlaced() {
        return JsonConfig.config.ritual != null && JsonConfig.config.ritual.x != null && JsonConfig.config.ritual.y != null && JsonConfig.config.ritual.z != null && JsonConfig.config.ritual.dimension != null;
    }

    public static void onPlaceHead(class_2338 pos, class_3218 world) {
        if (Ritual.isHeadLocation(pos, world)) {
            world.method_43128(null, pos.method_46558().method_10216(), pos.method_46558().method_10214(), pos.method_46558().method_10215(), class_3417.field_19197, class_3419.field_15256, 0.2f, 1.0f);
            Ritual.checkRitualStart(world.method_8503());
        }
    }

    private static boolean isHeadLocation(class_2338 pos, class_3218 world) {
        return pos != null && world != null && Ritual.getRitualHeadPositions().contains(pos) && Ritual.getRitualHeadDimension(world.method_8503()) == world;
    }

    private static void checkRitualStart(MinecraftServer server) {
        if (Ritual.isRitualPlaced() && !performingRitual) {
            ArrayList<class_2338> listPos = new ArrayList<class_2338>(Ritual.getRitualHeadPositions());
            class_11755 resolver = server.method_73550().comp_4624();
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            serverWorld = Ritual.getRitualHeadDimension(server);
            for (class_2338 pos : listPos) {
                class_2680 state = serverWorld.method_8320(pos);
                if (state.method_26204() != class_2246.field_10432) {
                    return;
                }
                class_2586 blockEntity = serverWorld.method_8321(pos);
                if (blockEntity == null) {
                    return;
                }
                if (blockEntity instanceof class_2631) {
                    class_2631 skullBlockEntity = (class_2631)blockEntity;
                    class_9296 profileComponent = skullBlockEntity.method_11334();
                    CompletableFuture future = profileComponent.method_73306(resolver);
                    futures.add(future);
                    continue;
                }
                return;
            }
            ((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenRun(() -> {
                HashSet uuids = new HashSet();
                boolean allUnique = futures.stream().map(CompletableFuture::join).filter(Objects::nonNull).map(GameProfile::id).allMatch(uuids::add);
                if (allUnique) {
                    Ritual.startRitual(server);
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
        }
    }

    private static List<class_2338> getRitualHeadPositions() {
        if (Ritual.isRitualPlaced()) {
            return List.of(new class_2338(0 + JsonConfig.config.ritual.x, 0 + JsonConfig.config.ritual.y, 0 + JsonConfig.config.ritual.z), new class_2338(6 + JsonConfig.config.ritual.x, 0 + JsonConfig.config.ritual.y, 0 + JsonConfig.config.ritual.z), new class_2338(4 + JsonConfig.config.ritual.x, 0 + JsonConfig.config.ritual.y, 4 + JsonConfig.config.ritual.z), new class_2338(0 + JsonConfig.config.ritual.x, 0 + JsonConfig.config.ritual.y, 6 + JsonConfig.config.ritual.z), new class_2338(-4 + JsonConfig.config.ritual.x, 0 + JsonConfig.config.ritual.y, 4 + JsonConfig.config.ritual.z), new class_2338(-6 + JsonConfig.config.ritual.x, 0 + JsonConfig.config.ritual.y, 0 + JsonConfig.config.ritual.z), new class_2338(-4 + JsonConfig.config.ritual.x, 0 + JsonConfig.config.ritual.y, -4 + JsonConfig.config.ritual.z), new class_2338(0 + JsonConfig.config.ritual.x, 0 + JsonConfig.config.ritual.y, -6 + JsonConfig.config.ritual.z), new class_2338(4 + JsonConfig.config.ritual.x, 0 + JsonConfig.config.ritual.y, -4 + JsonConfig.config.ritual.z));
        }
        return null;
    }

    private static class_3218 getRitualHeadDimension(MinecraftServer server) {
        if (Ritual.isRitualPlaced()) {
            String dimensionId = JsonConfig.config.ritual.dimension;
            class_2960 dimensionIdentifier = class_2960.method_60654((String)dimensionId);
            class_5321 dimensionKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)dimensionIdentifier);
            return server.method_3847(dimensionKey);
        }
        return null;
    }

    public static void startRitual(MinecraftServer server) {
        serverWorld = Ritual.getRitualHeadDimension(server);
        centerPos = new class_2338(JsonConfig.config.ritual.x.intValue(), JsonConfig.config.ritual.y + 4, JsonConfig.config.ritual.z.intValue()).method_46558();
        initialTime = serverWorld.method_8510();
        initialTimeOfDay = serverWorld.method_8532() % 24000L;
        minecraftServer = server;
        performingRitual = true;
        scheduledActions.clear();
        Ritual.scheduleAction(serverWorld.method_8510() + 1L, () -> Ritual.phase1bis());
        Ritual.scheduleAction(serverWorld.method_8510() + 1L, () -> Ritual.phase1());
    }

    private static void phase1() {
        if (serverWorld == minecraftServer.method_30002()) {
            minecraftServer.method_30002().method_27910(4000, 0, false, false);
        }
        serverWorld.method_60511(null, centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215(), (class_6880)class_3417.field_39028.get(3), class_3419.field_15256, 0.1f, 0.7f);
        phase2finished = false;
        phase2bisfinished = false;
        ref = 0;
        Ritual.phase2();
        Ritual.phase2bis();
    }

    private static void phase1bis() {
        class_2247 blockArg;
        ArrayList<class_2338> listPos = new ArrayList<class_2338>(Ritual.getRitualHeadPositions());
        String input = "minecraft:player_head{profile:{properties:{textures:[\"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHBzOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2Y4OTEyYmMxYWQzZGRiZTM5YTE5YjczNGE0MmQ4NTQ4OTY0YmIwYTljZTU4YTUyZjFhNmFlMzcxMjE1MjQifX19\"]}}}";
        StringReader reader = new StringReader(input);
        class_5455 lookup = serverWorld.method_30349();
        class_7157 access = class_7157.method_46722((class_7225.class_7874)lookup, (class_7699)serverWorld.method_45162());
        class_2257 argumentType = class_2257.method_9653((class_7157)access);
        try {
            blockArg = argumentType.method_9654(reader);
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return;
        }
        int flag = 818;
        for (ref = 0; ref < listPos.size(); ++ref) {
            blockArg.method_9495(serverWorld, (class_2338)listPos.get(ref), flag);
        }
    }

    private static void phase2() {
        if (serverWorld.method_8532() % 24000L + TIME_INCREMENT > END_TIME_OF_DAY && serverWorld.method_8532() % 24000L + TIME_INCREMENT <= END_TIME_OF_DAY + TIME_INCREMENT) {
            serverWorld.method_29199(END_TIME_OF_DAY.longValue());
            phase2finished = true;
        } else {
            for (class_3218 serverWorld_ : minecraftServer.method_3738()) {
                serverWorld_.method_29199(serverWorld.method_8532() % 24000L + TIME_INCREMENT);
            }
            Ritual.scheduleAction(serverWorld.method_8510() + 2L, () -> Ritual.phase2());
        }
        minecraftServer.method_49749();
        if (phase2bisfinished && phase2finished) {
            serverWorld.method_43128(null, centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215(), class_3417.field_14559, class_3419.field_15256, 1.0f, 0.3f);
            Ritual.scheduleAction(serverWorld.method_8510() + 40L, () -> Ritual.phase3());
            phase2finished = false;
            phase2bisfinished = false;
        }
    }

    private static void phase2bis() {
        ArrayList<class_2338> listPos = new ArrayList<class_2338>(Ritual.getRitualHeadPositions());
        listPos.remove(0);
        listPos.add((class_2338)listPos.get(0));
        if (ref >= listPos.size() - 1) {
            phase2bisfinished = true;
        } else {
            Ritual.drawLine(((class_2338)listPos.get(ref)).method_46558(), ((class_2338)listPos.get(++ref)).method_46558(), 20);
            if (ref >= listPos.size() - 1) {
                phase2bisfinished = true;
            } else {
                Ritual.scheduleAction(serverWorld.method_8510() + 20L, () -> Ritual.phase2bis());
            }
        }
        if (phase2bisfinished && phase2finished) {
            serverWorld.method_43128(null, centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215(), class_3417.field_14559, class_3419.field_15256, 1.0f, 0.3f);
            Ritual.scheduleAction(serverWorld.method_8510() + 40L, () -> Ritual.phase3());
            phase2finished = false;
            phase2bisfinished = false;
        }
    }

    private static void phase3() {
        ArrayList<class_2338> listPos = new ArrayList<class_2338>(Ritual.getRitualHeadPositions());
        listPos.remove(0);
        listPos.add((class_2338)listPos.get(0));
        ref = 0;
        while (ref < listPos.size() - 1) {
            Ritual.drawLine(((class_2338)listPos.get(ref)).method_46558(), ((class_2338)listPos.get(ref++)).method_46558().method_1031(0.0, 8.0, 0.0), 30);
        }
        ref = 0;
        Ritual.phase4();
    }

    private static void phase4() {
        ArrayList<class_2338> listPos = new ArrayList<class_2338>(Ritual.getRitualHeadPositions());
        listPos.remove(0);
        listPos.add((class_2338)listPos.get(0));
        boolean phase4finished = false;
        if (ref >= listPos.size() - 1) {
            phase4finished = true;
        } else {
            Ritual.drawCircle(((class_2338)listPos.get(ref++)).method_46558(), 1.5, 40);
            serverWorld.method_43128(null, centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215(), class_3417.field_19197, class_3419.field_15256, 0.2f, 0.95f);
            if (ref >= listPos.size() - 1) {
                phase4finished = true;
            } else {
                Ritual.scheduleAction(serverWorld.method_8510() + 10L, () -> Ritual.phase4());
            }
        }
        if (phase4finished) {
            serverWorld.method_43128(null, centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215(), class_3417.field_14785, class_3419.field_15256, 0.5f, 0.5f);
            Ritual.drawFlameParticles();
            ref = 0;
            while (ref < listPos.size() - 1) {
                Ritual.drawLine(((class_2338)listPos.get(ref)).method_46558().method_1031(0.0, 8.0, 0.0), ((class_2338)listPos.get(++ref)).method_46558().method_1031(0.0, 8.0, 0.0), 20);
            }
            ref = 0;
            while (ref < listPos.size() - 1) {
                Ritual.drawCircle(((class_2338)listPos.get(ref++)).method_46558().method_1031(0.0, 8.0, 0.0), 1.5, 40);
            }
            Ritual.drawCircle(centerPos.method_1031(0.0, 4.0, 0.0), 4.25, 100);
            Ritual.drawCircle(centerPos.method_1031(0.0, 4.0, 0.0), 4.5, 100);
            Ritual.drawCircle(centerPos.method_1031(0.0, 4.0, 0.0), 7.25, 150);
            Ritual.drawCircle(centerPos.method_1031(0.0, -4.0, 0.0), 4.25, 100);
            Ritual.drawCircle(centerPos.method_1031(0.0, -4.0, 0.0), 4.5, 100);
            Ritual.drawCircle(centerPos.method_1031(0.0, -4.0, 0.0), 7.25, 150);
            ref = 0;
            Ritual.scheduleAction(serverWorld.method_8510() + 40L, () -> Ritual.phase5());
            Ritual.scheduleAction(serverWorld.method_8510() + 35L + 22L, () -> Ritual.phase6());
        }
    }

    private static void phase5() {
        if (ref < 11) {
            ++ref;
            class_1538 lightning = new class_1538(class_1299.field_6112, (class_1937)serverWorld);
            lightning.method_23327(centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215());
            serverWorld.method_8649((class_1297)lightning);
            Ritual.scheduleAction(serverWorld.method_8510() + 2L, () -> Ritual.phase5());
        }
    }

    private static void phase6() {
        Ritual.spawnSphere();
        Ritual.scheduleAction(serverWorld.method_8510() + 200L, () -> Ritual.phaseFinal());
    }

    private static void phaseFinal() {
        for (class_3218 serverWorld_ : minecraftServer.method_3738()) {
            serverWorld_.method_29199(initialTimeOfDay.longValue());
        }
        minecraftServer.method_49749();
        class_1538 lightning = new class_1538(class_1299.field_6112, (class_1937)serverWorld);
        lightning.method_23327(centerPos.method_10216(), centerPos.method_10214() + 4.0, centerPos.method_10215());
        serverWorld.method_8649((class_1297)lightning);
        class_1799 book = new class_1799((class_1935)class_1802.field_8360);
        book.method_57379(class_9334.field_49606, (Object)Kamoof.getWrittenBookContentComponent(false));
        class_1542 itemEntity = new class_1542((class_1937)serverWorld, centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215(), book);
        serverWorld.method_8649((class_1297)itemEntity);
        serverWorld.method_43128(null, centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215(), class_3417.field_14792, class_3419.field_15256, 0.2f, 1.0f);
        ArrayList<class_2338> listPos = new ArrayList<class_2338>(Ritual.getRitualHeadPositions());
        class_2680 newState = class_2246.field_10124.method_9564();
        for (ref = 0; ref < listPos.size(); ++ref) {
            serverWorld.method_8501((class_2338)listPos.get(ref), newState);
        }
        minecraftServer.method_3760().method_43514(Kamoof.getSystemMessage((byte)17), false);
        performingRitual = false;
        scheduledActions.clear();
    }

    private static void scheduleAction(long tick, Runnable action) {
        scheduledActions.computeIfAbsent(tick, k -> new ArrayList()).add(action);
    }

    private static void drawLine(class_243 vec1, class_243 vec2, int iterations) {
        for (int i = 0; i < iterations; ++i) {
            float ratio = (float)i / (float)(iterations - 1);
            double x = Ritual.interpolate(vec1.method_10216(), vec2.method_10216(), ratio);
            double y = Ritual.interpolate(vec1.method_10214(), vec2.method_10214(), ratio);
            double z = Ritual.interpolate(vec1.method_10215(), vec2.method_10215(), ratio);
            for (class_3222 serverPlayerEntity : minecraftServer.method_3760().method_14571()) {
                serverWorld.method_14166(serverPlayerEntity, (class_2394)dustEffect, true, false, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        Ritual.scheduleAction(serverWorld.method_8510() + 2L, () -> Ritual.drawLine(vec1, vec2, iterations));
    }

    private static void drawCircle(class_243 vec, double radius, int iterations) {
        for (int i = 0; i < iterations; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)iterations;
            double x = vec.method_10216() + radius * Math.cos(angle);
            double y = vec.method_10214();
            double z = vec.method_10215() + radius * Math.sin(angle);
            for (class_3222 serverPlayerEntity : minecraftServer.method_3760().method_14571()) {
                serverWorld.method_14166(serverPlayerEntity, (class_2394)dustEffect, true, false, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        Ritual.scheduleAction(serverWorld.method_8510() + 2L, () -> Ritual.drawCircle(vec, radius, iterations));
    }

    private static void drawFlameParticles() {
        for (class_3222 serverPlayerEntity : minecraftServer.method_3760().method_14571()) {
            serverWorld.method_14166(serverPlayerEntity, (class_2394)class_2398.field_11240, true, false, centerPos.method_10216(), centerPos.method_10214(), centerPos.method_10215(), 2, 5.0, 5.0, 5.0, 2.0);
        }
        Ritual.scheduleAction(serverWorld.method_8510() + 2L, () -> Ritual.drawFlameParticles());
    }

    private static void spawnSphere() {
        double posX = centerPos.method_10216();
        double posY = centerPos.method_10214() - 4.0 + 4.5;
        double posZ = centerPos.method_10215();
        class_2390 dust = new class_2390(65535, 1.0f);
        ArrayList<class_243> particlePositions = new ArrayList<class_243>(750);
        for (int i = 0; i < 750; ++i) {
            double theta = Math.PI * 2 * Math.random();
            double z = 2.0 * Math.random() - 1.0;
            double r = Math.sqrt(1.0 - z * z);
            double particleX = posX + 2.0 * r * Math.cos(theta);
            double particleY = posY + 2.0 * r * Math.sin(theta);
            double particleZ = posZ + 2.0 * z;
            particlePositions.add(new class_243(particleX, particleY, particleZ));
        }
        for (class_3222 serverPlayerEntity : serverWorld.method_8503().method_3760().method_14571()) {
            for (class_243 pos : particlePositions) {
                if (Math.random() > 0.05) {
                    serverWorld.method_14166(serverPlayerEntity, (class_2394)dust, true, false, pos.field_1352, pos.field_1351, pos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                    continue;
                }
                serverWorld.method_14166(serverPlayerEntity, (class_2394)class_2398.field_11223, true, false, pos.field_1352, pos.field_1351, pos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        Ritual.scheduleAction(serverWorld.method_8510() + 5L, () -> Ritual.spawnSphere());
    }

    public static double interpolate(double start, double end, float fraction) {
        return start + (end - start) * (double)fraction;
    }
}

