/*
 * Decompiled with CFR 0.152.
 */
package fr.solmey.kamoof.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.solmey.kamoof.config.Commands;
import fr.solmey.kamoof.config.Config;
import fr.solmey.kamoof.config.MaceLimiter;
import fr.solmey.kamoof.config.RitualStructure;
import fr.solmey.kamoof.config.commands.Disguise;
import fr.solmey.kamoof.config.commands.Givehead;
import fr.solmey.kamoof.config.commands.Pact;
import fr.solmey.kamoof.config.commands.Reload;
import fr.solmey.kamoof.config.commands.Ritual;
import fr.solmey.kamoof.config.commands.Setup;
import fr.solmey.kamoof.config.commands.Undisguise;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class JsonConfig {
    private static final String filePath = "config/kamoof.json";
    public static final File configFile = new File("config/kamoof.json");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static Config config = new Config();

    public static void loadConfig() {
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                config = (Config)gson.fromJson((Reader)reader, Config.class);
            }
            catch (IOException e) {
                return;
            }
        }
        if (config == null) {
            config = new Config();
        }
        if (JsonConfig.config.debug == null) {
            JsonConfig.config.debug = false;
        }
        if (JsonConfig.config.experimental == null) {
            JsonConfig.config.experimental = false;
        }
        if (JsonConfig.config.commands == null) {
            JsonConfig.config.commands = new Commands();
        }
        if (JsonConfig.config.commands.disguise == null) {
            JsonConfig.config.commands.disguise = new Disguise();
        }
        if (JsonConfig.config.commands.disguise.permission == null) {
            JsonConfig.config.commands.disguise.permission = 2;
        }
        if (JsonConfig.config.commands.undisguise == null) {
            JsonConfig.config.commands.undisguise = new Undisguise();
        }
        if (JsonConfig.config.commands.undisguise.permission == null) {
            JsonConfig.config.commands.undisguise.permission = 0;
        }
        if (JsonConfig.config.commands.givehead == null) {
            JsonConfig.config.commands.givehead = new Givehead();
        }
        if (JsonConfig.config.commands.givehead.permission == null) {
            JsonConfig.config.commands.givehead.permission = 2;
        }
        if (JsonConfig.config.commands.pact == null) {
            JsonConfig.config.commands.pact = new Pact();
        }
        if (JsonConfig.config.commands.pact.permission == null) {
            JsonConfig.config.commands.pact.permission = 2;
        }
        if (JsonConfig.config.commands.setup == null) {
            JsonConfig.config.commands.setup = new Setup();
        }
        if (JsonConfig.config.commands.setup.permission == null) {
            JsonConfig.config.commands.setup.permission = 2;
        }
        if (JsonConfig.config.commands.reload == null) {
            JsonConfig.config.commands.reload = new Reload();
        }
        if (JsonConfig.config.commands.reload.permission == null) {
            JsonConfig.config.commands.reload.permission = 2;
        }
        if (JsonConfig.config.commands.ritual == null) {
            JsonConfig.config.commands.ritual = new Ritual();
        }
        if (JsonConfig.config.commands.ritual.permission == null) {
            JsonConfig.config.commands.ritual.permission = 2;
        }
        if (JsonConfig.config.ritual == null) {
            JsonConfig.config.ritual = new RitualStructure();
        }
        if (JsonConfig.config.maceLimiter == null) {
            JsonConfig.config.maceLimiter = new MaceLimiter();
        }
        if (JsonConfig.config.maceLimiter.limit == null) {
            JsonConfig.config.maceLimiter.limit = 1;
        }
        if (JsonConfig.config.maceLimiter.enderchest == null) {
            JsonConfig.config.maceLimiter.enderchest = false;
        }
        JsonConfig.saveConfig();
    }

    public static void saveConfig() {
        configFile.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(configFile);){
            gson.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean allowMaceInEnderChest() {
        return JsonConfig.config.maceLimiter.enderchest;
    }
}

