/*
 * Decompiled with CFR 0.152.
 */
package fr.solmey.kamoof.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import fr.solmey.kamoof.Kamoof;
import fr.solmey.kamoof.config.JsonConfig;
import fr.solmey.kamoof.data.Data;
import fr.solmey.kamoof.data.Disguise;
import fr.solmey.kamoof.data.Mace;
import fr.solmey.kamoof.data.Pact;
import fr.solmey.kamoof.mixin.PlayerEntityAccessor;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.class_1657;

public class JsonData {
    private static final String filePath = "data/kamoof.json";
    public static final File dataFile = new File("data/kamoof.json");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static Data data = new Data();

    public static void loadData() {
        if (dataFile.exists()) {
            try (FileReader reader = new FileReader(dataFile);){
                data = (Data)gson.fromJson((Reader)reader, Data.class);
            }
            catch (IOException e) {
                return;
            }
        }
        if (data == null) {
            data = new Data();
        }
        if (JsonData.data.pacts == null) {
            JsonData.data.pacts = new ArrayList<Pact>();
        }
        if (JsonData.data.disguised == null) {
            JsonData.data.disguised = new ArrayList<Disguise>();
        }
        if (JsonData.data.mace == null) {
            JsonData.data.mace = new Mace();
        }
        if (JsonData.data.mace.crafted == null) {
            JsonData.data.mace.crafted = 0;
        }
        JsonData.saveData();
    }

    public static void saveData() {
        dataFile.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(dataFile);){
            gson.toJson((Object)data, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addMaceCrafted(int number) {
        Mace mace = JsonData.data.mace;
        mace.crafted = mace.crafted + number;
        JsonData.saveData();
    }

    public static boolean allMaceCrafted() {
        return JsonData.data.mace.crafted >= JsonConfig.config.maceLimiter.limit;
    }

    public static void onPlayerConnect(class_1657 playerEntity) {
        for (Disguise disguise : JsonData.data.disguised) {
            if (!disguise.original.equals(playerEntity.method_5667())) continue;
            if (disguise.cacheName != null) {
                GameProfile newGameProfile = new GameProfile(playerEntity.method_5667(), disguise.cacheName);
                Kamoof.disguised.put(playerEntity.method_5667(), new fr.solmey.kamoof.Disguise(playerEntity.method_7334(), newGameProfile));
                ((PlayerEntityAccessor)playerEntity).setProfile(newGameProfile);
            }
            Kamoof.newAsyncDisguise(playerEntity, null, disguise.fake, true, false, false, null, null);
        }
    }

    public static void addDisguise(UUID original, UUID fake, String cacheName) {
        JsonData.removeDisguise(original);
        Disguise disguise = new Disguise(original, fake, cacheName);
        JsonData.data.disguised.add(disguise);
        JsonData.saveData();
    }

    public static void removeDisguise(UUID original) {
        JsonData.data.disguised.removeIf(disguise -> disguise.original.equals(original));
        JsonData.saveData();
    }

    public static void addPact(UUID uuid, Integer type) {
        JsonData.removePact(uuid);
        Pact pact = new Pact(uuid, type);
        JsonData.data.pacts.add(pact);
        JsonData.saveData();
    }

    public static boolean hasPact(UUID uuid, int type) {
        for (Pact pact : JsonData.data.pacts) {
            if (!pact.uuid.equals(uuid) || pact.type != type) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPact(UUID uuid) {
        for (Pact pact : JsonData.data.pacts) {
            if (!pact.uuid.equals(uuid)) continue;
            return true;
        }
        return false;
    }

    public static void removePact(UUID original) {
        JsonData.data.pacts.removeIf(pact -> pact.uuid.equals(original));
        JsonData.saveData();
    }
}

