/*
 * Decompiled with CFR 0.152.
 */
package dev.roanoke.rib;

import dev.roanoke.rib.callbacks.RegisterQuestCallback;
import dev.roanoke.rib.callbacks.RegisterRequirementCallback;
import dev.roanoke.rib.callbacks.RibInitCallback;
import dev.roanoke.rib.callbacks.RibPreInitCallback;
import dev.roanoke.rib.gui.configurable.CGuiManager;
import dev.roanoke.rib.quests.QuestRegistry;
import dev.roanoke.rib.requirements.RequirementRegistry;
import dev.roanoke.rib.utils.FileUtils;
import dev.roanoke.rib.utils.PermissionManager;
import dev.roanoke.rib.utils.cooldown.Cooldowns;
import dev.roanoke.rib.utils.cooldown.RibCooldowns;
import dev.roanoke.rib.utils.messenger.Messenger;
import dev.roanoke.rib.utils.messenger.RibMessenger;
import dev.roanoke.rib.utils.players.PlayerUtil;
import dev.roanoke.rib.utils.players.RibPlayerUtil;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.kyori.adventure.platform.fabric.FabricServerAudiences;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00062\u00020\u0001:\u0002\u0006\u0007B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003\u00a8\u0006\u0007"}, d2={"Ldev/roanoke/rib/Rib;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "", "onInitialize", "Companion", "Rib"})
public final class Rib
implements ModInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Path MAIN_DIR = FabricLoader.getInstance().getConfigDir().resolve("Rib");
    private static final Path GUI_DIR = MAIN_DIR.resolve("GUI");
    private static final Path MENU_DIR = GUI_DIR.resolve("Menus");
    @JvmField
    @NotNull
    public static Logger LOGGER;
    public static FabricServerAudiences ADVENTURE;
    public static LuckPerms LUCKPERMS;
    @JvmField
    @NotNull
    public static PermissionManager PERMISSIONS;
    public static MinecraftServer SERVER;
    @JvmField
    @NotNull
    public static PlayerUtil PLAYER_UTIL;
    @JvmField
    @NotNull
    public static Messenger MESSENGER;
    @JvmField
    @NotNull
    public static Cooldowns COOLDOWNS;
    @NotNull
    private static final CGuiManager GUIs;

    public void onInitialize() {
        Path path = MENU_DIR.resolve("generic_manage.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        FileUtils.copyResourceToFile$default(FileUtils.INSTANCE, "/rib/gui/menu/generic_manage.json", path, false, 4, null);
        Path path2 = MENU_DIR.resolve("generic_paginated.json");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        FileUtils.copyResourceToFile$default(FileUtils.INSTANCE, "/rib/gui/menu/generic_paginated.json", path2, false, 4, null);
        Path path3 = GUI_DIR.resolve("item_definitions.json");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        FileUtils.copyResourceToFile$default(FileUtils.INSTANCE, "/rib/gui/item_definitions.json", path3, false, 4, null);
        ServerLifecycleEvents.SERVER_STARTED.register(Rib::onInitialize$lambda$0);
    }

    private static final void onInitialize$lambda$0(MinecraftServer it) {
        Companion.setSERVER(it);
        LOGGER.info("[RIB] Initialising Server, Adventure, LuckPerms");
        Companion.setADVENTURE(FabricServerAudiences.of((MinecraftServer)it));
        try {
            Companion.setLUCKPERMS(LuckPermsProvider.get());
        }
        catch (IllegalStateException e) {
            LOGGER.error("LuckPerms is not installed or is broken!", (Throwable)e);
        }
        QuestRegistry.INSTANCE.registerDefaultQuests();
        ((RegisterQuestCallback)RegisterQuestCallback.EVENT.invoker()).interact();
        RequirementRegistry.INSTANCE.registerDefaults();
        ((RegisterRequirementCallback)RegisterRequirementCallback.EVENT.invoker()).interact();
        ((RibPreInitCallback)RibPreInitCallback.EVENT.invoker()).interact();
        GUIs.setup();
        ((RibInitCallback)RibInitCallback.EVENT.invoker()).interact();
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)"Rib");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        PERMISSIONS = new PermissionManager();
        PLAYER_UTIL = new RibPlayerUtil();
        MESSENGER = new RibMessenger();
        Path path = MAIN_DIR.resolve("cooldowns.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        COOLDOWNS = RibCooldowns.Companion.fromFile(path);
        Path path2 = MENU_DIR;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"MENU_DIR");
        Path path3 = GUI_DIR.resolve("item_definitions.json");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        GUIs = new CGuiManager(path2, path3);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001f\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR\u001f\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u0007\u001a\u0004\b\u000b\u0010\tR\u001f\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\u0007\u001a\u0004\b\r\u0010\tR\u0016\u0010\u000f\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\"\u0010\u0012\u001a\u00020\u00118\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0019\u001a\u00020\u00188\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0016\u0010 \u001a\u00020\u001f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\"\u0010#\u001a\u00020\"8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0016\u0010*\u001a\u00020)8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0016\u0010-\u001a\u00020,8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0016\u00100\u001a\u00020/8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0017\u00103\u001a\u0002028\u0006\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u00106\u00a8\u00067"}, d2={"Ldev/roanoke/rib/Rib$Companion;", "", "<init>", "()V", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "MAIN_DIR", "Ljava/nio/file/Path;", "getMAIN_DIR", "()Ljava/nio/file/Path;", "GUI_DIR", "getGUI_DIR", "MENU_DIR", "getMENU_DIR", "Lorg/slf4j/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "Lnet/kyori/adventure/platform/fabric/FabricServerAudiences;", "ADVENTURE", "Lnet/kyori/adventure/platform/fabric/FabricServerAudiences;", "getADVENTURE", "()Lnet/kyori/adventure/platform/fabric/FabricServerAudiences;", "setADVENTURE", "(Lnet/kyori/adventure/platform/fabric/FabricServerAudiences;)V", "Lnet/luckperms/api/LuckPerms;", "LUCKPERMS", "Lnet/luckperms/api/LuckPerms;", "getLUCKPERMS", "()Lnet/luckperms/api/LuckPerms;", "setLUCKPERMS", "(Lnet/luckperms/api/LuckPerms;)V", "Ldev/roanoke/rib/utils/PermissionManager;", "PERMISSIONS", "Ldev/roanoke/rib/utils/PermissionManager;", "Lnet/minecraft/server/MinecraftServer;", "SERVER", "Lnet/minecraft/server/MinecraftServer;", "getSERVER", "()Lnet/minecraft/server/MinecraftServer;", "setSERVER", "(Lnet/minecraft/server/MinecraftServer;)V", "Ldev/roanoke/rib/utils/players/PlayerUtil;", "PLAYER_UTIL", "Ldev/roanoke/rib/utils/players/PlayerUtil;", "Ldev/roanoke/rib/utils/messenger/Messenger;", "MESSENGER", "Ldev/roanoke/rib/utils/messenger/Messenger;", "Ldev/roanoke/rib/utils/cooldown/Cooldowns;", "COOLDOWNS", "Ldev/roanoke/rib/utils/cooldown/Cooldowns;", "Ldev/roanoke/rib/gui/configurable/CGuiManager;", "GUIs", "Ldev/roanoke/rib/gui/configurable/CGuiManager;", "getGUIs", "()Ldev/roanoke/rib/gui/configurable/CGuiManager;", "Rib"})
    public static final class Companion {
        private Companion() {
        }

        public final Path getMAIN_DIR() {
            return MAIN_DIR;
        }

        public final Path getGUI_DIR() {
            return GUI_DIR;
        }

        public final Path getMENU_DIR() {
            return MENU_DIR;
        }

        @NotNull
        public final FabricServerAudiences getADVENTURE() {
            FabricServerAudiences fabricServerAudiences = ADVENTURE;
            if (fabricServerAudiences != null) {
                return fabricServerAudiences;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"ADVENTURE");
            return null;
        }

        public final void setADVENTURE(@NotNull FabricServerAudiences fabricServerAudiences) {
            Intrinsics.checkNotNullParameter((Object)fabricServerAudiences, (String)"<set-?>");
            ADVENTURE = fabricServerAudiences;
        }

        @NotNull
        public final LuckPerms getLUCKPERMS() {
            LuckPerms luckPerms = LUCKPERMS;
            if (luckPerms != null) {
                return luckPerms;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"LUCKPERMS");
            return null;
        }

        public final void setLUCKPERMS(@NotNull LuckPerms luckPerms) {
            Intrinsics.checkNotNullParameter((Object)luckPerms, (String)"<set-?>");
            LUCKPERMS = luckPerms;
        }

        @NotNull
        public final MinecraftServer getSERVER() {
            MinecraftServer minecraftServer = SERVER;
            if (minecraftServer != null) {
                return minecraftServer;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"SERVER");
            return null;
        }

        public final void setSERVER(@NotNull MinecraftServer minecraftServer) {
            Intrinsics.checkNotNullParameter((Object)minecraftServer, (String)"<set-?>");
            SERVER = minecraftServer;
        }

        @NotNull
        public final CGuiManager getGUIs() {
            return GUIs;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR'\u0010\u000b\u001a\u00070\t\u00a2\u0006\u0002\b\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Ldev/roanoke/rib/Rib$Rib;", "", "<init>", "()V", "", "string", "Lnet/minecraft/class_2561;", "parseText", "(Ljava/lang/String;)Lnet/minecraft/class_2561;", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "Lorg/jetbrains/annotations/NotNull;", "mm", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "getMm", "()Lnet/kyori/adventure/text/minimessage/MiniMessage;", "setMm", "(Lnet/kyori/adventure/text/minimessage/MiniMessage;)V", "Rib"})
    public static final class Rib {
        @NotNull
        public static final Rib INSTANCE = new Rib();
        @NotNull
        private static MiniMessage mm;

        private Rib() {
        }

        @NotNull
        public final MiniMessage getMm() {
            return mm;
        }

        public final void setMm(@NotNull MiniMessage miniMessage) {
            Intrinsics.checkNotNullParameter((Object)miniMessage, (String)"<set-?>");
            mm = miniMessage;
        }

        @NotNull
        public final class_2561 parseText(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"\u00a7", (boolean)false, (int)2, null)) {
                class_5250 class_52502 = class_2561.method_43470((String)string);
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
                return (class_2561)class_52502;
            }
            class_2561 class_25612 = Companion.getADVENTURE().toNative(mm.deserialize((Object)("<!italic>" + string)));
            Intrinsics.checkNotNullExpressionValue((Object)class_25612, (String)"toNative(...)");
            return class_25612;
        }

        static {
            MiniMessage miniMessage = MiniMessage.miniMessage();
            Intrinsics.checkNotNullExpressionValue((Object)miniMessage, (String)"miniMessage(...)");
            mm = miniMessage;
        }
    }
}

