/*
 * Decompiled with CFR 0.152.
 */
package dev.roanoke.rib.gui.configurable;

import com.google.gson.Gson;
import dev.roanoke.rib.Rib;
import dev.roanoke.rib.gui.configurable.ConfiguredGUI;
import dev.roanoke.rib.utils.ItemBuilder;
import java.io.Closeable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\tJ\u0017\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0014\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0016\u0010\tJ\u000f\u0010\u0017\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0017\u0010\tR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0018R\u0014\u0010\u0004\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0018R#\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00100\u00198\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001d\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0\u001e8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Ldev/roanoke/rib/gui/configurable/CGuiManager;", "", "Ljava/nio/file/Path;", "guiDirectory", "itemDefinitions", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "", "setup", "()V", "reload", "", "id", "Ldev/roanoke/rib/gui/configurable/ConfiguredGUI;", "getGui", "(Ljava/lang/String;)Ldev/roanoke/rib/gui/configurable/ConfiguredGUI;", "Ldev/roanoke/rib/utils/ItemBuilder;", "getItem", "(Ljava/lang/String;)Ldev/roanoke/rib/utils/ItemBuilder;", "default", "getItemOrDefault", "(Ljava/lang/String;Ldev/roanoke/rib/utils/ItemBuilder;)Ldev/roanoke/rib/utils/ItemBuilder;", "loadItems", "loadGUIs", "Ljava/nio/file/Path;", "", "items", "Ljava/util/Map;", "getItems", "()Ljava/util/Map;", "", "guis", "Ljava/util/List;", "getGuis", "()Ljava/util/List;", "Rib"})
@SourceDebugExtension(value={"SMAP\nCGuiManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CGuiManager.kt\ndev/roanoke/rib/gui/configurable/CGuiManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class CGuiManager {
    @NotNull
    private final Path guiDirectory;
    @NotNull
    private final Path itemDefinitions;
    @NotNull
    private final Map<String, ItemBuilder> items;
    @NotNull
    private final List<ConfiguredGUI> guis;

    public CGuiManager(@NotNull Path guiDirectory, @NotNull Path itemDefinitions) {
        Intrinsics.checkNotNullParameter((Object)guiDirectory, (String)"guiDirectory");
        Intrinsics.checkNotNullParameter((Object)itemDefinitions, (String)"itemDefinitions");
        this.guiDirectory = guiDirectory;
        this.itemDefinitions = itemDefinitions;
        this.items = new LinkedHashMap();
        this.guis = new ArrayList();
    }

    @NotNull
    public final Map<String, ItemBuilder> getItems() {
        return this.items;
    }

    @NotNull
    public final List<ConfiguredGUI> getGuis() {
        return this.guis;
    }

    public final void setup() {
        this.loadItems();
        this.loadGUIs();
    }

    public final void reload() {
        this.items.clear();
        this.guis.clear();
        this.setup();
    }

    @Nullable
    public final ConfiguredGUI getGui(@NotNull String id) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable iterable = this.guis;
            for (Object t : iterable) {
                ConfiguredGUI it = (ConfiguredGUI)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final ItemBuilder getItem(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.items.get(id);
    }

    @NotNull
    public final ItemBuilder getItemOrDefault(@NotNull String id, @NotNull ItemBuilder itemBuilder) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)itemBuilder, (String)"default");
        return this.items.getOrDefault(id, itemBuilder);
    }

    public static /* synthetic */ ItemBuilder getItemOrDefault$default(CGuiManager cGuiManager, String string, ItemBuilder itemBuilder, int n, Object object) {
        if ((n & 2) != 0) {
            itemBuilder = new ItemBuilder("minecraft:dirt");
        }
        return cGuiManager.getItemOrDefault(string, itemBuilder);
    }

    private final void loadItems() {
        try {
            String jsonContent = Files.readString(this.itemDefinitions);
            com.google.gson.JsonObject jsonObject = (com.google.gson.JsonObject)new Gson().fromJson(jsonContent, com.google.gson.JsonObject.class);
            for (Map.Entry entry : jsonObject.entrySet()) {
                ItemBuilder it;
                Intrinsics.checkNotNull((Object)entry);
                String key = (String)entry.getKey();
                com.google.gson.JsonElement value = (com.google.gson.JsonElement)entry.getValue();
                if (!value.isJsonObject()) continue;
                com.google.gson.JsonObject itemObject = value.getAsJsonObject();
                ItemBuilder item = ItemBuilder.fromJson(itemObject);
                if (item == null) continue;
                boolean bl = false;
                this.items.put(key, it);
            }
        }
        catch (Exception e) {
            Rib.LOGGER.error("Error loading Items in GUI Manager. ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadGUIs() {
        try {
            Closeable closeable = Files.newDirectoryStream(this.guiDirectory, "*.json");
            Throwable throwable = null;
            try {
                DirectoryStream directoryStream = (DirectoryStream)closeable;
                boolean bl = false;
                Iterator iterator = directoryStream.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    Path path = (Path)iterator2.next();
                    String jsonContent = Files.readString(path);
                    Intrinsics.checkNotNull((Object)jsonContent);
                    JsonObject jsonObject = JsonElementKt.getJsonObject((JsonElement)Json.Default.parseToJsonElement(jsonContent));
                    ConfiguredGUI cGui = ConfiguredGUI.Companion.fromJson(jsonObject, this.items);
                    if (cGui == null) continue;
                    boolean bl2 = false;
                    this.guis.add(cGui);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            Rib.LOGGER.error("Error loading GUIs in GUI Manager. ", (Throwable)e);
        }
    }
}

