/*
 * Decompiled with CFR 0.152.
 */
package dev.roanoke.rib.messages;

import dev.roanoke.rib.Rib;
import dev.roanoke.rib.messages.Messages;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\t\u0010\nJ;\u0010\u000f\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000e0\r2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J7\u0010\u0013\u001a\u00020\b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000eH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0015\u0010\nJ\u000f\u0010\u0016\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0016\u0010\nJ+\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001cR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001dR \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR \u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010\u001fR\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Ldev/roanoke/rib/messages/FileBackedMessages;", "Ldev/roanoke/rib/messages/Messages;", "Ljava/nio/file/Path;", "filePath", "", "bundledResourcePath", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "", "loadAndMerge", "()V", "Lkotlinx/serialization/json/JsonObject;", "obj", "Lkotlin/Pair;", "", "extractMaps", "(Lkotlinx/serialization/json/JsonObject;)Lkotlin/Pair;", "msgs", "phs", "migratePrefix", "(Ljava/util/Map;Ljava/util/Map;)V", "save", "reload", "key", "", "placeholders", "getMessage", "(Ljava/lang/String;Ljava/util/Map;)Ljava/lang/String;", "Ljava/nio/file/Path;", "Ljava/lang/String;", "messages", "Ljava/util/Map;", "globalPlaceholders", "Lkotlinx/serialization/json/Json;", "json", "Lkotlinx/serialization/json/Json;", "Rib"})
@SourceDebugExtension(value={"SMAP\nFileBackedMessages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileBackedMessages.kt\ndev/roanoke/rib/messages/FileBackedMessages\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,187:1\n1#2:188\n216#3:189\n216#3,2:190\n217#3:192\n216#3,2:199\n465#4:193\n415#4:194\n1252#5,4:195\n113#6:201\n*S KotlinDebug\n*F\n+ 1 FileBackedMessages.kt\ndev/roanoke/rib/messages/FileBackedMessages\n*L\n106#1:189\n108#1:190,2\n106#1:192\n149#1:199,2\n142#1:193\n142#1:194\n142#1:195,4\n157#1:201\n*E\n"})
public final class FileBackedMessages
extends Messages {
    @NotNull
    private final Path filePath;
    @NotNull
    private final String bundledResourcePath;
    @NotNull
    private final Map<String, String> messages;
    @NotNull
    private final Map<String, String> globalPlaceholders;
    @NotNull
    private final Json json;

    public FileBackedMessages(@NotNull Path filePath, @NotNull String bundledResourcePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)bundledResourcePath, (String)"bundledResourcePath");
        this.filePath = filePath;
        this.bundledResourcePath = bundledResourcePath;
        this.messages = new LinkedHashMap();
        this.globalPlaceholders = new LinkedHashMap();
        this.json = JsonKt.Json$default(null, FileBackedMessages::json$lambda$0, (int)1, null);
        this.loadAndMerge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadAndMerge() {
        Object it;
        InputStream inputStream = this.getClass().getResourceAsStream(this.bundledResourcePath);
        if (inputStream == null) {
            throw new IllegalStateException("Bundled messages not found at " + this.bundledResourcePath);
        }
        InputStream bundledStream = inputStream;
        Closeable closeable = bundledStream;
        Pair<Map<String, String>, Map<String, String>> pair = null;
        try {
            it = (InputStream)closeable;
            boolean bl = false;
            it = TextStreamsKt.readText((Reader)new InputStreamReader((InputStream)it, StandardCharsets.UTF_8));
        }
        catch (Throwable bl) {
            pair = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)pair);
        }
        Object bundledText = it;
        JsonObject bundledObj = JsonElementKt.getJsonObject((JsonElement)this.json.parseToJsonElement((String)bundledText));
        pair = this.extractMaps(bundledObj);
        Map bundledMessages = (Map)pair.component1();
        Map bundledPlaceholders = (Map)pair.component2();
        this.migratePrefix(bundledMessages, bundledPlaceholders);
        if (!Files.exists(this.filePath, new LinkOption[0])) {
            Path path = this.filePath.getParent();
            if (path != null) {
                Path it2 = path;
                boolean bl = false;
                Files.createDirectories(it2, new FileAttribute[0]);
            }
            this.messages.putAll(bundledMessages);
            this.globalPlaceholders.putAll(bundledPlaceholders);
            this.save();
            return;
        }
        try {
            String v;
            String k;
            String existingText = Files.readString(this.filePath, StandardCharsets.UTF_8);
            Intrinsics.checkNotNull((Object)existingText);
            JsonObject existingObj = JsonElementKt.getJsonObject((JsonElement)this.json.parseToJsonElement(existingText));
            Pair<Map<String, String>, Map<String, String>> pair2 = this.extractMaps(existingObj);
            Map existingMessages = (Map)pair2.component1();
            Map existingPlaceholders = (Map)pair2.component2();
            this.migratePrefix(existingMessages, existingPlaceholders);
            boolean dirty = false;
            this.messages.putAll(existingMessages);
            this.globalPlaceholders.putAll(existingPlaceholders);
            for (Map.Entry entry : bundledMessages.entrySet()) {
                k = (String)entry.getKey();
                v = (String)entry.getValue();
                if (this.messages.containsKey(k)) continue;
                this.messages.put(k, v);
                dirty = true;
            }
            for (Map.Entry entry : bundledPlaceholders.entrySet()) {
                k = (String)entry.getKey();
                v = (String)entry.getValue();
                if (this.globalPlaceholders.containsKey(k)) continue;
                this.globalPlaceholders.put(k, v);
                dirty = true;
            }
            if (dirty) {
                this.save();
            }
        }
        catch (Exception e) {
            Rib.LOGGER.warn("Failed to load messages file at " + this.filePath + ", falling back to bundled", (Throwable)e);
            this.messages.clear();
            this.globalPlaceholders.clear();
            this.messages.putAll(bundledMessages);
            this.globalPlaceholders.putAll(bundledPlaceholders);
            this.save();
        }
    }

    private final Pair<Map<String, String>, Map<String, String>> extractMaps(JsonObject obj) {
        LinkedHashMap msgs = new LinkedHashMap();
        LinkedHashMap phs = new LinkedHashMap();
        Map $this$forEach$iv = (Map)obj;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (Intrinsics.areEqual((Object)key, (Object)"placeholders") && value instanceof JsonObject) {
                Map $this$forEach$iv2 = (Map)value;
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv2;
                    Map.Entry entry2 = element$iv2 = iterator2.next();
                    boolean bl2 = false;
                    String phKey = (String)entry2.getKey();
                    JsonElement phVal = (JsonElement)entry2.getValue();
                    if (!(phVal instanceof JsonPrimitive) || !((JsonPrimitive)phVal).isString()) continue;
                    ((Map)phs).put(phKey, ((JsonPrimitive)phVal).getContent());
                }
                continue;
            }
            if (!(value instanceof JsonPrimitive) || !((JsonPrimitive)value).isString()) continue;
            ((Map)msgs).put(key, ((JsonPrimitive)value).getContent());
        }
        return TuplesKt.to(msgs, phs);
    }

    private final void migratePrefix(Map<String, String> msgs, Map<String, String> phs) {
        if (!phs.containsKey("{prefix}") && msgs.containsKey("prefix")) {
            String string = msgs.remove("prefix");
            if (string == null) {
                return;
            }
            String prefixVal = string;
            phs.put("{prefix}", prefixVal);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void save() {
        void $this$mapValuesTo$iv$iv;
        Map<String, String> $this$mapValues$iv = this.globalPlaceholders;
        boolean $i$f$mapValues22 = false;
        Map<String, String> map = $this$mapValues$iv;
        Object destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            JsonPrimitive jsonPrimitive = JsonElementKt.JsonPrimitive((String)((String)it.getValue()));
            map3.put(k, jsonPrimitive);
        }
        Map map4 = destination$iv$iv;
        JsonObject placeholdersObj = new JsonObject(map4);
        Pair[] $i$f$mapValues22 = new Pair[]{TuplesKt.to((Object)"placeholders", (Object)placeholdersObj)};
        Map rootEntries = MapsKt.mutableMapOf((Pair[])$i$f$mapValues22);
        Map<String, String> $this$forEach$iv = this.messages;
        boolean $i$f$forEach = false;
        destination$iv$iv = $this$forEach$iv.entrySet().iterator();
        while (destination$iv$iv.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)destination$iv$iv.next();
            boolean bl = false;
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            rootEntries.put(k, JsonElementKt.JsonPrimitive((String)v));
        }
        JsonObject root = new JsonObject(rootEntries);
        StringFormat $this$encodeToString$iv = (StringFormat)this.json;
        boolean $i$f$encodeToString = false;
        SerializersModule serializersModule = $this$encodeToString$iv.getSerializersModule();
        KType kType = Reflection.typeOf(JsonObject.class);
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        Files.writeString(this.filePath, (CharSequence)$this$encodeToString$iv.encodeToString((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), (Object)root), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    @Override
    public void reload() {
        this.messages.clear();
        this.globalPlaceholders.clear();
        this.loadAndMerge();
    }

    @Override
    @NotNull
    public String getMessage(@NotNull String key, @NotNull Map<String, String> placeholders) {
        String phVal;
        String phKey;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        String string = this.messages.get(key);
        if (string == null) {
            string = key;
        }
        String msg = string;
        for (Map.Entry<String, String> entry : this.globalPlaceholders.entrySet()) {
            phKey = entry.getKey();
            phVal = entry.getValue();
            msg = StringsKt.replace$default((String)msg, (String)phKey, (String)phVal, (boolean)false, (int)4, null);
        }
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            phKey = entry.getKey();
            phVal = entry.getValue();
            msg = StringsKt.replace$default((String)msg, (String)phKey, (String)phVal, (boolean)false, (int)4, null);
        }
        return msg;
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }
}

