/*
 * Decompiled with CFR 0.152.
 */
package dev.roanoke.rib.quests;

import com.google.gson.JsonObject;
import dev.roanoke.rib.Rib;
import dev.roanoke.rib.quests.Quest;
import dev.roanoke.rib.quests.QuestFactory;
import dev.roanoke.rib.quests.QuestGroup;
import dev.roanoke.rib.quests.QuestProvider;
import dev.roanoke.rib.quests.types.cobblemon.CatchPokemonQuest;
import dev.roanoke.rib.quests.types.cobblemon.DefeatPokemonQuest;
import dev.roanoke.rib.quests.types.cobblemon.EvolvePokemonQuest;
import dev.roanoke.rib.quests.types.cobblemon.HarvestApricornQuest;
import dev.roanoke.rib.quests.types.cobblemon.HavePokemonQuest;
import dev.roanoke.rib.quests.types.cobblemon.NicknamePokemonQuest;
import dev.roanoke.rib.quests.types.cobblemon.ReleasePokemonQuest;
import dev.roanoke.rib.quests.types.cobblemon.ReviveFossilQuest;
import dev.roanoke.rib.quests.types.cobblemon.TradePokemonQuest;
import dev.roanoke.rib.quests.types.minecraft.BreakBlockQuest;
import dev.roanoke.rib.quests.types.minecraft.CraftItemQuest;
import dev.roanoke.rib.quests.types.minecraft.EnterBoxQuest;
import dev.roanoke.rib.quests.types.other.HasPermissionQuest;
import dev.roanoke.rib.quests.types.placeholders.IntPlaceholderQuest;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ-\u0010\u0013\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\b\u00a2\u0006\u0004\b\u0015\u0010\u0003R \u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Ldev/roanoke/rib/quests/QuestRegistry;", "", "<init>", "()V", "", "type", "Ldev/roanoke/rib/quests/QuestFactory;", "factory", "", "registerQuestType", "(Ljava/lang/String;Ldev/roanoke/rib/quests/QuestFactory;)V", "Lcom/google/gson/JsonObject;", "definition", "state", "Ldev/roanoke/rib/quests/QuestProvider;", "provider", "Ldev/roanoke/rib/quests/QuestGroup;", "group", "Ldev/roanoke/rib/quests/Quest;", "createQuest", "(Lcom/google/gson/JsonObject;Lcom/google/gson/JsonObject;Ldev/roanoke/rib/quests/QuestProvider;Ldev/roanoke/rib/quests/QuestGroup;)Ldev/roanoke/rib/quests/Quest;", "registerDefaultQuests", "", "questFactories", "Ljava/util/Map;", "Rib"})
public final class QuestRegistry {
    @NotNull
    public static final QuestRegistry INSTANCE = new QuestRegistry();
    @NotNull
    private static final Map<String, QuestFactory> questFactories = new LinkedHashMap();

    private QuestRegistry() {
    }

    public final void registerQuestType(@NotNull String type, @NotNull QuestFactory factory) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        if (questFactories.containsKey(type)) {
            throw new IllegalArgumentException("Quest type " + type + " is already registered.");
        }
        Rib.LOGGER.info("[Rib] Registered Quest: " + type);
        questFactories.put(type, factory);
    }

    @NotNull
    public final Quest createQuest(@NotNull JsonObject definition, @NotNull JsonObject state, @NotNull QuestProvider provider, @NotNull QuestGroup group) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        String type = definition.get("type").getAsString();
        QuestFactory questFactory = questFactories.get(type);
        if (questFactory == null) {
            throw new IllegalArgumentException("Unsupported Quest Type: " + type);
        }
        QuestFactory factory = questFactory;
        return factory.fromJson(definition, state, provider, group);
    }

    public final void registerDefaultQuests() {
        INSTANCE.registerQuestType("BreakBlockQuest", BreakBlockQuest.Companion);
        INSTANCE.registerQuestType("CraftItemQuest", CraftItemQuest.Companion);
        INSTANCE.registerQuestType("EnterBoxQuest", EnterBoxQuest.Companion);
        INSTANCE.registerQuestType("HavePokemonQuest", HavePokemonQuest.Companion);
        INSTANCE.registerQuestType("CatchPokemonQuest", CatchPokemonQuest.Companion);
        INSTANCE.registerQuestType("HarvestApricornQuest", HarvestApricornQuest.Companion);
        INSTANCE.registerQuestType("DefeatPokemonQuest", DefeatPokemonQuest.Companion);
        INSTANCE.registerQuestType("NicknamePokemonQuest", NicknamePokemonQuest.Companion);
        INSTANCE.registerQuestType("TradePokemonQuest", TradePokemonQuest.Companion);
        INSTANCE.registerQuestType("ReleasePokemonQuest", ReleasePokemonQuest.Companion);
        INSTANCE.registerQuestType("EvolvePokemonQuest", EvolvePokemonQuest.Companion);
        INSTANCE.registerQuestType("ReviveFossilQuest", ReviveFossilQuest.Companion);
        INSTANCE.registerQuestType("IntPlaceholderQuest", IntPlaceholderQuest.Companion);
        INSTANCE.registerQuestType("HasPermissionQuest", HasPermissionQuest.Companion);
    }
}

