/*
 * Decompiled with CFR 0.152.
 */
package dev.roanoke.rib.requirements;

import dev.roanoke.rib.Rib;
import dev.roanoke.rib.requirements.Requirement;
import dev.roanoke.rib.requirements.RequirementFactory;
import dev.roanoke.rib.requirements.types.HasBattleablePokemonRequirement;
import dev.roanoke.rib.requirements.types.MultiRequirement;
import dev.roanoke.rib.requirements.types.PermissionRequirement;
import dev.roanoke.rib.requirements.types.PokemonPropertiesRequirement;
import dev.roanoke.rib.requirements.types.TeamLevelRequirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b\u00a2\u0006\u0004\b\u000f\u0010\rJ\u0015\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\b\u00a2\u0006\u0004\b\u0014\u0010\u0003R \u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Ldev/roanoke/rib/requirements/RequirementRegistry;", "", "<init>", "()V", "", "type", "Ldev/roanoke/rib/requirements/RequirementFactory;", "factory", "", "register", "(Ljava/lang/String;Ldev/roanoke/rib/requirements/RequirementFactory;)V", "", "getTypes", "()Ljava/util/List;", "Ldev/roanoke/rib/requirements/Requirement;", "getRequirements", "Lkotlinx/serialization/json/JsonObject;", "json", "getRequirement", "(Lkotlinx/serialization/json/JsonObject;)Ldev/roanoke/rib/requirements/Requirement;", "registerDefaults", "", "requirementFactories", "Ljava/util/Map;", "Rib"})
@SourceDebugExtension(value={"SMAP\nRequirementRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequirementRegistry.kt\ndev/roanoke/rib/requirements/RequirementRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1563#2:47\n1634#2,3:48\n*S KotlinDebug\n*F\n+ 1 RequirementRegistry.kt\ndev/roanoke/rib/requirements/RequirementRegistry\n*L\n26#1:47\n26#1:48,3\n*E\n"})
public final class RequirementRegistry {
    @NotNull
    public static final RequirementRegistry INSTANCE = new RequirementRegistry();
    @NotNull
    private static final Map<String, RequirementFactory> requirementFactories = new LinkedHashMap();

    private RequirementRegistry() {
    }

    public final void register(@NotNull String type, @NotNull RequirementFactory factory) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        if (requirementFactories.containsKey(type)) {
            throw new IllegalArgumentException("Requirement type " + type + " is already registered.");
        }
        Rib.LOGGER.info("[Rib] Registered Requirement: " + type);
        requirementFactories.put(type, factory);
    }

    @NotNull
    public final List<String> getTypes() {
        return CollectionsKt.toList((Iterable)requirementFactories.keySet());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Requirement> getRequirements() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = requirementFactories.values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RequirementFactory requirementFactory = (RequirementFactory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.fromKson(new JsonObject(MapsKt.emptyMap())));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Requirement getRequirement(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Object object = (JsonElement)json.get((Object)"type");
        if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = JsonElementKt.getContentOrNull((JsonPrimitive)object)) == null) {
            throw new IllegalArgumentException("Requirement has no type field!");
        }
        Object type = object;
        RequirementFactory requirementFactory = requirementFactories.get(type);
        if (requirementFactory == null) {
            throw new IllegalArgumentException("Unsupported Requirement Type: " + (String)type);
        }
        RequirementFactory factory = requirementFactory;
        return factory.fromKson(json);
    }

    public final void registerDefaults() {
        this.register("TeamLevelRequirement", TeamLevelRequirement.Companion);
        this.register("PokemonPropertiesRequirement", PokemonPropertiesRequirement.Companion);
        this.register("PermissionRequirement", PermissionRequirement.Companion);
        this.register("MultiRequirement", MultiRequirement.Companion);
        this.register("HasBattleablePokemonRequirement", HasBattleablePokemonRequirement.Companion);
    }
}

