/*
 * Decompiled with CFR 0.152.
 */
package dev.roanoke.rib.requirements.types;

import dev.roanoke.rib.Rib;
import dev.roanoke.rib.gui.settings.Setting;
import dev.roanoke.rib.gui.settings.SettingsManager;
import dev.roanoke.rib.gui.settings.types.StringSetting;
import dev.roanoke.rib.requirements.Requirement;
import dev.roanoke.rib.requirements.RequirementFactory;
import dev.roanoke.rib.utils.LoreLike;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000  2\u00020\u0001:\u0001 B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0004\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0014J\u001b\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00160\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\"\u0010\u0004\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010\u0019\u001a\u0004\b\u001e\u0010\u001b\"\u0004\b\u001f\u0010\u001d\u00a8\u0006!"}, d2={"Ldev/roanoke/rib/requirements/types/PermissionRequirement;", "Ldev/roanoke/rib/requirements/Requirement;", "", "permission", "prompt", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "", "registerSettings", "()V", "", "description", "()Ljava/util/List;", "Lnet/minecraft/class_3222;", "player", "", "passesRequirement", "(Lnet/minecraft/class_3222;)Z", "Ldev/roanoke/rib/utils/LoreLike;", "error", "()Ldev/roanoke/rib/utils/LoreLike;", "", "Lkotlinx/serialization/json/JsonElement;", "saveSpecifics", "()Ljava/util/Map;", "Ljava/lang/String;", "getPermission", "()Ljava/lang/String;", "setPermission", "(Ljava/lang/String;)V", "getPrompt", "setPrompt", "Companion", "Rib"})
public final class PermissionRequirement
extends Requirement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String permission;
    @NotNull
    private String prompt;

    public PermissionRequirement(@NotNull String permission, @NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        super("PermissionRequirement", "Permission Requirement");
        this.permission = permission;
        this.prompt = prompt;
        this.registerSettings();
    }

    @NotNull
    public final String getPermission() {
        return this.permission;
    }

    public final void setPermission(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.permission = string;
    }

    @NotNull
    public final String getPrompt() {
        return this.prompt;
    }

    public final void setPrompt(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.prompt = string;
    }

    @Override
    public void registerSettings() {
        StringSetting it;
        StringSetting stringSetting;
        this.setSettings(new SettingsManager(this));
        Setting[] settingArray = new Setting[2];
        StringSetting stringSetting2 = stringSetting = new StringSetting("Prompt", (Function0<String>)((Function0)() -> PermissionRequirement.registerSettings$lambda$0(this)), (Function1<? super String, Unit>)((Function1)arg_0 -> PermissionRequirement.registerSettings$lambda$1(this, arg_0)));
        int n = 0;
        Setting[] settingArray2 = settingArray;
        SettingsManager settingsManager = this.getSettings();
        boolean bl = false;
        it.setDescription("\n<gray>The display message a player will see so they know what they need.\n");
        Unit unit = Unit.INSTANCE;
        settingArray2[n] = stringSetting;
        it = stringSetting = new StringSetting("Permission", (Function0<String>)((Function0)() -> PermissionRequirement.registerSettings$lambda$3(this)), (Function1<? super String, Unit>)((Function1)arg_0 -> PermissionRequirement.registerSettings$lambda$4(this, arg_0)));
        n = 1;
        settingArray2 = settingArray;
        boolean bl2 = false;
        it.setDescription("\n<gray>The permission node that's required\n<gray>E.g. 'ggyms.command.reload'\n");
        unit = Unit.INSTANCE;
        settingArray2[n] = stringSetting;
        settingsManager.addSettings(settingArray);
    }

    @Override
    @NotNull
    public List<String> description() {
        Object[] objectArray = new String[]{"Require a player to have a certain permission node", "Note - you <bold>need<reset> the permission node, even if you're OP'd"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public boolean passesRequirement(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return Rib.PERMISSIONS.hasPermission(player, this.permission);
    }

    @Override
    @NotNull
    public LoreLike error() {
        return LoreLike.Companion.ofString("<red>" + this.prompt);
    }

    @Override
    @NotNull
    public LoreLike prompt() {
        return LoreLike.Companion.ofString(this.prompt);
    }

    @Override
    @NotNull
    public Map<String, JsonElement> saveSpecifics() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"permission", (Object)JsonElementKt.JsonPrimitive((String)this.permission)), TuplesKt.to((Object)"prompt", (Object)JsonElementKt.JsonPrimitive((String)this.prompt))};
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    private static final String registerSettings$lambda$0(PermissionRequirement this$0) {
        return this$0.prompt;
    }

    private static final Unit registerSettings$lambda$1(PermissionRequirement this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.prompt = it;
        return Unit.INSTANCE;
    }

    private static final String registerSettings$lambda$3(PermissionRequirement this$0) {
        return this$0.permission;
    }

    private static final Unit registerSettings$lambda$4(PermissionRequirement this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.permission = it;
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/roanoke/rib/requirements/types/PermissionRequirement$Companion;", "Ldev/roanoke/rib/requirements/RequirementFactory;", "<init>", "()V", "Lkotlinx/serialization/json/JsonObject;", "json", "Ldev/roanoke/rib/requirements/Requirement;", "fromKson", "(Lkotlinx/serialization/json/JsonObject;)Ldev/roanoke/rib/requirements/Requirement;", "Rib"})
    public static final class Companion
    implements RequirementFactory {
        private Companion() {
        }

        @Override
        @NotNull
        public Requirement fromKson(@NotNull JsonObject json) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Object object2 = (JsonElement)json.get((Object)"permission");
            if (object2 == null || (object2 = JsonElementKt.getJsonPrimitive((JsonElement)object2)) == null || (object2 = JsonElementKt.getContentOrNull((JsonPrimitive)object2)) == null) {
                object2 = "";
            }
            if ((object = (JsonElement)json.get((Object)"prompt")) == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = JsonElementKt.getContentOrNull((JsonPrimitive)object)) == null) {
                object = "";
            }
            return new PermissionRequirement((String)object2, (String)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

