/*
 * Decompiled with CFR 0.152.
 */
package dev.roanoke.rib.utils;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.item.PokemonItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import dev.roanoke.rib.Rib;
import dev.roanoke.rib.cereal.JsonConv;
import dev.roanoke.rib.utils.LoreLike;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kotlinx.serialization.json.JsonObject;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9280;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class ItemBuilder {
    class_1799 stack = null;

    public ItemBuilder(class_1792 item) {
        this.stack = new class_1799((class_1935)item);
    }

    public ItemBuilder(class_1799 item) {
        this.stack = item.method_7972();
    }

    public ItemBuilder(String itemId) {
        class_2960 identifier = class_2960.method_12829((String)itemId);
        if (identifier == null) {
            Rib.LOGGER.error("Failed to parse Item ID: {}", (Object)itemId);
        }
        this.stack = ((class_1792)class_7923.field_41178.method_10223(identifier)).method_7854();
    }

    public static ItemBuilder fromPokemon(Pokemon pokemon) {
        return new ItemBuilder(PokemonItem.from((Pokemon)pokemon, (int)1));
    }

    public static ItemBuilder fromPokemonProperties(PokemonProperties props) {
        return new ItemBuilder(PokemonItem.from((PokemonProperties)props, (int)1));
    }

    public static ItemBuilder fromPokemonProperties(String props) {
        return ItemBuilder.fromPokemonProperties(PokemonProperties.Companion.parse(props));
    }

    public static ItemBuilder fromJson(JsonObject json) {
        return ItemBuilder.fromJson(JsonConv.INSTANCE.kotlinJsonToGsonJson(json));
    }

    public static ItemBuilder fromJson(com.google.gson.JsonObject itemData) {
        List<class_2561> loreEntries;
        ItemBuilder itemBuilder;
        if (!itemData.has("id") && !itemData.has("pokemon")) {
            Rib.LOGGER.debug("Failed to load Item from Json, needs either ID or Pokemon key: {}", (Object)itemData);
            return null;
        }
        if (itemData.has("pokemon")) {
            itemBuilder = ItemBuilder.fromPokemonProperties(itemData.get("pokemon").getAsString());
        } else if (itemData.has("id")) {
            itemBuilder = new ItemBuilder(itemData.get("id").getAsString());
        } else {
            Rib.LOGGER.debug("Failed to load Item from Json, needs either ID or Pokemon key: {}", (Object)itemData);
            return null;
        }
        if (itemData.has("name")) {
            try {
                class_2561 name = Rib.Rib.INSTANCE.parseText(itemData.get("name").getAsString());
                itemBuilder.setCustomName(name);
            }
            catch (Exception e) {
                Rib.LOGGER.error("Error parsing name for item: {}", (Object)e.getMessage());
            }
        }
        if (itemData.has("amount")) {
            itemBuilder.setAmount(itemData.get("amount").getAsInt());
        }
        if (itemData.has("customModelData")) {
            itemBuilder.setCustomModelData(itemData.get("customModelData").getAsInt());
        }
        if (itemData.has("lore") && !(loreEntries = itemData.getAsJsonArray("lore").asList().stream().map(it -> {
            try {
                return Rib.Rib.INSTANCE.parseText(it.getAsString());
            }
            catch (Exception e) {
                Rib.LOGGER.error("Error parsing lore text: {}", (Object)e.getMessage());
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            itemBuilder.addLore(loreEntries);
        }
        return itemBuilder;
    }

    public String getItemID() {
        return class_7923.field_41178.method_10221((Object)this.stack.method_7909()).toString();
    }

    public boolean matches(class_1799 stack) {
        if (stack.method_31574(this.build().method_7909())) {
            return new ItemBuilder(stack).getCustomModelData() == this.getCustomModelData();
        }
        return false;
    }

    public ItemBuilder setAmount(int amount) {
        this.stack.method_7939(amount);
        return this;
    }

    public int getCustomModelData() {
        class_9280 data = (class_9280)this.stack.method_57824(class_9334.field_49637);
        if (data == null) {
            return 0;
        }
        return data.comp_2382();
    }

    public ItemBuilder setCustomModelData(int customModelData) {
        this.stack.method_57379(class_9334.field_49637, (Object)new class_9280(customModelData));
        return this;
    }

    public ItemBuilder addLore(List<class_2561> lore) {
        this.stack.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
        return this;
    }

    public ItemBuilder addLore(class_2561[] lore) {
        return this.addLore(Arrays.stream(lore).toList());
    }

    public ItemBuilder addLoreStrings(List<String> lore) {
        return this.addLore(lore.stream().map(Rib.Rib.INSTANCE::parseText).toList());
    }

    public ItemBuilder addLore(LoreLike lore) {
        return this.addLore(lore.getLore());
    }

    public ItemBuilder setCount(int count) {
        this.stack.method_7939(count);
        return this;
    }

    public ItemBuilder hideAdditional() {
        return this;
    }

    public ItemBuilder setCustomName(class_2561 customName) {
        this.stack.method_57379(class_9334.field_49631, (Object)customName);
        return this;
    }

    public ItemBuilder setName(class_2561 name) {
        return this.setCustomName(name);
    }

    public ItemBuilder setName(String name) {
        return this.setCustomName(Rib.Rib.INSTANCE.parseText(name));
    }

    public class_1799 build() {
        this.hideAdditional();
        return this.stack.method_7972();
    }

    public GuiElementBuilder gbuild() {
        return GuiElementBuilder.from((class_1799)this.build());
    }

    public com.google.gson.JsonObject toJson() {
        com.google.gson.JsonObject itemData = new com.google.gson.JsonObject();
        itemData.addProperty("id", this.getItemID());
        if (this.getCustomModelData() != 0) {
            itemData.addProperty("customModelData", (Number)this.getCustomModelData());
        }
        return itemData;
    }

    public String toString() {
        return this.stack.toString();
    }
}

