/*
 * Decompiled with CFR 0.152.
 */
package dev.roanoke.rib.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.roanoke.rib.Rib;
import dev.roanoke.rib.utils.ItemBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0017\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000fJ\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0016\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001c\u0010\u0015R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0014\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\"\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Ldev/roanoke/rib/utils/ItemManager;", "", "Ljava/nio/file/Path;", "itemsConfigPath", "", "defaultItemsConfigPath", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "", "reload", "()V", "setup", "Ljava/io/File;", "file", "importItemsFromJar", "(Ljava/io/File;)V", "mergeMissingFromBundled", "loadItems", "name", "Ldev/roanoke/rib/utils/ItemBuilder;", "get", "(Ljava/lang/String;)Ldev/roanoke/rib/utils/ItemBuilder;", "default", "getOrDefault", "(Ljava/lang/String;Ldev/roanoke/rib/utils/ItemBuilder;)Ldev/roanoke/rib/utils/ItemBuilder;", "Lnet/minecraft/class_1799;", "getItemStack", "(Ljava/lang/String;)Lnet/minecraft/class_1799;", "getItemBuilder", "Ljava/nio/file/Path;", "getItemsConfigPath", "()Ljava/nio/file/Path;", "setItemsConfigPath", "(Ljava/nio/file/Path;)V", "Ljava/lang/String;", "getDefaultItemsConfigPath", "()Ljava/lang/String;", "setDefaultItemsConfigPath", "(Ljava/lang/String;)V", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "", "items", "Ljava/util/Map;", "Rib"})
@SourceDebugExtension(value={"SMAP\nItemManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemManager.kt\ndev/roanoke/rib/utils/ItemManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n1869#2,2:147\n*S KotlinDebug\n*F\n+ 1 ItemManager.kt\ndev/roanoke/rib/utils/ItemManager\n*L\n115#1:147,2\n*E\n"})
public final class ItemManager {
    @NotNull
    private Path itemsConfigPath;
    @NotNull
    private String defaultItemsConfigPath;
    @NotNull
    private final Gson gson;
    @NotNull
    private Map<String, ItemBuilder> items;

    public ItemManager(@NotNull Path itemsConfigPath, @NotNull String defaultItemsConfigPath) {
        Intrinsics.checkNotNullParameter((Object)itemsConfigPath, (String)"itemsConfigPath");
        Intrinsics.checkNotNullParameter((Object)defaultItemsConfigPath, (String)"defaultItemsConfigPath");
        this.itemsConfigPath = itemsConfigPath;
        this.defaultItemsConfigPath = defaultItemsConfigPath;
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        this.gson = gson;
        this.items = new LinkedHashMap();
    }

    @NotNull
    public final Path getItemsConfigPath() {
        return this.itemsConfigPath;
    }

    public final void setItemsConfigPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.itemsConfigPath = path;
    }

    @NotNull
    public final String getDefaultItemsConfigPath() {
        return this.defaultItemsConfigPath;
    }

    public final void setDefaultItemsConfigPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.defaultItemsConfigPath = string;
    }

    public final void reload() {
        this.items.clear();
        this.setup();
    }

    public final void setup() {
        File file = this.itemsConfigPath.toFile();
        if (!file.exists()) {
            Intrinsics.checkNotNull((Object)file);
            this.importItemsFromJar(file);
        } else {
            Intrinsics.checkNotNull((Object)file);
            this.mergeMissingFromBundled(file);
        }
        this.loadItems(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void importItemsFromJar(File file) {
        InputStream inputStream = this.getClass().getResourceAsStream(this.defaultItemsConfigPath);
        if (inputStream == null) {
            throw new RuntimeException("Failed to find " + this.defaultItemsConfigPath + " inside the jar.");
        }
        InputStream inputStream2 = inputStream;
        try {
            File file2 = file.getParentFile();
            if (file2 != null) {
                file2.mkdirs();
            }
            Closeable closeable = inputStream2;
            Throwable throwable = null;
            try {
                long l;
                InputStream input = (InputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new FileOutputStream(file);
                Throwable throwable2 = null;
                try {
                    FileOutputStream output = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            Rib.LOGGER.error("Failed to copy items.json from jar to config folder: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeMissingFromBundled(File file) {
        Closeable closeable;
        Closeable it;
        InputStream inputStream = this.getClass().getResourceAsStream(this.defaultItemsConfigPath);
        if (inputStream == null) {
            throw new RuntimeException("Failed to find " + this.defaultItemsConfigPath + " inside the jar.");
        }
        InputStream bundledStream = inputStream;
        Closeable closeable2 = bundledStream;
        Object object = null;
        try {
            JsonObject jsonObject;
            it = (InputStream)closeable2;
            boolean bl = false;
            closeable = new InputStreamReader((InputStream)it, StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                InputStreamReader reader = (InputStreamReader)closeable;
                boolean bl2 = false;
                jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            it = jsonObject;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
        }
        InputStream bundledJson = it;
        try {
            FileReader reader;
            it = new FileReader(file);
            Throwable throwable = null;
            try {
                reader = (FileReader)it;
                boolean bl = false;
                reader = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)it, (Throwable)throwable);
            }
            object = reader;
            Intrinsics.checkNotNull((Object)object);
        }
        catch (Exception e) {
            Rib.LOGGER.warn("Failed to parse existing items config at " + file.getPath() + ", rebuilding from bundled", (Throwable)e);
            object = new JsonObject();
        }
        Throwable existingJson = object;
        boolean changed = false;
        for (Map.Entry entry : bundledJson.entrySet()) {
            Intrinsics.checkNotNull((Object)entry);
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (existingJson.has(key)) continue;
            existingJson.add(key, value);
            changed = true;
        }
        if (changed) {
            try {
                Closeable e = new FileWriter(file, false);
                Throwable throwable = null;
                try {
                    FileWriter writer = (FileWriter)e;
                    boolean bl = false;
                    this.gson.toJson((JsonElement)existingJson, (Appendable)writer);
                    closeable = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)e, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                Rib.LOGGER.error("Failed to write merged items config to " + file.getPath(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadItems(File file) {
        JsonObject jsonObject;
        Closeable closeable = new FileReader(file);
        Throwable throwable = null;
        try {
            FileReader reader = (FileReader)closeable;
            boolean bl = false;
            jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        JsonObject jsonObject2 = jsonObject;
        Set set = jsonObject2.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            String itemName = (String)entry.getKey();
            JsonObject itemData = ((JsonElement)entry.getValue()).getAsJsonObject();
            ItemBuilder itemBuilder = ItemBuilder.fromJson(itemData);
            if (itemBuilder == null) {
                Rib.LOGGER.info("Failed to load Item from Config: " + itemName);
                continue;
            }
            Rib.LOGGER.info("Loaded Item from Config: " + itemName);
            this.items.put(itemName, itemBuilder);
        }
    }

    @Nullable
    public final ItemBuilder get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.items.get(name);
    }

    @NotNull
    public final ItemBuilder getOrDefault(@NotNull String name, @NotNull ItemBuilder itemBuilder) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)itemBuilder, (String)"default");
        ItemBuilder itemBuilder2 = this.items.get(name);
        if (itemBuilder2 == null) {
            itemBuilder2 = itemBuilder;
        }
        return itemBuilder2;
    }

    public static /* synthetic */ ItemBuilder getOrDefault$default(ItemManager itemManager, String string, ItemBuilder itemBuilder, int n, Object object) {
        if ((n & 2) != 0) {
            itemBuilder = new ItemBuilder(class_1802.field_8494);
        }
        return itemManager.getOrDefault(string, itemBuilder);
    }

    @NotNull
    public final class_1799 getItemStack(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        class_1799 class_17992 = this.items.getOrDefault(name, new ItemBuilder("minecraft:gold_block")).build();
        Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"build(...)");
        return class_17992;
    }

    @NotNull
    public final ItemBuilder getItemBuilder(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.items.getOrDefault(name, new ItemBuilder("minecraft:gold_block"));
    }
}

