/*
 * Decompiled with CFR 0.152.
 */
package dev.roanoke.rib.utils;

import dev.roanoke.rib.Rib;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.cacheddata.CachedPermissionData;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.query.QueryOptions;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Ldev/roanoke/rib/utils/PermissionManager;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "Lnet/luckperms/api/model/user/User;", "getLuckPermsUser", "(Lnet/minecraft/class_3222;)Lnet/luckperms/api/model/user/User;", "", "permission", "", "hasPermission", "(Lnet/minecraft/class_3222;Ljava/lang/String;)Z", "node", "", "getMaxIntFromNode", "(Lnet/minecraft/class_3222;Ljava/lang/String;)I", "Rib"})
public final class PermissionManager {
    @NotNull
    public final User getLuckPermsUser(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        LuckPerms luckPerms = Rib.Companion.getLUCKPERMS();
        Intrinsics.checkNotNull((Object)luckPerms);
        User user = luckPerms.getPlayerAdapter(class_3222.class).getUser((Object)player);
        Intrinsics.checkNotNullExpressionValue((Object)user, (String)"getUser(...)");
        return user;
    }

    public final boolean hasPermission(@NotNull class_3222 player, @NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        User user = this.getLuckPermsUser(player);
        CachedPermissionData cachedPermissionData = user.getCachedData().getPermissionData();
        Intrinsics.checkNotNullExpressionValue((Object)cachedPermissionData, (String)"getPermissionData(...)");
        CachedPermissionData permissionData = cachedPermissionData;
        return permissionData.checkPermission(permission).asBoolean();
    }

    public final int getMaxIntFromNode(@NotNull class_3222 player, @NotNull String node) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        List<String> ints = this.getLuckPermsUser(player).resolveInheritedNodes(QueryOptions.nonContextual()).stream().filter(arg_0 -> PermissionManager.getMaxIntFromNode$lambda$1(arg_0 -> PermissionManager.getMaxIntFromNode$lambda$0(node, arg_0), arg_0)).map(arg_0 -> PermissionManager.getMaxIntFromNode$lambda$3(arg_0 -> PermissionManager.getMaxIntFromNode$lambda$2(node, arg_0), arg_0)).toList();
        int maxInt = 0;
        for (String string : ints) {
            try {
                Intrinsics.checkNotNull((Object)string);
                int homeCount = Integer.parseInt(string);
                if (homeCount <= maxInt) continue;
                maxInt = homeCount;
            }
            catch (NumberFormatException e) {
                Rib.LOGGER.error("Non integer provided via " + node + "<x> permission node: " + string);
            }
        }
        return maxInt;
    }

    private static final boolean getMaxIntFromNode$lambda$0(String $node, Node n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        String string = n.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        return StringsKt.startsWith$default((String)string, (String)$node, (boolean)false, (int)2, null);
    }

    private static final boolean getMaxIntFromNode$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String getMaxIntFromNode$lambda$2(String $node, Node n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        String string = n.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        String string2 = string;
        int n2 = $node.length();
        String string3 = string2.substring(n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return string3;
    }

    private static final String getMaxIntFromNode$lambda$3(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

