/*
 * Decompiled with CFR 0.152.
 */
package dev.roanoke.rib.utils.cooldown;

import dev.roanoke.rib.Rib;
import dev.roanoke.rib.utils.cooldown.Cooldowns;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.modules.SerializersModule;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u000e\u0018\u0000 ,2\u00020\u0001:\u0001,B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0019\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0011R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR#\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\"\u0010 \u001a\u00020\u001f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\"\u0010&\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u0006-"}, d2={"Ldev/roanoke/rib/utils/cooldown/RibCooldowns;", "Ldev/roanoke/rib/utils/cooldown/Cooldowns;", "Ljava/nio/file/Path;", "COOLDOWNS_FILE_PATH", "", "", "Ljava/time/Instant;", "cooldowns", "<init>", "(Ljava/nio/file/Path;Ljava/util/Map;)V", "", "update", "()V", "save", "id", "", "isOnCooldown", "(Ljava/lang/String;)Z", "Ljava/time/Duration;", "getRemaining", "(Ljava/lang/String;)Ljava/time/Duration;", "time", "setCooldown", "(Ljava/lang/String;Ljava/time/Duration;)V", "clearCooldown", "Ljava/nio/file/Path;", "getCOOLDOWNS_FILE_PATH", "()Ljava/nio/file/Path;", "Ljava/util/Map;", "getCooldowns", "()Ljava/util/Map;", "", "ticks", "I", "getTicks", "()I", "setTicks", "(I)V", "dirty", "Z", "getDirty", "()Z", "setDirty", "(Z)V", "Companion", "Rib"})
@SourceDebugExtension(value={"SMAP\nRibCooldowns.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RibCooldowns.kt\ndev/roanoke/rib/utils/cooldown/RibCooldowns\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,145:1\n538#2:146\n523#2,6:147\n465#2:153\n415#2:154\n1252#3,4:155\n113#4:159\n*S KotlinDebug\n*F\n+ 1 RibCooldowns.kt\ndev/roanoke/rib/utils/cooldown/RibCooldowns\n*L\n94#1:146\n94#1:147,6\n105#1:153\n105#1:154\n105#1:155,4\n111#1:159\n*E\n"})
public final class RibCooldowns
extends Cooldowns {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path COOLDOWNS_FILE_PATH;
    @NotNull
    private final Map<String, Instant> cooldowns;
    private int ticks;
    private boolean dirty;

    public RibCooldowns(@NotNull Path COOLDOWNS_FILE_PATH, @NotNull Map<String, Instant> cooldowns) {
        Intrinsics.checkNotNullParameter((Object)COOLDOWNS_FILE_PATH, (String)"COOLDOWNS_FILE_PATH");
        Intrinsics.checkNotNullParameter(cooldowns, (String)"cooldowns");
        this.COOLDOWNS_FILE_PATH = COOLDOWNS_FILE_PATH;
        this.cooldowns = cooldowns;
        ServerTickEvents.START_SERVER_TICK.register(arg_0 -> RibCooldowns._init_$lambda$0(this, arg_0));
        ServerLifecycleEvents.SERVER_STOPPING.register(arg_0 -> RibCooldowns._init_$lambda$1(this, arg_0));
    }

    public /* synthetic */ RibCooldowns(Path path, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = new LinkedHashMap();
        }
        this(path, map);
    }

    @NotNull
    public final Path getCOOLDOWNS_FILE_PATH() {
        return this.COOLDOWNS_FILE_PATH;
    }

    @NotNull
    public final Map<String, Instant> getCooldowns() {
        return this.cooldowns;
    }

    public final int getTicks() {
        return this.ticks;
    }

    public final void setTicks(int n) {
        this.ticks = n;
    }

    public final boolean getDirty() {
        return this.dirty;
    }

    public final void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public final void update() {
        Instant now = Instant.now();
        Iterator<Map.Entry<String, Instant>> iterator = this.cooldowns.entrySet().iterator();
        boolean modified = false;
        while (iterator.hasNext()) {
            Map.Entry<String, Instant> entry = iterator.next();
            String id = entry.getKey();
            Instant expiry = entry.getValue();
            if (now.isBefore(expiry)) continue;
            iterator.remove();
            modified = true;
        }
        if (modified) {
            this.dirty = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void save() {
        void $this$mapValuesTo$iv$iv;
        void $this$filterTo$iv$iv;
        if (!this.dirty) {
            return;
        }
        this.update();
        if (this.cooldowns.isEmpty()) {
            Files.deleteIfExists(this.COOLDOWNS_FILE_PATH);
            this.dirty = false;
            return;
        }
        Instant now = Instant.now();
        Map<String, Instant> $this$filter$iv = this.cooldowns;
        boolean $i$f$filter = false;
        Map<String, Instant> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(Duration.between(now, (Temporal)it.getValue()).getSeconds() >= 300L)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map toPersist = destination$iv$iv;
        if (toPersist.isEmpty()) {
            Files.deleteIfExists(this.COOLDOWNS_FILE_PATH);
            this.dirty = false;
            return;
        }
        Map $this$mapValues$iv = toPersist;
        boolean $i$f$mapValues = false;
        destination$iv$iv = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            JsonPrimitive jsonPrimitive = JsonElementKt.JsonPrimitive((String)((Instant)it.getValue()).toString());
            map3.put(k, jsonPrimitive);
        }
        Map map4 = destination$iv$iv2;
        JsonObject json = new JsonObject(map4);
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule serializersModule = $this$encodeToString$iv.getSerializersModule();
        KType kType = Reflection.typeOf(JsonObject.class);
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
        Files.writeString(this.COOLDOWNS_FILE_PATH, (CharSequence)$this$encodeToString$iv.encodeToString((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), (Object)json), openOptionArray);
        this.dirty = false;
    }

    @Override
    public boolean isOnCooldown(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.update();
        Instant instant = this.cooldowns.get(id);
        if (instant == null) {
            return false;
        }
        Instant expiry = instant;
        return Instant.now().isBefore(expiry);
    }

    @Override
    @Nullable
    public Duration getRemaining(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.update();
        Instant instant = this.cooldowns.get(id);
        if (instant == null) {
            return null;
        }
        Instant expiry = instant;
        Instant now = Instant.now();
        return now.isBefore(expiry) ? Duration.between(now, expiry) : null;
    }

    @Override
    public void setCooldown(@NotNull String id, @NotNull Duration time) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.cooldowns.put(id, Instant.now().plus(time));
        this.dirty = true;
    }

    @Override
    public boolean clearCooldown(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (this.cooldowns.remove(id) != null) {
            this.dirty = true;
            return true;
        }
        return false;
    }

    private static final void _init_$lambda$0(RibCooldowns this$0, MinecraftServer it) {
        int n = this$0.ticks;
        this$0.ticks = n + 1;
        if (this$0.ticks >= 6000) {
            this$0.ticks = 0;
            this$0.save();
        }
    }

    private static final void _init_$lambda$1(RibCooldowns this$0, MinecraftServer it) {
        this$0.save();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/roanoke/rib/utils/cooldown/RibCooldowns$Companion;", "", "<init>", "()V", "Ljava/nio/file/Path;", "save", "Ldev/roanoke/rib/utils/cooldown/RibCooldowns;", "fromFile", "(Ljava/nio/file/Path;)Ldev/roanoke/rib/utils/cooldown/RibCooldowns;", "Rib"})
    @SourceDebugExtension(value={"SMAP\nRibCooldowns.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RibCooldowns.kt\ndev/roanoke/rib/utils/cooldown/RibCooldowns$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n136#2,9:146\n216#2:155\n217#2:158\n145#2:159\n1#3:156\n1#3:157\n*S KotlinDebug\n*F\n+ 1 RibCooldowns.kt\ndev/roanoke/rib/utils/cooldown/RibCooldowns$Companion\n*L\n33#1:146,9\n33#1:155\n33#1:158\n33#1:159\n33#1:157\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final RibCooldowns fromFile(@NotNull Path save) {
            Intrinsics.checkNotNullParameter((Object)save, (String)"save");
            file = save.toFile();
            if (!file.exists()) {
                return new RibCooldowns(save, null, 2, null);
            }
            try {
                now = Instant.now();
                Intrinsics.checkNotNull((Object)file);
                json = JsonElementKt.getJsonObject((JsonElement)Json.Default.parseToJsonElement(FilesKt.readText$default((File)file, null, (int)1, null)));
                $this$mapNotNull$iv = (Map)json;
                $i$f$mapNotNull = false;
                var8_8 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var13_13 = $this$forEach$iv$iv$iv.entrySet().iterator();
                while (var13_13.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = var13_13.next();
                    $i$a$-forEach-MapsKt___MapsKt$mapNotNullTo$1$iv$iv = false;
                    var17_17 = element$iv$iv;
                    $i$a$-mapNotNull-RibCooldowns$Companion$fromFile$cooldowns$1 = false;
                    id = (String)var17_17.getKey();
                    value = (JsonElement)var17_17.getValue();
                    var21_21 = RibCooldowns.Companion;
                    try {
                        $this$fromFile_u24lambda_u243_u24lambda_u240 = var21_21;
                        $i$a$-runCatching-RibCooldowns$Companion$fromFile$cooldowns$1$1 = false;
                        var22_22 = Result.constructor-impl((Object)Instant.parse(JsonElementKt.getJsonPrimitive((JsonElement)value).getContent()));
                    }
                    catch (Throwable $i$a$-runCatching-RibCooldowns$Companion$fromFile$cooldowns$1$1) {
                        var22_22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-RibCooldowns$Companion$fromFile$cooldowns$1$1));
                    }
                    var21_21 = var22_22;
                    var24_26 = (Instant)(Result.isFailure-impl((Object)var21_21) != false ? null : var21_21);
                    if (var24_26 == null) ** GOTO lbl-1000
                    it = var22_22 = var24_26;
                    $i$a$-takeIf-RibCooldowns$Companion$fromFile$cooldowns$1$2 = false;
                    v0 = var21_21 = it.isAfter(now) != false ? var22_22 : null;
                    if (var21_21 != null) {
                        it = var21_21;
                        $i$a$-let-RibCooldowns$Companion$fromFile$cooldowns$1$3 = false;
                        v1 = TuplesKt.to((Object)id, (Object)it);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = null;
                    }
                    if (v1 == null) continue;
                    it$iv$iv = v1;
                    $i$a$-let-MapsKt___MapsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                cooldowns = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                var3_3 = new RibCooldowns(save, MapsKt.toMutableMap((Map)cooldowns));
            }
            catch (Exception e) {
                Rib.LOGGER.info("Failed to load Rib Cooldowns from path: " + save);
                var3_3 = new RibCooldowns(save, null, 2, null);
            }
            return var3_3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

