/*
 * Decompiled with CFR 0.152.
 */
package dev.roanoke.rib.quests;

import dev.roanoke.rib.Rib;
import dev.roanoke.rib.gui.ButtonElement;
import dev.roanoke.rib.quests.QuestGroup;
import dev.roanoke.rib.quests.QuestLike;
import dev.roanoke.rib.quests.QuestProvider;
import dev.roanoke.rib.rewards.Reward;
import dev.roanoke.rib.rewards.RewardList;
import dev.roanoke.rib.utils.ItemBuilder;
import dev.roanoke.rib.utils.LoreLike;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b!\b&\u0018\u00002\u00020\u00012\u00020\u0002BQ\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\r\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0019\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001a0\u001f\u00a2\u0006\u0004\b \u0010!J\r\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010%\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010'\u001a\u00020\u001aH\u0004\u00a2\u0006\u0004\b'\u0010(J\u000f\u0010)\u001a\u00020\u001aH\u0004\u00a2\u0006\u0004\b)\u0010(J\u000f\u0010*\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b*\u0010$J\u000f\u0010+\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b+\u0010$J\u000f\u0010,\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b,\u0010\u001eJ\u000f\u0010.\u001a\u00020-H&\u00a2\u0006\u0004\b.\u0010/J\u000f\u00100\u001a\u00020-H&\u00a2\u0006\u0004\b0\u0010/J\u000f\u00101\u001a\u00020-H\u0016\u00a2\u0006\u0004\b1\u0010/J\u000f\u00102\u001a\u00020\u0017H&\u00a2\u0006\u0004\b2\u00103J\r\u00104\u001a\u00020\u0017\u00a2\u0006\u0004\b4\u00103J\u0015\u00105\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0017\u00a2\u0006\u0004\b5\u00106J\u0017\u00107\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0017H&\u00a2\u0006\u0004\b7\u00106J\u001b\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020908H&\u00a2\u0006\u0004\b:\u0010;J\u0019\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020908\u00a2\u0006\u0004\b<\u0010;J\r\u0010>\u001a\u00020=\u00a2\u0006\u0004\b>\u0010?R\"\u0010\u0004\u001a\u00020\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010@\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\"\u0010\u0005\u001a\u00020\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010@\u001a\u0004\bE\u0010B\"\u0004\bF\u0010DR\"\u0010\u0006\u001a\u00020\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010@\u001a\u0004\bG\u0010B\"\u0004\bH\u0010DR\"\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010I\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR\"\u0010\n\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010N\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\"\u0010\f\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010S\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR\"\u0010\u000e\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010X\u001a\u0004\bY\u0010\u001e\"\u0004\bZ\u0010[R\"\u0010\u000f\u001a\u00020\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010@\u001a\u0004\b\\\u0010B\"\u0004\b]\u0010D\u00a8\u0006^"}, d2={"Ldev/roanoke/rib/quests/Quest;", "Ldev/roanoke/rib/quests/QuestLike;", "Ldev/roanoke/rib/gui/ButtonElement;", "", "name", "id", "type", "Ldev/roanoke/rib/quests/QuestProvider;", "provider", "Ldev/roanoke/rib/quests/QuestGroup;", "group", "Ldev/roanoke/rib/rewards/RewardList;", "rewards", "", "rewardsClaimed", "requiresPermission", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ldev/roanoke/rib/quests/QuestProvider;Ldev/roanoke/rib/quests/QuestGroup;Ldev/roanoke/rib/rewards/RewardList;ZLjava/lang/String;)V", "Lnet/minecraft/class_3222;", "player", "Leu/pb4/sgui/api/elements/GuiElementBuilder;", "getButton", "(Lnet/minecraft/class_3222;)Leu/pb4/sgui/api/elements/GuiElementBuilder;", "Lcom/google/gson/JsonObject;", "definition", "state", "", "loadDefaultValues", "(Lcom/google/gson/JsonObject;Lcom/google/gson/JsonObject;)V", "completedRequiredPermission", "()Z", "Lkotlin/Function1;", "getButtonCallback", "()Lkotlin/jvm/functions/Function1;", "Ldev/roanoke/rib/utils/LoreLike;", "getButtonLore", "()Ldev/roanoke/rib/utils/LoreLike;", "claimRewards", "(Lnet/minecraft/class_3222;)V", "notifyProgress", "()V", "notifyCompletion", "description", "progress", "isActive", "Lnet/minecraft/class_2561;", "taskMessage", "()Lnet/minecraft/class_2561;", "progressMessage", "taskAndProgress", "getQuestState", "()Lcom/google/gson/JsonObject;", "getState", "applyState", "(Lcom/google/gson/JsonObject;)V", "applyQuestState", "", "Lkotlinx/serialization/json/JsonElement;", "saveSpecifics", "()Ljava/util/Map;", "saveDefaults", "Lkotlinx/serialization/json/JsonObject;", "save", "()Lkotlinx/serialization/json/JsonObject;", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getId", "setId", "getType", "setType", "Ldev/roanoke/rib/quests/QuestProvider;", "getProvider", "()Ldev/roanoke/rib/quests/QuestProvider;", "setProvider", "(Ldev/roanoke/rib/quests/QuestProvider;)V", "Ldev/roanoke/rib/quests/QuestGroup;", "getGroup", "()Ldev/roanoke/rib/quests/QuestGroup;", "setGroup", "(Ldev/roanoke/rib/quests/QuestGroup;)V", "Ldev/roanoke/rib/rewards/RewardList;", "getRewards", "()Ldev/roanoke/rib/rewards/RewardList;", "setRewards", "(Ldev/roanoke/rib/rewards/RewardList;)V", "Z", "getRewardsClaimed", "setRewardsClaimed", "(Z)V", "getRequiresPermission", "setRequiresPermission", "Rib"})
@SourceDebugExtension(value={"SMAP\nQuest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Quest.kt\ndev/roanoke/rib/quests/Quest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,176:1\n1755#2,3:177\n1863#2,2:180\n*S KotlinDebug\n*F\n+ 1 Quest.kt\ndev/roanoke/rib/quests/Quest\n*L\n55#1:177,3\n87#1:180,2\n*E\n"})
public abstract class Quest
implements QuestLike,
ButtonElement {
    @NotNull
    private String name;
    @NotNull
    private String id;
    @NotNull
    private String type;
    @NotNull
    private QuestProvider provider;
    @NotNull
    private QuestGroup group;
    @NotNull
    private RewardList rewards;
    private boolean rewardsClaimed;
    @NotNull
    private String requiresPermission;

    public Quest(@NotNull String name, @NotNull String id, @NotNull String type, @NotNull QuestProvider provider, @NotNull QuestGroup group, @NotNull RewardList rewards, boolean rewardsClaimed, @NotNull String requiresPermission) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)rewards, (String)"rewards");
        Intrinsics.checkNotNullParameter((Object)requiresPermission, (String)"requiresPermission");
        this.name = name;
        this.id = id;
        this.type = type;
        this.provider = provider;
        this.group = group;
        this.rewards = rewards;
        this.rewardsClaimed = rewardsClaimed;
        this.requiresPermission = requiresPermission;
    }

    public /* synthetic */ Quest(String string, String string2, String string3, QuestProvider questProvider, QuestGroup questGroup, RewardList rewardList, boolean bl, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "Default Quest Title";
        }
        if ((n & 2) != 0) {
            string2 = UUID.randomUUID().toString();
        }
        if ((n & 0x20) != 0) {
            rewardList = new RewardList(null, 1, null);
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        if ((n & 0x80) != 0) {
            string4 = "";
        }
        this(string, string2, string3, questProvider, questGroup, rewardList, bl, string4);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final void setId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.id = string;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    public final void setType(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.type = string;
    }

    @NotNull
    public final QuestProvider getProvider() {
        return this.provider;
    }

    public final void setProvider(@NotNull QuestProvider questProvider) {
        Intrinsics.checkNotNullParameter((Object)questProvider, (String)"<set-?>");
        this.provider = questProvider;
    }

    @NotNull
    public final QuestGroup getGroup() {
        return this.group;
    }

    public final void setGroup(@NotNull QuestGroup questGroup) {
        Intrinsics.checkNotNullParameter((Object)questGroup, (String)"<set-?>");
        this.group = questGroup;
    }

    @NotNull
    public final RewardList getRewards() {
        return this.rewards;
    }

    public final void setRewards(@NotNull RewardList rewardList) {
        Intrinsics.checkNotNullParameter((Object)rewardList, (String)"<set-?>");
        this.rewards = rewardList;
    }

    public final boolean getRewardsClaimed() {
        return this.rewardsClaimed;
    }

    public final void setRewardsClaimed(boolean bl) {
        this.rewardsClaimed = bl;
    }

    @NotNull
    public final String getRequiresPermission() {
        return this.requiresPermission;
    }

    public final void setRequiresPermission(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.requiresPermission = string;
    }

    @Override
    @NotNull
    public GuiElementBuilder getButton(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        GuiElementBuilder guiElementBuilder = GuiElementBuilder.from((class_1799)new ItemBuilder(class_1802.field_20391).setCustomName(Rib.Rib.INSTANCE.parseText(this.name)).addLore(this.getButtonLore()).build()).setCallback((arg_0, arg_1, arg_2) -> Quest.getButton$lambda$0(this, player, arg_0, arg_1, arg_2));
        Intrinsics.checkNotNullExpressionValue((Object)guiElementBuilder, (String)"setCallback(...)");
        return guiElementBuilder;
    }

    public final void loadDefaultValues(@NotNull com.google.gson.JsonObject definition, @NotNull com.google.gson.JsonObject state) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        String string = definition.get("name").getAsString();
        if (string == null) {
            string = this.name = "Default Quest Title";
        }
        if ((object = definition.get("id")) == null || (object = object.getAsString()) == null) {
            String string2 = UUID.randomUUID().toString();
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        }
        this.id = object;
        this.rewards = RewardList.Companion.fromJson(definition.get("rewards"));
        com.google.gson.JsonElement jsonElement = state.get("rewardsClaimed");
        this.rewardsClaimed = jsonElement != null ? jsonElement.getAsBoolean() : false;
        Object object2 = definition.get("requiresPermission");
        if (object2 == null || (object2 = object2.getAsString()) == null) {
            object2 = "";
        }
        this.requiresPermission = object2;
    }

    public final boolean completedRequiredPermission() {
        boolean bl;
        block4: {
            if (Intrinsics.areEqual((Object)this.requiresPermission, (Object)"")) {
                return true;
            }
            Iterable $this$any$iv = this.group.getOnlinePlayers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    class_3222 it = (class_3222)element$iv;
                    boolean bl2 = false;
                    if (!Rib.perm.hasPermission(it, this.requiresPermission)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final Function1<class_3222, Unit> getButtonCallback() {
        return arg_0 -> Quest.getButtonCallback$lambda$2(this, arg_0);
    }

    @NotNull
    public final LoreLike getButtonLore() {
        List loreList = new ArrayList();
        class_5250 class_52502 = class_2561.method_43470((String)"");
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
        loreList.add(class_52502);
        loreList.add(this.taskAndProgress());
        class_5250 class_52503 = class_2561.method_43470((String)"");
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"literal(...)");
        loreList.add(class_52503);
        if (!((Collection)this.rewards.getRewards()).isEmpty()) {
            loreList.add(Rib.Rib.INSTANCE.parseText("<gold><bold>Rewards"));
        }
        Iterable $this$forEach$iv = this.rewards.getRewards();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Reward it = (Reward)element$iv;
            boolean bl = false;
            loreList.add(Rib.Rib.INSTANCE.parseText("<white>- " + it.getDisplay()));
        }
        if (this.completed() && !((Collection)this.rewards.getRewards()).isEmpty()) {
            class_5250 class_52504 = class_2561.method_43470((String)"");
            Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"literal(...)");
            loreList.add(class_52504);
            boolean bl = this.rewardsClaimed ? loreList.add(Rib.Rib.INSTANCE.parseText("<white>Rewards have been claimed.")) : loreList.add(Rib.Rib.INSTANCE.parseText("<white>Left click to claim Rewards!"));
        }
        return new LoreLike(loreList);
    }

    public final void claimRewards(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.rewards.executeRewards(player);
        this.rewardsClaimed = true;
        this.provider.onRewardsClaimed(this);
    }

    protected final void notifyProgress() {
        this.provider.onQuestProgress(this);
        if (this.completed()) {
            this.notifyCompletion();
        }
    }

    protected final void notifyCompletion() {
        this.provider.onQuestComplete(this);
    }

    @Override
    @NotNull
    public LoreLike description() {
        return LoreLike.Companion.ofText(this.taskMessage());
    }

    @Override
    @NotNull
    public LoreLike progress() {
        return LoreLike.Companion.ofText(this.progressMessage());
    }

    @Override
    public boolean isActive() {
        return !this.completed() && this.provider.isQuestActive(this);
    }

    @NotNull
    public abstract class_2561 taskMessage();

    @NotNull
    public abstract class_2561 progressMessage();

    @Override
    @NotNull
    public class_2561 taskAndProgress() {
        class_5250 class_52502 = this.taskMessage().method_27661().method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852(this.progressMessage());
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"append(...)");
        return (class_2561)class_52502;
    }

    @NotNull
    public abstract com.google.gson.JsonObject getQuestState();

    @NotNull
    public final com.google.gson.JsonObject getState() {
        com.google.gson.JsonObject jsonObject;
        com.google.gson.JsonObject $this$getState_u24lambda_u244 = jsonObject = this.getQuestState();
        boolean bl = false;
        $this$getState_u24lambda_u244.addProperty("rewardsClaimed", Boolean.valueOf(this.rewardsClaimed));
        return jsonObject;
    }

    public final void applyState(@NotNull com.google.gson.JsonObject state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        com.google.gson.JsonElement jsonElement = state.get("rewardsClaimed");
        this.rewardsClaimed = jsonElement != null ? jsonElement.getAsBoolean() : this.rewardsClaimed;
        this.applyQuestState(state);
    }

    public abstract void applyQuestState(@NotNull com.google.gson.JsonObject var1);

    @NotNull
    public abstract Map<String, JsonElement> saveSpecifics();

    @NotNull
    public final Map<String, JsonElement> saveDefaults() {
        Map defaults = new LinkedHashMap();
        defaults.put("type", JsonElementKt.JsonPrimitive((String)this.type));
        defaults.put("name", JsonElementKt.JsonPrimitive((String)this.name));
        defaults.put("id", JsonElementKt.JsonPrimitive((String)this.id));
        defaults.put("rewards", this.rewards.toJson());
        defaults.put("rewardsClaimed", JsonElementKt.JsonPrimitive((Boolean)this.rewardsClaimed));
        defaults.put("requiresPermission", JsonElementKt.JsonPrimitive((String)this.requiresPermission));
        return defaults;
    }

    @NotNull
    public final JsonObject save() {
        Map<String, JsonElement> defaults = this.saveDefaults();
        Map<String, JsonElement> specifics = this.saveSpecifics();
        defaults.putAll(specifics);
        return new JsonObject(defaults);
    }

    private static final void getButton$lambda$0(Quest this$0, class_3222 $player, int n, ClickType clickType, class_1713 class_17132) {
        this$0.getButtonCallback().invoke((Object)$player);
    }

    private static final Unit getButtonCallback$lambda$2(Quest this$0, class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!((Collection)this$0.rewards.getRewards()).isEmpty()) {
            if (this$0.completed()) {
                if (this$0.rewardsClaimed) {
                    player.method_43496((class_2561)class_2561.method_43470((String)"These rewards have already been claimed!"));
                } else {
                    player.method_43496((class_2561)class_2561.method_43470((String)"Redeemed Quest Rewards"));
                    this$0.claimRewards(player);
                }
            } else {
                player.method_43496((class_2561)class_2561.method_43470((String)"You need to actually finish the Quest before you can have your rewards!"));
            }
        }
        return Unit.INSTANCE;
    }
}

