/*
 * Decompiled with CFR 0.152.
 */
package dev.roanoke.rib.quests.types.cobblemon;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.google.gson.JsonObject;
import dev.roanoke.rib.Rib;
import dev.roanoke.rib.cobblemon.PokeMatch;
import dev.roanoke.rib.quests.Quest;
import dev.roanoke.rib.quests.QuestFactory;
import dev.roanoke.rib.quests.QuestGroup;
import dev.roanoke.rib.quests.QuestProvider;
import dev.roanoke.rib.utils.ItemBuilder;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 22\u00020\u0001:\u00012BS\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u0002\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001b\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00180\u0017H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010\r\u001a\u00020#H\u0016\u00a2\u0006\u0004\b\r\u0010$J\u000f\u0010%\u001a\u00020#H\u0016\u00a2\u0006\u0004\b%\u0010$R\"\u0010\n\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\"\u0010\f\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010+\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\"\u0010\r\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010&\u001a\u0004\b0\u0010(\"\u0004\b1\u0010*\u00a8\u00063"}, d2={"Ldev/roanoke/rib/quests/types/cobblemon/HavePokemonQuest;", "Ldev/roanoke/rib/quests/Quest;", "", "name", "id", "type", "Ldev/roanoke/rib/quests/QuestProvider;", "provider", "Ldev/roanoke/rib/quests/QuestGroup;", "group", "storageType", "Ldev/roanoke/rib/cobblemon/PokeMatch;", "pokeMatch", "taskMessage", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ldev/roanoke/rib/quests/QuestProvider;Ldev/roanoke/rib/quests/QuestGroup;Ljava/lang/String;Ldev/roanoke/rib/cobblemon/PokeMatch;Ljava/lang/String;)V", "Lcom/google/gson/JsonObject;", "getQuestState", "()Lcom/google/gson/JsonObject;", "state", "", "applyQuestState", "(Lcom/google/gson/JsonObject;)V", "", "Lkotlinx/serialization/json/JsonElement;", "saveSpecifics", "()Ljava/util/Map;", "Lnet/minecraft/class_3222;", "player", "Leu/pb4/sgui/api/elements/GuiElementBuilder;", "getButton", "(Lnet/minecraft/class_3222;)Leu/pb4/sgui/api/elements/GuiElementBuilder;", "", "completed", "()Z", "Lnet/minecraft/class_2561;", "()Lnet/minecraft/class_2561;", "progressMessage", "Ljava/lang/String;", "getStorageType", "()Ljava/lang/String;", "setStorageType", "(Ljava/lang/String;)V", "Ldev/roanoke/rib/cobblemon/PokeMatch;", "getPokeMatch", "()Ldev/roanoke/rib/cobblemon/PokeMatch;", "setPokeMatch", "(Ldev/roanoke/rib/cobblemon/PokeMatch;)V", "getTaskMessage", "setTaskMessage", "Companion", "Rib"})
@SourceDebugExtension(value={"SMAP\nHavePokemonQuest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HavePokemonQuest.kt\ndev/roanoke/rib/quests/types/cobblemon/HavePokemonQuest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1755#2,2:95\n1755#2,3:97\n1755#2,3:100\n1757#2:103\n*S KotlinDebug\n*F\n+ 1 HavePokemonQuest.kt\ndev/roanoke/rib/quests/types/cobblemon/HavePokemonQuest\n*L\n77#1:95,2\n79#1:97,3\n81#1:100,3\n77#1:103\n*E\n"})
public final class HavePokemonQuest
extends Quest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String storageType;
    @NotNull
    private PokeMatch pokeMatch;
    @NotNull
    private String taskMessage;

    public HavePokemonQuest(@NotNull String name, @NotNull String id, @NotNull String type, @NotNull QuestProvider provider, @NotNull QuestGroup group, @NotNull String storageType, @NotNull PokeMatch pokeMatch, @NotNull String taskMessage) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)storageType, (String)"storageType");
        Intrinsics.checkNotNullParameter((Object)pokeMatch, (String)"pokeMatch");
        Intrinsics.checkNotNullParameter((Object)taskMessage, (String)"taskMessage");
        super(name, id, type, provider, group, null, false, null, 224, null);
        this.storageType = storageType;
        this.pokeMatch = pokeMatch;
        this.taskMessage = taskMessage;
    }

    public /* synthetic */ HavePokemonQuest(String string, String string2, String string3, QuestProvider questProvider, QuestGroup questGroup, String string4, PokeMatch pokeMatch, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "Default Have Pokemon Quest Title";
        }
        if ((n & 2) != 0) {
            string2 = UUID.randomUUID().toString();
        }
        if ((n & 4) != 0) {
            string3 = "HavePokemonQuest";
        }
        if ((n & 0x20) != 0) {
            string4 = "party";
        }
        if ((n & 0x40) != 0) {
            pokeMatch = new PokeMatch(null, null, null, null, null, null, null, null, null, 511, null);
        }
        if ((n & 0x80) != 0) {
            string5 = "Have a Pokemon in your party!";
        }
        this(string, string2, string3, questProvider, questGroup, string4, pokeMatch, string5);
    }

    @NotNull
    public final String getStorageType() {
        return this.storageType;
    }

    public final void setStorageType(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.storageType = string;
    }

    @NotNull
    public final PokeMatch getPokeMatch() {
        return this.pokeMatch;
    }

    public final void setPokeMatch(@NotNull PokeMatch pokeMatch) {
        Intrinsics.checkNotNullParameter((Object)pokeMatch, (String)"<set-?>");
        this.pokeMatch = pokeMatch;
    }

    @NotNull
    public final String getTaskMessage() {
        return this.taskMessage;
    }

    public final void setTaskMessage(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.taskMessage = string;
    }

    @Override
    @NotNull
    public JsonObject getQuestState() {
        return new JsonObject();
    }

    @Override
    public void applyQuestState(@NotNull JsonObject state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    @Override
    @NotNull
    public Map<String, JsonElement> saveSpecifics() {
        Map specifics = new LinkedHashMap();
        specifics.put("storageType", JsonElementKt.JsonPrimitive((String)this.storageType));
        specifics.put("taskMessage", JsonElementKt.JsonPrimitive((String)this.taskMessage));
        specifics.put("pokeMatch", this.pokeMatch.toJson());
        return specifics;
    }

    @Override
    @NotNull
    public GuiElementBuilder getButton(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        GuiElementBuilder guiElementBuilder = GuiElementBuilder.from((class_1799)new ItemBuilder(this.pokeMatch.getPokemonItem()).setCustomName(Rib.Rib.INSTANCE.parseText(this.getName())).addLore(this.getButtonLore()).build()).setCallback((arg_0, arg_1, arg_2) -> HavePokemonQuest.getButton$lambda$0(this, player, arg_0, arg_1, arg_2));
        Intrinsics.checkNotNullExpressionValue((Object)guiElementBuilder, (String)"setCallback(...)");
        return guiElementBuilder;
    }

    @Override
    public boolean completed() {
        boolean bl;
        Iterable $this$any$iv = this.getGroup().getOnlinePlayers();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            Iterator iterator = $this$any$iv.iterator();
            if (iterator.hasNext()) {
                boolean bl2;
                block11: {
                    Object element$iv = iterator.next();
                    class_3222 player = (class_3222)element$iv;
                    boolean bl3 = false;
                    if (Intrinsics.areEqual((Object)this.storageType, (Object)"pc")) {
                        boolean bl4;
                        block10: {
                            Iterable $this$any$iv2 = (Iterable)PlayerExtensionsKt.pc((class_3222)player);
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl4 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    Pokemon it = (Pokemon)element$iv2;
                                    boolean bl5 = false;
                                    if (!this.pokeMatch.matches(it)) continue;
                                    bl4 = true;
                                    break block10;
                                }
                                bl4 = false;
                            }
                        }
                        return bl4;
                    }
                    Iterable $this$any$iv3 = (Iterable)PlayerExtensionsKt.party((class_3222)player);
                    boolean $i$f$any3 = false;
                    if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv3 : $this$any$iv3) {
                            Pokemon it = (Pokemon)element$iv3;
                            boolean bl6 = false;
                            if (!this.pokeMatch.matches(it)) continue;
                            bl2 = true;
                            break block11;
                        }
                        bl2 = false;
                    }
                }
                return bl2;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public class_2561 taskMessage() {
        return Rib.Rib.INSTANCE.parseText(this.taskMessage);
    }

    @Override
    @NotNull
    public class_2561 progressMessage() {
        return this.completed() ? Rib.Rib.INSTANCE.parseText("<green>\u2714") : Rib.Rib.INSTANCE.parseText("<red>\u2718");
    }

    private static final void getButton$lambda$0(HavePokemonQuest this$0, class_3222 $player, int n, ClickType clickType, class_1713 class_17132) {
        this$0.getButtonCallback().invoke((Object)$player);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/roanoke/rib/quests/types/cobblemon/HavePokemonQuest$Companion;", "Ldev/roanoke/rib/quests/QuestFactory;", "<init>", "()V", "Lcom/google/gson/JsonObject;", "json", "state", "Ldev/roanoke/rib/quests/QuestProvider;", "provider", "Ldev/roanoke/rib/quests/QuestGroup;", "group", "Ldev/roanoke/rib/quests/Quest;", "fromJson", "(Lcom/google/gson/JsonObject;Lcom/google/gson/JsonObject;Ldev/roanoke/rib/quests/QuestProvider;Ldev/roanoke/rib/quests/QuestGroup;)Ldev/roanoke/rib/quests/Quest;", "Rib"})
    public static final class Companion
    implements QuestFactory {
        private Companion() {
        }

        @Override
        @NotNull
        public Quest fromJson(@NotNull JsonObject json, @NotNull JsonObject state, @NotNull QuestProvider provider, @NotNull QuestGroup group) {
            HavePokemonQuest havePokemonQuest;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            com.google.gson.JsonElement jsonElement = json.get("pokeMatch");
            if (jsonElement == null || (jsonElement = jsonElement.getAsJsonObject()) == null) {
                jsonElement = new JsonObject();
            }
            PokeMatch pokeMatch = PokeMatch.Companion.fromJson((JsonObject)jsonElement);
            Object object = json.get("taskMessage");
            if (object == null || (object = object.getAsString()) == null) {
                object = "Have a Pokemon!";
            }
            Object taskMessage = object;
            HavePokemonQuest $this$fromJson_u24lambda_u240 = havePokemonQuest = new HavePokemonQuest(null, null, null, provider, group, null, pokeMatch, (String)taskMessage, 39, null);
            boolean bl = false;
            $this$fromJson_u24lambda_u240.loadDefaultValues(json, state);
            return havePokemonQuest;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

