/*
 * Decompiled with CFR 0.152.
 */
package dev.roanoke.rib.requirements.types;

import dev.roanoke.rib.gui.settings.Setting;
import dev.roanoke.rib.gui.settings.SettingsManager;
import dev.roanoke.rib.gui.settings.types.RequirementsSetting;
import dev.roanoke.rib.gui.settings.types.StringSetting;
import dev.roanoke.rib.requirements.Requirement;
import dev.roanoke.rib.requirements.RequirementFactory;
import dev.roanoke.rib.requirements.RequirementRegistry;
import dev.roanoke.rib.utils.LoreLike;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 #2\u00020\u0001:\u0001#B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0005\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0015J\u001b\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00170\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R(\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\r\"\u0004\b\u001c\u0010\u001dR\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006$"}, d2={"Ldev/roanoke/rib/requirements/types/MultiRequirement;", "Ldev/roanoke/rib/requirements/Requirement;", "", "requirements", "", "prompt", "<init>", "(Ljava/util/List;Ljava/lang/String;)V", "", "registerSettings", "()V", "", "description", "()Ljava/util/List;", "Lnet/minecraft/class_3222;", "player", "", "passesRequirement", "(Lnet/minecraft/class_3222;)Z", "Ldev/roanoke/rib/utils/LoreLike;", "error", "()Ldev/roanoke/rib/utils/LoreLike;", "", "Lkotlinx/serialization/json/JsonElement;", "saveSpecifics", "()Ljava/util/Map;", "Ljava/util/List;", "getRequirements", "setRequirements", "(Ljava/util/List;)V", "Ljava/lang/String;", "getPrompt", "()Ljava/lang/String;", "setPrompt", "(Ljava/lang/String;)V", "Companion", "Rib"})
@SourceDebugExtension(value={"SMAP\nMultiRequirement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiRequirement.kt\ndev/roanoke/rib/requirements/types/MultiRequirement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1734#2,3:69\n1557#2:72\n1628#2,3:73\n*S KotlinDebug\n*F\n+ 1 MultiRequirement.kt\ndev/roanoke/rib/requirements/types/MultiRequirement\n*L\n51#1:69,3\n64#1:72\n64#1:73,3\n*E\n"})
public final class MultiRequirement
extends Requirement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<Requirement> requirements;
    @NotNull
    private String prompt;

    public MultiRequirement(@NotNull List<Requirement> requirements, @NotNull String prompt) {
        Intrinsics.checkNotNullParameter(requirements, (String)"requirements");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        super("MultiRequirement", null, 2, null);
        this.requirements = requirements;
        this.prompt = prompt;
        this.registerSettings();
    }

    @NotNull
    public final List<Requirement> getRequirements() {
        return this.requirements;
    }

    public final void setRequirements(@NotNull List<Requirement> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.requirements = list;
    }

    @NotNull
    public final String getPrompt() {
        return this.prompt;
    }

    public final void setPrompt(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.prompt = string;
    }

    @Override
    public void registerSettings() {
        this.setSettings(new SettingsManager(this));
        Setting[] settingArray = new Setting[]{new StringSetting("Prompt", (Function0<String>)((Function0)() -> MultiRequirement.registerSettings$lambda$0(this)), (Function1<? super String, Unit>)((Function1)arg_0 -> MultiRequirement.registerSettings$lambda$1(this, arg_0))), new RequirementsSetting("Requirements", (Function0<? extends List<Requirement>>)((Function0)() -> MultiRequirement.registerSettings$lambda$2(this)), (Function1<? super List<Requirement>, Unit>)((Function1)arg_0 -> MultiRequirement.registerSettings$lambda$3(this, arg_0)))};
        this.getSettings().addSettings(settingArray);
    }

    @Override
    @NotNull
    public List<String> description() {
        Object[] objectArray = new String[]{"This Requirement can hold multiple requirements, and can be used to setup", "multi-requirement things, such as rulesets for a battle", "", "<red>This can currently not be managed through the GUI."};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public boolean passesRequirement(@NotNull class_3222 player) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Iterable $this$all$iv = this.requirements;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Requirement it = (Requirement)element$iv;
                    boolean bl2 = false;
                    if (it.passesRequirement(player)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public LoreLike error() {
        return LoreLike.Companion.ofString("<red>" + this.prompt);
    }

    @Override
    @NotNull
    public LoreLike prompt() {
        return LoreLike.Companion.ofString(this.prompt);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, JsonElement> saveSpecifics() {
        Collection<JsonObject> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair[] pairArray = new Pair[2];
        Iterable iterable = this.requirements;
        String string = "requirements";
        int n = 0;
        Pair[] pairArray2 = pairArray;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Requirement requirement = (Requirement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toKson());
        }
        Collection<JsonObject> collection2 = collection = (List)destination$iv$iv;
        pairArray2[n] = TuplesKt.to((Object)string, (Object)new JsonArray((List)collection2));
        pairArray[1] = TuplesKt.to((Object)"prompt", (Object)JsonElementKt.JsonPrimitive((String)this.prompt));
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    private static final String registerSettings$lambda$0(MultiRequirement this$0) {
        return this$0.prompt;
    }

    private static final Unit registerSettings$lambda$1(MultiRequirement this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.prompt = it;
        return Unit.INSTANCE;
    }

    private static final List registerSettings$lambda$2(MultiRequirement this$0) {
        return this$0.requirements;
    }

    private static final Unit registerSettings$lambda$3(MultiRequirement this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.requirements = it;
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/roanoke/rib/requirements/types/MultiRequirement$Companion;", "Ldev/roanoke/rib/requirements/RequirementFactory;", "<init>", "()V", "Lkotlinx/serialization/json/JsonObject;", "json", "Ldev/roanoke/rib/requirements/Requirement;", "fromKson", "(Lkotlinx/serialization/json/JsonObject;)Ldev/roanoke/rib/requirements/Requirement;", "Rib"})
    @SourceDebugExtension(value={"SMAP\nMultiRequirement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiRequirement.kt\ndev/roanoke/rib/requirements/types/MultiRequirement$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1557#2:69\n1628#2,3:70\n*S KotlinDebug\n*F\n+ 1 MultiRequirement.kt\ndev/roanoke/rib/requirements/types/MultiRequirement$Companion\n*L\n22#1:69\n22#1:70,3\n*E\n"})
    public static final class Companion
    implements RequirementFactory {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Requirement fromKson(@NotNull JsonObject json) {
            Object object;
            Object object2;
            block6: {
                block5: {
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                    object2 = (JsonElement)json.get((Object)"requirements");
                    if (object2 == null || (object2 = JsonElementKt.getJsonArray((JsonElement)object2)) == null) break block5;
                    Iterable $this$map$iv = (Iterable)object2;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        JsonElement jsonElement = (JsonElement)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(RequirementRegistry.INSTANCE.getRequirement(JsonElementKt.getJsonObject((JsonElement)it)));
                    }
                    object2 = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                    if (object2 != null) break block6;
                }
                object2 = new ArrayList();
            }
            if ((object = (JsonElement)json.get((Object)"prompt")) == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = JsonElementKt.getContentOrNull((JsonPrimitive)object)) == null) {
                object = "";
            }
            Object object3 = object;
            Object object4 = object2;
            return new MultiRequirement((List<Requirement>)object4, (String)object3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

