/*
 * Decompiled with CFR 0.152.
 */
package dev.roanoke.rib.requirements.types;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import dev.roanoke.rib.gui.settings.Setting;
import dev.roanoke.rib.gui.settings.SettingsManager;
import dev.roanoke.rib.gui.settings.types.IntegerComparisonSetting;
import dev.roanoke.rib.gui.settings.types.IntegerSetting;
import dev.roanoke.rib.requirements.Requirement;
import dev.roanoke.rib.requirements.RequirementFactory;
import dev.roanoke.rib.requirements.types.IntegerComparison;
import dev.roanoke.rib.utils.LoreLike;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 (2\u00020\u0001:\u0001(B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\f\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u001b\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010#\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006)"}, d2={"Ldev/roanoke/rib/requirements/types/TeamLevelRequirement;", "Ldev/roanoke/rib/requirements/Requirement;", "", "level", "Ldev/roanoke/rib/requirements/types/IntegerComparison;", "comparison", "<init>", "(ILdev/roanoke/rib/requirements/types/IntegerComparison;)V", "", "registerSettings", "()V", "", "", "description", "()Ljava/util/List;", "Lnet/minecraft/class_3222;", "player", "", "passesRequirement", "(Lnet/minecraft/class_3222;)Z", "comparisonDescriber", "()Ljava/lang/String;", "Ldev/roanoke/rib/utils/LoreLike;", "error", "()Ldev/roanoke/rib/utils/LoreLike;", "prompt", "", "Lkotlinx/serialization/json/JsonElement;", "saveSpecifics", "()Ljava/util/Map;", "I", "getLevel", "()I", "setLevel", "(I)V", "Ldev/roanoke/rib/requirements/types/IntegerComparison;", "getComparison", "()Ldev/roanoke/rib/requirements/types/IntegerComparison;", "setComparison", "(Ldev/roanoke/rib/requirements/types/IntegerComparison;)V", "Companion", "Rib"})
@SourceDebugExtension(value={"SMAP\nTeamLevelRequirement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamLevelRequirement.kt\ndev/roanoke/rib/requirements/types/TeamLevelRequirement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1863#2,2:124\n1863#2,2:126\n1863#2,2:128\n*S KotlinDebug\n*F\n+ 1 TeamLevelRequirement.kt\ndev/roanoke/rib/requirements/types/TeamLevelRequirement\n*L\n72#1:124,2\n79#1:126,2\n86#1:128,2\n*E\n"})
public final class TeamLevelRequirement
extends Requirement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int level;
    @NotNull
    private IntegerComparison comparison;

    public TeamLevelRequirement(int level, @NotNull IntegerComparison comparison) {
        Intrinsics.checkNotNullParameter((Object)((Object)comparison), (String)"comparison");
        super("TeamLevelRequirement", "Team Level Requirement");
        this.level = level;
        this.comparison = comparison;
        this.registerSettings();
    }

    public final int getLevel() {
        return this.level;
    }

    public final void setLevel(int n) {
        this.level = n;
    }

    @NotNull
    public final IntegerComparison getComparison() {
        return this.comparison;
    }

    public final void setComparison(@NotNull IntegerComparison integerComparison) {
        Intrinsics.checkNotNullParameter((Object)((Object)integerComparison), (String)"<set-?>");
        this.comparison = integerComparison;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void registerSettings() {
        void it;
        IntegerComparisonSetting integerComparisonSetting;
        this.setSettings(new SettingsManager(this));
        Setting[] settingArray = new Setting[2];
        settingArray[0] = new IntegerSetting("Level", (Function0<Integer>)((Function0)() -> TeamLevelRequirement.registerSettings$lambda$0(this)), (Function1<? super Integer, Unit>)((Function1)arg_0 -> TeamLevelRequirement.registerSettings$lambda$1(this, arg_0)));
        IntegerComparisonSetting integerComparisonSetting2 = integerComparisonSetting = new IntegerComparisonSetting("<green>Comparison Type", (Function0<? extends IntegerComparison>)((Function0)() -> TeamLevelRequirement.registerSettings$lambda$2(this)), (Function1<? super IntegerComparison, Unit>)((Function1)arg_0 -> TeamLevelRequirement.registerSettings$lambda$3(this, arg_0)));
        int n = 1;
        Setting[] settingArray2 = settingArray;
        SettingsManager settingsManager = this.getSettings();
        boolean bl = false;
        it.setDescription("\n<gray>The type of comparison that should be applied using the level defined\n<gray>I.e., MINIMUM means the player's party must be AT LEAST the level set (" + this.level + ")\n");
        Unit unit = Unit.INSTANCE;
        settingArray2[n] = integerComparisonSetting;
        settingsManager.addSettings(settingArray);
    }

    @Override
    @NotNull
    public List<String> description() {
        Object[] objectArray = new String[]{"A requirement that sets the team level a player's party must match to pass", "You can change the <green>Comparison Type<reset>, i.e. MINIMUM, MAXIMUM, EXACT", "Set two Team Level Requirements (one minimum, one maximum) to require Pokemon to", "be within a range (i.e. 5 -> 10)"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public boolean passesRequirement(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (CollectionsKt.count((Iterable)((Iterable)PlayerExtensionsKt.party((class_3222)player))) == 0) {
            return false;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.comparison.ordinal()]) {
            case 1: {
                Iterable $this$forEach$iv = (Iterable)PlayerExtensionsKt.party((class_3222)player);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pokemon it = (Pokemon)element$iv;
                    boolean bl = false;
                    if (it.getLevel() >= this.level) continue;
                    return false;
                }
                break;
            }
            case 2: {
                Iterable $this$forEach$iv = (Iterable)PlayerExtensionsKt.party((class_3222)player);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pokemon it = (Pokemon)element$iv;
                    boolean bl = false;
                    if (it.getLevel() == this.level) continue;
                    return false;
                }
                break;
            }
            case 3: {
                Iterable $this$forEach$iv = (Iterable)PlayerExtensionsKt.party((class_3222)player);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pokemon it = (Pokemon)element$iv;
                    boolean bl = false;
                    if (it.getLevel() <= this.level) continue;
                    return false;
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return true;
    }

    @NotNull
    public final String comparisonDescriber() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.comparison.ordinal()]) {
            case 1 -> "at least ";
            case 2 -> "";
            case 3 -> "lower than ";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @NotNull
    public LoreLike error() {
        return LoreLike.Companion.ofString("<red>Your Pokemon must all be " + this.comparisonDescriber() + "level " + this.level + "!");
    }

    @Override
    @NotNull
    public LoreLike prompt() {
        return LoreLike.Companion.ofString("<green>Your Pokemon must all be " + this.comparisonDescriber() + "level " + this.level + "!");
    }

    @Override
    @NotNull
    public Map<String, JsonElement> saveSpecifics() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"level", (Object)JsonElementKt.JsonPrimitive((Number)this.level)), TuplesKt.to((Object)"comparison", (Object)JsonElementKt.JsonPrimitive((String)this.comparison.name()))};
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    private static final int registerSettings$lambda$0(TeamLevelRequirement this$0) {
        return this$0.level;
    }

    private static final Unit registerSettings$lambda$1(TeamLevelRequirement this$0, int it) {
        this$0.level = it;
        return Unit.INSTANCE;
    }

    private static final IntegerComparison registerSettings$lambda$2(TeamLevelRequirement this$0) {
        return this$0.comparison;
    }

    private static final Unit registerSettings$lambda$3(TeamLevelRequirement this$0, IntegerComparison it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        this$0.comparison = it;
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/roanoke/rib/requirements/types/TeamLevelRequirement$Companion;", "Ldev/roanoke/rib/requirements/RequirementFactory;", "<init>", "()V", "Lkotlinx/serialization/json/JsonObject;", "json", "Ldev/roanoke/rib/requirements/Requirement;", "fromKson", "(Lkotlinx/serialization/json/JsonObject;)Ldev/roanoke/rib/requirements/Requirement;", "Rib"})
    public static final class Companion
    implements RequirementFactory {
        private Companion() {
        }

        @Override
        @NotNull
        public Requirement fromKson(@NotNull JsonObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Object object = (JsonElement)json.get((Object)"level");
            int n = object != null && (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) != null && (object = JsonElementKt.getIntOrNull((JsonPrimitive)object)) != null ? (Integer)object : 0;
            Object object2 = (JsonElement)json.get((Object)"comparison");
            if (object2 == null || (object2 = JsonElementKt.getJsonPrimitive((JsonElement)object2)) == null || (object2 = JsonElementKt.getContentOrNull((JsonPrimitive)object2)) == null) {
                object2 = "";
            }
            String string = ((String)object2).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            return new TeamLevelRequirement(n, switch (string) {
                case "MINIMUM" -> IntegerComparison.MINIMUM;
                case "EXACT" -> IntegerComparison.EXACT;
                case "MAXIMUM" -> IntegerComparison.MAXIMUM;
                default -> IntegerComparison.MINIMUM;
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IntegerComparison.values().length];
            try {
                nArray[IntegerComparison.MINIMUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntegerComparison.EXACT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntegerComparison.MAXIMUM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

