/*
 * Decompiled with CFR 0.152.
 */
package dev.roanoke.rib.utils;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ldev/roanoke/rib/utils/FileUtils;", "", "<init>", "()V", "", "resourcePath", "Ljava/nio/file/Path;", "outputPath", "", "overwrite", "", "copyResourceToFile", "(Ljava/lang/String;Ljava/nio/file/Path;Z)V", "Rib"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();

    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copyResourceToFile(@NotNull String resourcePath, @NotNull Path outputPath, boolean overwrite) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        if (!Files.exists(outputPath, new LinkOption[0]) || overwrite) {
            InputStream inputStream = FileUtils.class.getResourceAsStream(resourcePath);
            if (inputStream != null) {
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    InputStream inputStream2 = (InputStream)closeable;
                    boolean bl = false;
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    long l = Files.copy(inputStream2, outputPath, copyOptionArray);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                throw new IllegalArgumentException("Resource not found: " + resourcePath);
            }
        }
    }

    public static /* synthetic */ void copyResourceToFile$default(FileUtils fileUtils, String string, Path path, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        fileUtils.copyResourceToFile(string, path, bl);
    }
}

