/*
 * Decompiled with CFR 0.152.
 */
package dev.roanoke.rib.utils;

import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Ldev/roanoke/rib/utils/FormattingUtils;", "", "<init>", "()V", "Companion", "Rib"})
public final class FormattingUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Ldev/roanoke/rib/utils/FormattingUtils$Companion;", "", "<init>", "()V", "Ljava/time/Instant;", "instant", "", "formatDate", "(Ljava/time/Instant;)Ljava/lang/String;", "start", "end", "formatTimeDifference", "(Ljava/time/Instant;Ljava/time/Instant;)Ljava/lang/String;", "Ljava/time/Duration;", "duration", "formatDuration", "(Ljava/time/Duration;)Ljava/lang/String;", "input", "parseDuration", "(Ljava/lang/String;)Ljava/time/Duration;", "", "ticks", "durationFromTicks", "(J)Ljava/time/Duration;", "", "number", "getOrdinal", "(I)Ljava/lang/String;", "Rib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String formatDate(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("d'th' MMMM yyyy").withLocale(Locale.ENGLISH).withZone(ZoneId.systemDefault());
            String string = formatter.format(instant);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        @NotNull
        public final String formatTimeDifference(@NotNull Instant start, @NotNull Instant end) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            Duration duration = Duration.between(start, end);
            Period period = Period.between(start.atZone(ZoneId.systemDefault()).toLocalDate(), end.atZone(ZoneId.systemDefault()).toLocalDate());
            return period.getYears() > 0 ? period.getYears() + " years ago" : (period.getMonths() > 0 ? period.getMonths() + " months ago" : (period.getDays() > 0 ? period.getDays() + " days ago" : (duration.toHours() > 0L ? duration.toHours() + " hours ago" : (duration.toMinutes() > 0L ? duration.toMinutes() + " minutes ago" : "Just now"))));
        }

        @NotNull
        public final String formatDuration(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
            long hours = duration.toHours();
            long minutes = duration.toMinutes() % (long)60;
            long seconds = duration.getSeconds() % (long)60;
            String string = "%02d:%02d:%02d";
            Object[] objectArray = new Object[]{hours, minutes, seconds};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }

        @NotNull
        public final Duration parseDuration(@NotNull String input) {
            block16: {
                Duration duration;
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Regex pattern = new Regex("(\\d+)([smhd])");
                MatchResult matchResult = pattern.matchEntire((CharSequence)input);
                if (matchResult == null) break block16;
                MatchResult.Destructured destructured = matchResult.getDestructured();
                String amount = (String)destructured.getMatch().getGroupValues().get(1);
                String unit = (String)destructured.getMatch().getGroupValues().get(2);
                long amountLong = Long.parseLong(amount);
                switch (unit) {
                    case "s": {
                        Duration duration2 = Duration.ofSeconds(amountLong);
                        duration = duration2;
                        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
                        break;
                    }
                    case "m": {
                        Duration duration3 = Duration.ofMinutes(amountLong);
                        duration = duration3;
                        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofMinutes(...)");
                        break;
                    }
                    case "h": {
                        Duration duration4 = Duration.ofHours(amountLong);
                        duration = duration4;
                        Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofHours(...)");
                        break;
                    }
                    case "d": {
                        Duration duration5 = Duration.ofDays(amountLong);
                        duration = duration5;
                        Intrinsics.checkNotNullExpressionValue((Object)duration5, (String)"ofDays(...)");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown time unit: " + unit);
                    }
                }
                return duration;
            }
            throw new IllegalArgumentException("Invalid duration format: " + input);
        }

        @NotNull
        public final Duration durationFromTicks(long ticks) {
            Duration duration = Duration.ofSeconds(ticks / (long)20);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
            return duration;
        }

        @NotNull
        public final String getOrdinal(int number) {
            int n = number % 100;
            String suffix = (11 <= n ? n < 14 : false) ? "th" : (number % 10 == 1 ? "st" : (number % 10 == 2 ? "nd" : (number % 10 == 3 ? "rd" : "th")));
            return number + suffix;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

