/*
 * Decompiled with CFR 0.152.
 */
package dev.roanoke.rib.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.roanoke.rib.Rib;
import dev.roanoke.rib.utils.ItemBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010%\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0015\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0016\u0010\u0017R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\"\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Ldev/roanoke/rib/utils/ItemManager;", "", "Ljava/nio/file/Path;", "itemsConfigPath", "", "defaultItemsConfigPath", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "", "reload", "()V", "setup", "Ljava/io/File;", "file", "importItemsFromJar", "(Ljava/io/File;)V", "loadItems", "name", "Lnet/minecraft/class_1799;", "getItemStack", "(Ljava/lang/String;)Lnet/minecraft/class_1799;", "Ldev/roanoke/rib/utils/ItemBuilder;", "getItemBuilder", "(Ljava/lang/String;)Ldev/roanoke/rib/utils/ItemBuilder;", "Ljava/nio/file/Path;", "getItemsConfigPath", "()Ljava/nio/file/Path;", "setItemsConfigPath", "(Ljava/nio/file/Path;)V", "Ljava/lang/String;", "getDefaultItemsConfigPath", "()Ljava/lang/String;", "setDefaultItemsConfigPath", "(Ljava/lang/String;)V", "", "items", "Ljava/util/Map;", "Rib"})
@SourceDebugExtension(value={"SMAP\nItemManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemManager.kt\ndev/roanoke/rib/utils/ItemManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1863#2,2:77\n*S KotlinDebug\n*F\n+ 1 ItemManager.kt\ndev/roanoke/rib/utils/ItemManager\n*L\n52#1:77,2\n*E\n"})
public final class ItemManager {
    @NotNull
    private Path itemsConfigPath;
    @NotNull
    private String defaultItemsConfigPath;
    @NotNull
    private Map<String, ItemBuilder> items;

    public ItemManager(@NotNull Path itemsConfigPath, @NotNull String defaultItemsConfigPath) {
        Intrinsics.checkNotNullParameter((Object)itemsConfigPath, (String)"itemsConfigPath");
        Intrinsics.checkNotNullParameter((Object)defaultItemsConfigPath, (String)"defaultItemsConfigPath");
        this.itemsConfigPath = itemsConfigPath;
        this.defaultItemsConfigPath = defaultItemsConfigPath;
        this.items = new LinkedHashMap();
    }

    @NotNull
    public final Path getItemsConfigPath() {
        return this.itemsConfigPath;
    }

    public final void setItemsConfigPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.itemsConfigPath = path;
    }

    @NotNull
    public final String getDefaultItemsConfigPath() {
        return this.defaultItemsConfigPath;
    }

    public final void setDefaultItemsConfigPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.defaultItemsConfigPath = string;
    }

    public final void reload() {
        this.items.clear();
        this.setup();
    }

    public final void setup() {
        boolean file_exists;
        boolean bl = file_exists = !this.itemsConfigPath.toFile().createNewFile();
        if (file_exists) {
            File file = this.itemsConfigPath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            this.loadItems(file);
        } else {
            File file = this.itemsConfigPath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            this.importItemsFromJar(file);
            File file2 = this.itemsConfigPath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
            this.loadItems(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void importItemsFromJar(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        InputStream inputStream = this.getClass().getResourceAsStream(this.defaultItemsConfigPath);
        if (inputStream == null) {
            throw new RuntimeException("Failed to find " + this.defaultItemsConfigPath + " inside the jar.");
        }
        InputStream inputStream2 = inputStream;
        try {
            Closeable closeable = inputStream2;
            Throwable throwable = null;
            try {
                long l;
                InputStream input = (InputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new FileOutputStream(file);
                Throwable throwable2 = null;
                try {
                    FileOutputStream output = (FileOutputStream)closeable2;
                    boolean bl2 = false;
                    l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            Rib.LOGGER.error("Failed to copy items.json from jar to config folder: ", (Throwable)e);
        }
    }

    public final void loadItems(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        JsonObject jsonObject = JsonParser.parseReader((Reader)new FileReader(file)).getAsJsonObject();
        Set set = jsonObject.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            String itemName = (String)entry.getKey();
            JsonObject itemData = ((JsonElement)entry.getValue()).getAsJsonObject();
            ItemBuilder itemBuilder = ItemBuilder.fromJson(itemData);
            if (itemBuilder == null) {
                Rib.LOGGER.info("Failed to load Item from Config: " + itemName);
                continue;
            }
            Rib.LOGGER.info("Loaded Item from Config: " + itemName);
            this.items.put(itemName, itemBuilder);
        }
    }

    @NotNull
    public final class_1799 getItemStack(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        class_1799 class_17992 = this.items.getOrDefault(name, new ItemBuilder("minecraft:gold_block")).build();
        Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"build(...)");
        return class_17992;
    }

    @NotNull
    public final ItemBuilder getItemBuilder(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.items.getOrDefault(name, new ItemBuilder("minecraft:gold_block"));
    }
}

