/*
 * Decompiled with CFR 0.152.
 */
package dev.roanoke.rib.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import dev.roanoke.rib.Rib;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class Messages {
    private HashMap<String, String> messages = new HashMap();
    private String prefix = "";

    public Messages(Path filePath, String bundledFilePath) {
        try {
            block34: {
                HashMap bundledMessages;
                Reader reader;
                Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
                try {
                    reader = new InputStreamReader(this.getClass().getResourceAsStream(bundledFilePath), StandardCharsets.UTF_8);
                    try {
                        bundledMessages = (HashMap)gson.fromJson(reader, new TypeToken<HashMap<String, String>>(this){}.getType());
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load bundled messages.json", e);
                }
                if (!Files.exists(filePath, new LinkOption[0])) {
                    Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                    this.messages = bundledMessages;
                    try (BufferedWriter writer = Files.newBufferedWriter(filePath, StandardCharsets.UTF_8, new OpenOption[0]);){
                        gson.toJson((Object)bundledMessages, (Appendable)writer);
                        break block34;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    reader = Files.newBufferedReader(filePath, StandardCharsets.UTF_8);
                    try {
                        this.messages = (HashMap)gson.fromJson(reader, new TypeToken<HashMap<String, String>>(this){}.getType());
                        boolean hasChanges = false;
                        for (String key : bundledMessages.keySet()) {
                            if (this.messages.containsKey(key)) continue;
                            this.messages.put(key, (String)bundledMessages.get(key));
                            hasChanges = true;
                        }
                        if (!hasChanges) break block34;
                        try (BufferedWriter writer = Files.newBufferedWriter(filePath, StandardCharsets.UTF_8, new OpenOption[0]);){
                            gson.toJson(this.messages, (Appendable)writer);
                        }
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                catch (IOException e) {
                    Rib.LOGGER.info("Failed to load or merge messages.json", (Throwable)e);
                    this.messages = new HashMap();
                }
            }
            this.prefix = this.getMessage("prefix");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create directories for path " + String.valueOf(filePath), e);
        }
    }

    public String getMessage(String key) {
        if (this.messages == null) {
            this.messages = new HashMap();
        }
        String message = this.messages.getOrDefault(key, key);
        message = message.replace("{prefix}", this.prefix == null ? "" : this.prefix);
        return message;
    }

    public String getMessage(String key, Map<String, String> placeholders) {
        String message = this.getMessage(key);
        for (String pKey : placeholders.keySet()) {
            message = message.replace(pKey, placeholders.get(pKey));
        }
        return message;
    }

    public class_2561 getDisplayMessage(String key) {
        return this.getDisplayText(this.getMessage(key));
    }

    public class_2561 getDisplayMessage(String key, Map<String, String> placeholders) {
        return this.getDisplayText(this.getMessage(key, placeholders));
    }

    public void send(class_3222 player, String key, Map<String, String> placeholders) {
        player.method_43496(this.getDisplayText(this.getMessage(key, placeholders)));
    }

    public void send(class_3222 player, String key) {
        player.method_43496(this.getDisplayText(this.getMessage(key)));
    }

    public void send(UUID player, String key, Map<String, String> placeholders) {
        Rib.MESSENGER.send(player, this.getMessage(key, placeholders));
    }

    public void send(UUID player, String key) {
        Rib.MESSENGER.send(player, this.getMessage(key));
    }

    public class_2561 getDisplayText(String message) {
        if (Rib.adventure != null) {
            return Rib.adventure.toNative(MiniMessage.miniMessage().deserialize((Object)message));
        }
        return class_2561.method_43470((String)"Error converting MiniMessage format");
    }
}

