/*
 * Decompiled with CFR 0.152.
 */
package dev.roanoke.rib.utils;

import dev.roanoke.rib.utils.ItemBuilder;
import dev.roanoke.rib.utils.SlotRange;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1802;
import net.minecraft.class_2561;

public class PaginatedSection {
    List<GuiElementBuilder> guiElements;
    GuiElementBuilder fillItem = new ItemBuilder(class_1802.field_8871).setCustomName((class_2561)class_2561.method_43470((String)"")).gbuild();
    List<SlotRange> slotRanges = Collections.emptyList();
    int currentPage = 1;

    public PaginatedSection(List<GuiElementBuilder> guiElements) {
        this.guiElements = guiElements;
    }

    public PaginatedSection setSlotRanges(List<SlotRange> slotRanges) {
        this.slotRanges = slotRanges;
        return this;
    }

    public PaginatedSection setFillItem(GuiElementBuilder fillItem) {
        this.fillItem = fillItem;
        return this;
    }

    public int getItemsPerPage() {
        int itemsPerPage = 0;
        for (SlotRange range : this.slotRanges) {
            itemsPerPage += range.getEnd() - range.getStart() + 1;
        }
        return itemsPerPage;
    }

    public void applyToGui(SimpleGui gui2) {
        int itemsPerPage = this.getItemsPerPage();
        int startingIndex = (this.currentPage - 1) * itemsPerPage;
        for (SlotRange range : this.slotRanges) {
            for (int slot = range.getStart(); slot <= range.getEnd(); ++slot) {
                if (startingIndex < this.guiElements.size()) {
                    gui2.setSlot(slot, (GuiElementBuilderInterface)this.guiElements.get(startingIndex));
                } else {
                    gui2.setSlot(slot, (GuiElementBuilderInterface)this.fillItem);
                }
                ++startingIndex;
            }
        }
    }

    public void setGuiElements(List<GuiElementBuilder> guiElements) {
        this.guiElements = guiElements;
        this.currentPage = 1;
    }

    public void incremementPage() {
        int totalPages = (int)Math.ceil((double)this.guiElements.size() / (double)this.getItemsPerPage());
        ++this.currentPage;
        if (this.currentPage > totalPages) {
            --this.currentPage;
        }
    }

    public void decrementPage() {
        --this.currentPage;
        if (this.currentPage < 1) {
            this.currentPage = 1;
        }
    }
}

