/*
 * Decompiled with CFR 0.152.
 */
package tronka.justsync.chat;

import dcshadow.club.minnced.discord.webhook.external.JDAWebhookClient;
import dcshadow.club.minnced.discord.webhook.receive.ReadonlyMessage;
import dcshadow.club.minnced.discord.webhook.send.WebhookMessage;
import dcshadow.club.minnced.discord.webhook.send.WebhookMessageBuilder;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.minecraft.class_3222;
import tronka.justsync.Utils;
import tronka.justsync.config.Config;

public class DiscordChatMessageSender {
    private final String message;
    private final class_3222 sender;
    private final JDAWebhookClient webhookClient;
    private final TextChannel channel;
    private final Config config;
    private long messageId;
    private long lastMessageEdit;
    private int repetitionCount;
    private int lastUpdatedCount;
    private CompletableFuture<Void> readyFuture;

    public DiscordChatMessageSender(JDAWebhookClient webhookClient, TextChannel channel, Config config, String message, class_3222 sender) {
        this.webhookClient = webhookClient;
        this.channel = channel;
        this.config = config;
        this.message = message;
        this.sender = sender;
        this.repetitionCount = 0;
    }

    public boolean hasChanged(String message, class_3222 sender) {
        return this.sender != sender || !message.equals(this.message);
    }

    public void sendMessage() {
        ++this.repetitionCount;
        if (this.config.stackMessages && this.repetitionCount >= 2 && this.canUpdateMessage()) {
            this.updateMessage(this.messageId);
            return;
        }
        this.sendMessageToDiscord();
        this.lastMessageEdit = System.currentTimeMillis();
        this.repetitionCount = 1;
        this.lastUpdatedCount = 1;
    }

    public void onMessageDelete(long messageId) {
        if (this.messageId == messageId) {
            this.messageId = 0L;
            this.repetitionCount = 0;
        }
    }

    private boolean canUpdateMessage() {
        return this.readyFuture == null || !this.readyFuture.isDone() || this.channel.getLatestMessageIdLong() == this.messageId && this.lastMessageEdit + (long)this.config.stackMessagesTimeoutInSec * 1000L > System.currentTimeMillis();
    }

    private void updateMessage(long messageId) {
        this.messageId = messageId;
        if (this.readyFuture != null && !this.readyFuture.isDone()) {
            return;
        }
        if (this.lastUpdatedCount == this.repetitionCount) {
            return;
        }
        if (this.lastMessageEdit + 1000L > System.currentTimeMillis()) {
            if (this.readyFuture == null || this.readyFuture.isDone()) {
                this.readyFuture = CompletableFuture.runAsync(() -> this.updateMessage(messageId), CompletableFuture.delayedExecutor(System.currentTimeMillis() - this.lastMessageEdit + 1L, TimeUnit.MILLISECONDS));
            }
            return;
        }
        if (this.channel.getLatestMessageIdLong() != this.messageId) {
            this.repetitionCount = 0;
            this.sendMessage();
            return;
        }
        this.lastUpdatedCount = this.repetitionCount;
        this.lastMessageEdit = System.currentTimeMillis();
        this.editDiscordMessage();
    }

    private String cleanedMessage() {
        return this.message.replace("@everyone", "@ everyone").replace("@here", "@ here").replaceAll("<@&\\d+>", "@role-ping");
    }

    private String getMessage() {
        if (this.sender != null) {
            return Utils.escapeUnderscores(this.sender.method_5477().method_54160()) + ": " + this.cleanedMessage();
        }
        return this.cleanedMessage();
    }

    private void sendMessageToDiscord() {
        if (this.sender != null && this.webhookClient != null) {
            this.sendAsWebhook();
            return;
        }
        this.readyFuture = ((CompletableFuture)((CompletableFuture)this.channel.sendMessage(this.getMessage()).submit().thenApply(ISnowflake::getIdLong)).thenAccept(this::updateMessage)).exceptionally(this::handleFailure);
    }

    private void editDiscordMessage() {
        String displayedCount = " (" + this.repetitionCount + ")";
        if (this.sender != null && this.webhookClient != null) {
            this.editAsWebhook(this.cleanedMessage() + displayedCount);
            return;
        }
        this.channel.editMessageById(this.messageId, (CharSequence)(this.getMessage() + displayedCount)).submit().exceptionally(this::handleFailure);
    }

    private String getAvatarUrl(class_3222 player) {
        return this.config.avatarUrl.replace("%UUID%", player.method_5667().toString()).replace("%randomUUID%", UUID.randomUUID().toString());
    }

    private void sendAsWebhook() {
        String avatarUrl = this.getAvatarUrl(this.sender);
        WebhookMessage msg = new WebhookMessageBuilder().setUsername(this.sender.method_5477().method_54160()).setAvatarUrl(avatarUrl).setContent(this.cleanedMessage()).build();
        this.readyFuture = ((CompletableFuture)((CompletableFuture)this.webhookClient.send(msg).thenApply(ReadonlyMessage::getId)).thenAccept(this::updateMessage)).exceptionally(this::handleFailure);
    }

    private void editAsWebhook(String message) {
        this.webhookClient.edit(this.messageId, message).exceptionally(this::handleFailure);
    }

    private <T> T handleFailure(Throwable t) {
        this.repetitionCount = 0;
        return null;
    }
}

