/*
 * Decompiled with CFR 0.152.
 */
package tronka.justsync.compat;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3222;
import org.geysermc.floodgate.api.FloodgateApi;
import tronka.justsync.JustSyncApplication;
import tronka.justsync.linking.LinkManager;
import tronka.justsync.linking.PlayerLink;

public class FloodgateIntegration {
    private FloodgateApi floodgateApi;
    private JustSyncApplication integration;

    public FloodgateIntegration(JustSyncApplication integration) {
        if (FabricLoader.getInstance().isModLoaded("floodgate")) {
            this.floodgateApi = FloodgateApi.getInstance();
        }
        this.integration = integration;
    }

    public boolean isBedrock(UUID uuid) {
        return this.floodgateApi != null && this.floodgateApi.isFloodgateId(uuid);
    }

    public String getUsername(UUID uuid) {
        if (this.floodgateApi != null) {
            try {
                return this.floodgateApi.getPlayerPrefix() + (String)this.floodgateApi.getGamertagFor(uuid.getLeastSignificantBits()).get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        return "unknown";
    }

    public boolean isFloodGateName(String name) {
        return this.floodgateApi != null && name.startsWith(this.floodgateApi.getPlayerPrefix());
    }

    public GameProfile getGameProfileFor(String name) {
        String gamerTag = name.replaceFirst(this.floodgateApi.getPlayerPrefix(), "");
        try {
            UUID id = (UUID)this.floodgateApi.getUuidFor(gamerTag).get();
            String username = this.getUsername(id);
            return new GameProfile(id, username);
        }
        catch (InterruptedException | ExecutionException exception) {
            return null;
        }
    }

    public boolean canJoinMixedAccountType(UUID id) {
        if (this.integration.getConfig().integrations.floodgate.allowJoiningMixedAccountTypes || this.floodgateApi == null) {
            return true;
        }
        LinkManager linkManager = this.integration.getLinkManager();
        Optional<PlayerLink> linkOptional = linkManager.getDataOf(id);
        if (linkOptional.isEmpty()) {
            return true;
        }
        PlayerLink playerLink = linkOptional.get();
        Optional<Member> member = linkManager.getDiscordOf(playerLink);
        ArrayList<Role> roles = new ArrayList<Role>(member.get().getRoles());
        roles.retainAll(linkManager.getAllowJoiningMixedAccountTypesBypass());
        if (!roles.isEmpty()) {
            return true;
        }
        List<UUID> uuids = playerLink.getAllUuids();
        boolean currentIsBedrock = this.isBedrock(id);
        for (UUID uuid : uuids) {
            class_3222 player = this.integration.getServer().method_3760().method_14602(uuid);
            if (player == null || this.isBedrock(uuid) == currentIsBedrock) continue;
            return false;
        }
        return true;
    }
}

