/*
 * Decompiled with CFR 0.152.
 */
package tronka.justsync.compat;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.fabricmc.loader.api.FabricLoader;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tronka.justsync.JustSyncApplication;
import tronka.justsync.Utils;
import tronka.justsync.compat.LuckPermsHelper;
import tronka.justsync.config.Config;
import tronka.justsync.linking.PlayerLink;

public class LuckPermsIntegration {
    private static final Logger log = LoggerFactory.getLogger(LuckPermsIntegration.class);
    private final JustSyncApplication integration;
    private boolean loaded = false;
    private Map<Role, List<String>> syncedRoles = Map.of();

    public LuckPermsIntegration(JustSyncApplication integration) {
        this.integration = integration;
        if (!FabricLoader.getInstance().isModLoaded("luckperms")) {
            return;
        }
        integration.registerConfigReloadHandler(this::onConfigLoaded);
    }

    private void onConfigLoaded(Config config) {
        this.loaded = config.integrations.enableLuckPermsIntegration;
        this.syncedRoles = new HashMap<Role, List<String>>();
        for (Map.Entry<String, List<String>> sync : config.integrations.luckPerms.syncedRoles.entrySet()) {
            Optional<Role> role = Utils.parseRole(this.integration.getGuild(), sync.getKey());
            role.ifPresent(value -> this.syncedRoles.put((Role)value, (List)sync.getValue()));
        }
    }

    public void evaluateRolesFor(Member member) {
        LuckPerms luckPerms = this.getLuckPerms();
        if (luckPerms == null) {
            return;
        }
        Optional<PlayerLink> link = this.integration.getLinkManager().getDataOf(member.getIdLong());
        if (link.isEmpty()) {
            return;
        }
        List<UUID> uuids = this.integration.getConfig().integrations.luckPerms.assignSyncedRolesToAlts ? link.get().getAllUuids() : List.of(link.get().getPlayerId());
        uuids.forEach(uuid -> luckPerms.getUserManager().loadUser(uuid).thenAccept(user -> {
            Map<String, Boolean> groups2 = this.getGroups(member);
            this.applyGroups((User)user, groups2);
        }));
    }

    public void removeAllSyncedRoles(UUID altUuid) {
        this.removeAllSyncedRoles(List.of(altUuid));
    }

    public void removeAllSyncedRoles(List<UUID> uuids) {
        LuckPerms luckPerms = this.getLuckPerms();
        if (luckPerms == null) {
            return;
        }
        uuids.forEach(uuid -> luckPerms.getUserManager().loadUser(uuid).thenAccept(user -> {
            HashMap<String, Boolean> groups2 = new HashMap<String, Boolean>();
            this.syncedRoles.values().forEach(groupList -> groupList.forEach(group -> groups2.put((String)group, false)));
            this.applyGroups((User)user, (Map<String, Boolean>)groups2);
        }));
    }

    private void applyGroups(User user, Map<String, Boolean> groups2) {
        if (groups2.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Boolean> group : groups2.entrySet()) {
            if (group.getValue().booleanValue()) {
                user.data().add(LuckPermsHelper.getNode(group.getKey()));
                continue;
            }
            user.data().remove(LuckPermsHelper.getNode(group.getKey()));
        }
        this.getLuckPerms().getUserManager().saveUser(user);
    }

    private Map<String, Boolean> getGroups(Member member) {
        HashMap<String, Boolean> groups2 = new HashMap<String, Boolean>();
        for (Map.Entry<Role, List<String>> sync : this.syncedRoles.entrySet()) {
            if (member.getRoles().contains(sync.getKey())) {
                sync.getValue().forEach(v -> groups2.put((String)v, true));
                continue;
            }
            sync.getValue().forEach(v -> groups2.putIfAbsent((String)v, false));
        }
        return groups2;
    }

    private LuckPerms getLuckPerms() {
        if (!this.loaded) {
            return null;
        }
        try {
            return LuckPermsProvider.get();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public void setAlt(UUID uuid) {
        LuckPerms luckPerms = this.getLuckPerms();
        if (luckPerms == null) {
            return;
        }
        luckPerms.getUserManager().loadUser(uuid).thenAccept(user -> {
            for (String group : this.integration.getConfig().integrations.luckPerms.altGroups) {
                user.data().add(LuckPermsHelper.getNode(group));
            }
            luckPerms.getUserManager().saveUser(user);
        });
    }

    public void unsetAlt(UUID uuid) {
        LuckPerms luckPerms = this.getLuckPerms();
        if (luckPerms == null) {
            return;
        }
        luckPerms.getUserManager().loadUser(uuid).thenAccept(user -> {
            Set<String> groups2 = Set.copyOf(this.integration.getConfig().integrations.luckPerms.altGroups.stream().map(group -> "group." + group).toList());
            user.data().clear(node -> groups2.contains(node.getKey()));
            luckPerms.getUserManager().saveUser(user);
        });
    }
}

