/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.internal;

import com.google.crypto.tink.AccessesPartialKey;
import com.google.crypto.tink.Key;
import com.google.crypto.tink.Parameters;
import com.google.crypto.tink.SecretKeyAccess;
import com.google.errorprone.annotations.RestrictedApi;
import dcshadow.javax.annotation.Nullable;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;

public final class MutableKeyDerivationRegistry {
    private final Map<Class<? extends Parameters>, InsecureKeyCreator<? extends Parameters>> creators = new HashMap<Class<? extends Parameters>, InsecureKeyCreator<? extends Parameters>>();
    private static final MutableKeyDerivationRegistry globalInstance = new MutableKeyDerivationRegistry();

    public static MutableKeyDerivationRegistry globalInstance() {
        return globalInstance;
    }

    public synchronized <ParametersT extends Parameters> void add(InsecureKeyCreator<ParametersT> creator, Class<ParametersT> parametersClass) throws GeneralSecurityException {
        InsecureKeyCreator<? extends Parameters> existingCreator = this.creators.get(parametersClass);
        if (existingCreator != null && !existingCreator.equals(creator)) {
            throw new GeneralSecurityException("Different key creator for parameters class already inserted");
        }
        this.creators.put(parametersClass, creator);
    }

    @RestrictedApi(explanation="Accessing parts of keys can produce unexpected incompatibilities, annotate the function with @AccessesPartialKey", link="https://developers.google.com/tink/design/access_control#accessing_partial_keys", allowedOnPath=".*Test\\.java", allowlistAnnotations={AccessesPartialKey.class})
    public Key createKeyFromRandomness(Parameters parameters, InputStream inputStream2, @Nullable Integer idRequirement, SecretKeyAccess access) throws GeneralSecurityException {
        return this.createKeyFromRandomnessTyped(parameters, inputStream2, idRequirement, access);
    }

    private synchronized <ParametersT extends Parameters> Key createKeyFromRandomnessTyped(ParametersT parameters, InputStream inputStream2, @Nullable Integer idRequirement, SecretKeyAccess access) throws GeneralSecurityException {
        Class<?> parametersClass = parameters.getClass();
        InsecureKeyCreator<? extends Parameters> creator = this.creators.get(parametersClass);
        if (creator == null) {
            throw new GeneralSecurityException("Cannot use key derivation to derive key for parameters " + parameters + ": no key creator for this class was registered.");
        }
        InsecureKeyCreator<? extends Parameters> castCreator = creator;
        return castCreator.createKeyFromRandomness(parameters, inputStream2, idRequirement, access);
    }

    public static interface InsecureKeyCreator<ParametersT extends Parameters> {
        public Key createKeyFromRandomness(ParametersT var1, InputStream var2, @Nullable Integer var3, SecretKeyAccess var4) throws GeneralSecurityException;
    }
}

