/*
 * Decompiled with CFR 0.152.
 */
package tronka.justsync;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.internal.utils.PermissionUtil;
import net.minecraft.class_2168;
import tronka.justsync.DiscordCommandSender;
import tronka.justsync.JustSyncApplication;
import tronka.justsync.Utils;
import tronka.justsync.config.Config;

public class ConsoleBridge
extends ListenerAdapter {
    private final JustSyncApplication integration;
    private TextChannel commandLogChannel;
    private TextChannel commandChannel;
    private Role opRole;
    private List<LogRedirect> logRedirects;

    public ConsoleBridge(JustSyncApplication integration) {
        this.integration = integration;
        integration.registerConfigReloadHandler(this::onConfigLoaded);
    }

    private void onConfigLoaded(Config config) {
        this.commandLogChannel = Utils.getTextChannel(this.integration.getJda(), config.commands.commandLogChannel);
        this.commandChannel = Utils.getTextChannel(this.integration.getJda(), config.commands.commandChannel);
        String opRoleId = this.integration.getConfig().commands.opRole;
        this.opRole = this.commandChannel != null && !opRoleId.isEmpty() ? this.commandChannel.getGuild().getRoleById(opRoleId) : null;
        this.logRedirects = new ArrayList<LogRedirect>();
        for (Config.LogRedirectChannel logRedirectChannel : config.commands.logRedirectChannels) {
            TextChannel channel = Utils.getTextChannel(this.integration.getJda(), logRedirectChannel.channel);
            if (channel != null) {
                this.logRedirects.add(new LogRedirect(channel, logRedirectChannel.redirectPrefixes));
                continue;
            }
            LogUtils.getLogger().info("Could not load log redirect: ID: \"{}\", redirects: [{}]", (Object)logRedirectChannel.channel, (Object)String.join((CharSequence)", ", logRedirectChannel.redirectPrefixes));
        }
    }

    public void onCommandExecute(class_2168 source2, String command) {
        if (this.commandLogChannel == null) {
            return;
        }
        if (!this.integration.getConfig().commands.logCommandsInConsole) {
            return;
        }
        if (source2.method_9228() == null && !source2.method_9214().equals("Server") && !this.integration.getConfig().commands.logCommandBlockCommands) {
            return;
        }
        if (Utils.startsWithAny(command, this.integration.getConfig().commands.ignoredCommands)) {
            return;
        }
        TextChannel target = this.commandLogChannel;
        for (LogRedirect redirect : this.logRedirects) {
            if (!Utils.startsWithAny(command, redirect.prefixes)) continue;
            target = redirect.channel;
            break;
        }
        target.sendMessage(this.integration.getConfig().messages.commandExecutedInfoText.replace("%user%", Utils.escapeUnderscores(source2.method_9214())).replace("%cmd%", command)).queue();
    }

    @Override
    public void onMessageReceived(MessageReceivedEvent event) {
        if (event.getChannel() != this.commandChannel || event.getMember() == null) {
            return;
        }
        String message = event.getMessage().getContentStripped();
        if (!message.startsWith(this.integration.getConfig().commands.commandPrefix)) {
            return;
        }
        if (!PermissionUtil.checkPermission(event.getMember(), Permission.ADMINISTRATOR) && !event.getMember().getRoles().contains(this.opRole)) {
            event.getChannel().sendMessage("You don't have permission to use this command").queue();
            return;
        }
        if ((message = message.substring(this.integration.getConfig().commands.commandPrefix.length())).equals("help")) {
            event.getChannel().sendMessageEmbeds(this.getHelpEmbed(), new MessageEmbed[0]).queue();
            return;
        }
        String[] commandParts = message.split(" ", 2);
        String commandName = commandParts[0].toLowerCase();
        String commandArgs = commandParts.length == 2 ? commandParts[1] : "";
        Optional<Config.BridgeCommand> commandOptional = this.integration.getConfig().commands.commandList.stream().filter(cmd -> cmd.commandName.equals(commandName)).findFirst();
        if (commandOptional.isPresent()) {
            Config.BridgeCommand command = commandOptional.get();
            DiscordCommandSender commandSender = new DiscordCommandSender(this.integration.getServer(), event.getAuthor().getAsMention(), feedback -> {
                if (feedback.length() > 2000) {
                    feedback = feedback.substring(0, 2000);
                }
                event.getChannel().sendMessage((CharSequence)feedback).queue();
            });
            String inGameCommand = command.inGameAction.replace("%args%", commandArgs);
            try {
                this.integration.getServer().method_3734().method_9235().execute(inGameCommand, (Object)commandSender);
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        } else {
            event.getChannel().sendMessage("Unknown command: \"%s\", use %shelp for a list of commands".formatted(commandName, this.integration.getConfig().commands.commandPrefix)).queue();
        }
    }

    private MessageEmbed getHelpEmbed() {
        List<String> lines = this.integration.getConfig().commands.commandList.stream().map(command -> "%s %s".formatted(command.commandName, command.inGameAction.replace("%args%", "<args>").trim())).toList();
        EmbedBuilder embed = new EmbedBuilder();
        ArrayList<String> chunk = new ArrayList<String>();
        int chunkSize = 0;
        for (String line : lines) {
            if (chunkSize + line.length() < 2000) {
                chunk.add(line);
                chunkSize += line.length() + 1;
                continue;
            }
            embed.addField("Commands", String.join((CharSequence)"\n", chunk), false);
            chunk = new ArrayList();
            chunk.add(line);
            chunkSize = line.length();
        }
        embed.addField("Commands", String.join((CharSequence)"\n", chunk), false);
        return embed.build();
    }

    private record LogRedirect(TextChannel channel, List<String> prefixes) {
    }
}

