/*
 * Decompiled with CFR 0.152.
 */
package tronka.justsync;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.dv8tion.jda.api.entities.Member;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import tronka.justsync.JustSyncApplication;
import tronka.justsync.linking.PlayerData;
import tronka.justsync.linking.PlayerLink;

public class InGameCommand {
    private final JustSyncApplication integration;

    public InGameCommand(JustSyncApplication integration) {
        this.integration = integration;
        CommandRegistrationCallback.EVENT.register(this::register);
    }

    private void register(CommandDispatcher<class_2168> dispatcher, class_7157 registry, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"discord").then(this.unlinkSubcommand())).then(this.reloadSubcommand())).then(this.getInfoSubcommand()));
    }

    private LiteralArgumentBuilder<class_2168> getInfoSubcommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"get").executes(this::getSelfLinkInfo)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).requires(Permissions.require((String)"justsync.get", (int)4))).requires(Permissions.require((String)"justsync.get", (int)4))).executes(this::getLinkInfo));
    }

    private int getLinkInfo(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection profiles = class_2191.method_9330(context, (String)"player");
        ArrayList<Object> lines = new ArrayList<Object>();
        for (GameProfile profile : profiles) {
            Optional<PlayerLink> optionalLink = this.integration.getLinkManager().getDataOf(profile.getId());
            if (optionalLink.isEmpty()) {
                lines.add("No records for " + profile.getName());
                continue;
            }
            Optional<Member> member = this.integration.getLinkManager().getDiscordOf(optionalLink.get());
            if (member.isPresent()) {
                lines.add(InGameCommand.formatPlayerInfo(optionalLink.get(), member.get()));
                continue;
            }
            lines.add("Unable to load discord member for " + profile.getName());
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.join((CharSequence)"\n", lines)), false);
        return 1;
    }

    private int getSelfLinkInfo(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Player only!"), false);
            return 1;
        }
        Optional<PlayerLink> playerLinkOptional = this.integration.getLinkManager().getDataOf(player.method_5667());
        if (playerLinkOptional.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Player is not linked"), false);
            return 1;
        }
        PlayerLink playerLink = playerLinkOptional.get();
        Optional<Member> member = this.integration.getLinkManager().getDiscordOf(playerLink.getPlayerId());
        if (member.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Discord member not found"), false);
            return 1;
        }
        String message = InGameCommand.formatPlayerInfo(playerLink, member.get());
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)message), false);
        return 1;
    }

    private static String formatPlayerInfo(PlayerLink playerLink, Member member) {
        StringBuilder message = new StringBuilder().append(playerLink.getPlayerName()).append(" (@").append(member.getEffectiveName()).append(")");
        if (playerLink.altCount() > 0) {
            message.append(" Alts: ").append(String.join((CharSequence)", ", playerLink.getAlts().stream().map(PlayerData::getName).toList()));
        }
        return message.toString();
    }

    private LiteralArgumentBuilder<class_2168> reloadSubcommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(Permissions.require((String)"justsync.reload", (int)4))).executes(this::reloadConfigs);
    }

    private int reloadConfigs(CommandContext<class_2168> context) {
        String result = this.integration.tryReloadConfig();
        String feedback = result.isEmpty() ? "Successfully reloaded config!" : result;
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)feedback), result.isEmpty());
        return 1;
    }

    private LiteralArgumentBuilder<class_2168> unlinkSubcommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"unlink").requires(Permissions.require((String)"justsync.unlink", (boolean)true))).executes(this::unlinkSelf)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).requires(Permissions.require((String)"justsync.unlink.other", (int)4))).executes(this::unlinkSpecifiedPlayer));
    }

    private int unlinkSpecifiedPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection profiles = class_2191.method_9330(context, (String)"player");
        for (GameProfile profile : profiles) {
            this.integration.getLinkManager().unlinkPlayer(profile.getId());
        }
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully unlinked %d player(s)".formatted(profiles.size())), false);
        return 1;
    }

    private int unlinkSelf(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player != null) {
            this.integration.getLinkManager().unlinkPlayer(player.method_5667());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Unlinked!"), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Player Only!"), false);
        }
        return 1;
    }
}

