/*
 * Decompiled with CFR 0.152.
 */
package tronka.justsync.chat;

import dcshadow.club.minnced.discord.webhook.external.JDAWebhookClient;
import dcshadow.org.jetbrains.annotations.NotNull;
import eu.pb4.placeholders.api.node.TextNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.events.message.MessageDeleteEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.managers.Presence;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_185;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import tronka.justsync.JustSyncApplication;
import tronka.justsync.Utils;
import tronka.justsync.chat.DiscordChatMessageSender;
import tronka.justsync.chat.TextReplacer;
import tronka.justsync.config.Config;

public class ChatBridge
extends ListenerAdapter {
    private static final String webhookId = "justsync-hook";
    private final JustSyncApplication integration;
    private TextChannel channel;
    private boolean stopped = false;
    private DiscordChatMessageSender messageSender;
    private JDAWebhookClient webhookClient;

    public ChatBridge(JustSyncApplication integration) {
        this.integration = integration;
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onServerStopping);
        integration.registerConfigReloadHandler(this::onConfigLoaded);
        this.sendMessageToDiscord(integration.getConfig().messages.startMessage, null, null);
    }

    private void onConfigLoaded(Config config) {
        this.channel = Utils.getTextChannel(this.integration.getJda(), config.serverChatChannel, "serverChatChannel");
        this.messageSender = null;
        this.setWebhook(null);
        if (this.integration.getConfig().useWebHooks) {
            this.channel.retrieveWebhooks().onSuccess(webhooks -> {
                Optional<Webhook> hook = webhooks.stream().filter(w -> w.getOwner() == this.integration.getGuild().getSelfMember()).findFirst();
                if (hook.isPresent()) {
                    this.setWebhook(hook.get());
                } else {
                    this.channel.createWebhook(webhookId).onSuccess(this::setWebhook).queue();
                }
            }).queue();
        }
        this.updateRichPresence(0);
    }

    private void setWebhook(Webhook webhook) {
        if (this.webhookClient != null) {
            this.webhookClient.close();
            this.webhookClient = null;
        }
        if (webhook != null) {
            this.webhookClient = JDAWebhookClient.from(webhook);
        }
    }

    @Override
    public void onMessageReceived(MessageReceivedEvent event) {
        TextNode attachmentInfo;
        String baseText;
        if (event.getChannel() != this.channel) {
            return;
        }
        if (event.getMember() == null || event.getAuthor().isBot()) {
            return;
        }
        Message repliedMessage = event.getMessage().getReferencedMessage();
        String string = baseText = repliedMessage == null ? this.integration.getConfig().messages.chatMessageFormat : this.integration.getConfig().messages.chatMessageFormatReply;
        if (!event.getMessage().getAttachments().isEmpty()) {
            ArrayList<TextNode> attachments = new ArrayList<TextNode>(List.of(TextNode.of((String)"\nAttachments:")));
            for (Message.Attachment attachment : event.getMessage().getAttachments()) {
                attachments.add(TextReplacer.create().replace("link", attachment.getUrl()).replace("name", attachment.getFileName()).applyNode(this.integration.getConfig().messages.attachmentFormat));
            }
            attachmentInfo = TextNode.wrap(attachments);
        } else {
            attachmentInfo = TextNode.empty();
        }
        String messageText = event.getMessage().getContentDisplay();
        if (messageText.contains("\u00a7") && this.integration.getConfig().restrictFormattingCodes) {
            if (event.getMember().getRoles().stream().noneMatch(Utils.parseRoleList(this.integration.getGuild(), this.integration.getConfig().formattingCodeRestrictionOverrideRoles)::contains)) {
                messageText = this.integration.getConfig().formattingCodeReplacement.isEmpty() ? Utils.removeFormattingCode(messageText) : Utils.replaceFormattingCode(messageText, this.integration.getConfig().formattingCodeReplacement);
            }
        }
        String replyUser = repliedMessage == null ? "%userRepliedTo%" : (repliedMessage.getMember() == null ? repliedMessage.getAuthor().getEffectiveName() : repliedMessage.getMember().getEffectiveName());
        this.sendMcChatMessage(TextReplacer.create().replace("msg", Utils.parseUrls(messageText, this.integration.getConfig())).replace("user", event.getMember().getEffectiveName()).replace("userRepliedTo", replyUser).replace("attachments", attachmentInfo).apply(baseText));
    }

    public void onPlayerJoin(class_3222 player) {
        this.onPlayerJoin(player, false);
    }

    public void onPlayerJoin(class_3222 player, boolean vanish) {
        this.sendMessageToDiscord(this.integration.getConfig().messages.playerJoinMessage.replace("%user%", Utils.escapeUnderscores(player.method_5477().getString())), null, player);
        this.updateRichPresence(vanish ? 0 : 1);
    }

    public void onPlayerTimeOut(class_3222 player) {
        this.sendMessageToDiscord(this.integration.getConfig().messages.playerTimeOutMessage.replace("%user%", Utils.escapeUnderscores(player.method_5477().getString())), null, player);
        this.updateRichPresence(-1);
    }

    public void onPlayerLeave(class_3222 player) {
        this.onPlayerLeave(player, false);
    }

    public void onPlayerLeave(class_3222 player, boolean vanish) {
        if (this.stopped) {
            return;
        }
        String message = this.integration.getConfig().messages.playerLeaveMessage.replace("%user%", Utils.escapeUnderscores(player.method_5477().getString()));
        if (vanish) {
            this.sendMessageToDiscordUnchecked(message, null);
        } else {
            this.sendMessageToDiscord(message, null, player);
        }
        this.updateRichPresence(vanish ? 0 : -1);
    }

    private void updateRichPresence(int modifier) {
        if (!this.integration.getConfig().showPlayerCountStatus) {
            return;
        }
        long playerCount = this.integration.getServer() == null || this.integration.getServer().method_3760() == null ? 0L : this.integration.getServer().method_3760().method_14571().stream().filter(p -> !this.integration.getVanishIntegration().isVanished((class_3222)p)).count() + (long)modifier;
        Presence presence = this.integration.getJda().getPresence();
        presence.setPresence(Activity.playing(switch ((int)playerCount) {
            case 0 -> this.integration.getConfig().messages.onlineCountZero;
            case 1 -> this.integration.getConfig().messages.onlineCountSingular;
            default -> this.integration.getConfig().messages.onlineCountPlural.formatted(playerCount);
        }), false);
    }

    public void onPlayerDeath(class_3222 player, class_1282 source2) {
        if (this.integration.getConfig().broadCastDeathMessages) {
            String message = source2.method_5506((class_1309)player).getString();
            if (message.equals("death.attack.badRespawnPoint")) {
                message = "%s was killed by [Intentional Mod Design]".formatted(player.method_5477().getString());
            }
            this.sendMessageToDiscord(Utils.escapeUnderscores(message), null, player);
        }
    }

    public void onReceiveAdvancement(class_3222 player, class_185 advancement) {
        if (this.integration.getConfig().announceAdvancements && advancement.method_808()) {
            this.sendMessageToDiscord(this.integration.getConfig().messages.advancementMessage.replace("%user%", Utils.escapeUnderscores(player.method_5477().getString())).replace("%title%", advancement.method_811().getString()).replace("%description%", advancement.method_817().getString()), null, player);
        }
    }

    public void sendMcChatMessage(class_2561 message) {
        this.integration.getServer().method_3760().method_43514(message, false);
    }

    private void onServerStopping(MinecraftServer minecraftServer) {
        this.sendMessageToDiscord(this.integration.getConfig().messages.stopMessage, null, null);
        this.stopped = true;
    }

    public void onMcChatMessage(String message, class_3222 player) {
        if (this.integration.getConfig().waypoints.formatWaypoints) {
            message = Utils.formatXaero(message, this.integration.getConfig());
            message = Utils.formatVoxel(message, this.integration.getConfig(), player);
        }
        this.sendMessageToDiscord(message, player, player);
    }

    private void sendMessageToDiscord(String message, class_3222 sender, class_3222 connectedPlayer) {
        if (connectedPlayer != null && this.integration.getVanishIntegration().isVanished(connectedPlayer)) {
            return;
        }
        this.sendMessageToDiscordUnchecked(message, sender);
    }

    private void sendMessageToDiscordUnchecked(String message, class_3222 sender) {
        if (message.trim().isEmpty()) {
            return;
        }
        message = Utils.escapeMentions(message);
        message = Utils.formatMentions(message, this.integration, sender);
        if (this.messageSender == null || this.messageSender.hasChanged(message, sender)) {
            this.messageSender = new DiscordChatMessageSender(this.webhookClient, this.channel, this.integration.getConfig(), message, sender);
        }
        this.messageSender.sendMessage();
    }

    @Override
    public void onMessageDelete(@NotNull MessageDeleteEvent event) {
        if (this.messageSender != null) {
            this.messageSender.onMessageDelete(event.getMessageIdLong());
        }
    }

    public void onCommandExecute(class_2168 source2, String command) {
        Object prefix;
        class_3222 sender;
        if (!command.startsWith("me") && !command.startsWith("say")) {
            return;
        }
        class_1297 class_12972 = source2.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 player;
            sender = player = (class_3222)class_12972;
            prefix = "";
        } else {
            sender = null;
            prefix = Utils.escapeUnderscores(source2.method_9214()) + ": ";
        }
        String data = command.split(" ", 2)[1];
        String message = command.startsWith("me") ? (String)prefix + "*" + data + "*" : (String)prefix + data;
        this.sendMessageToDiscord(message, sender, sender);
    }
}

