<img width="1539" height="365" alt="TN" src="https://github.com/user-attachments/assets/3a5e5527-333a-47e2-9443-8f038c11eb65" />


---

## 📖 Description

**Legacy Mechanics** is a mod/datapack that aims to bring back the **quirky mechanics and nostalgic features** from the Legacy Console Editions of Minecraft.

This mod is designed for players who want the **console-era gameplay feel**, complete with small world options, unique mob behaviors, and classic item quirks, all blended with **modern Minecraft’s content** so nothing feels missing.

Some of the features include:

* **Legacy Console Achievements** restored.
* Coming Soon: **Small world type** for a more compact console-style survival experience.
* Coming Soon: **Closer structure spacing** to replicate console exploration.
* **Craftable Enchanted Golden Apples** with 8 gold blocks + 1 apple.
* **Fortune on melons** can drop up to 10 slices with Fortune III.
* Coming Soon: **Sand and Red Sand** now smeltable in blast furnaces.
* Coming Soon: **Minecarts** move at twice their Java speed.
* Coming Soon: **Phantoms** have half their normal health.
* Coming Soon: **Vindicators** deal reduced damage (console values).
* Coming Soon: **Wandering Traders** can sell lilacs, rose bushes, sunflowers, peonies, and red sandstone.

---

## ✨ Feature list

<details>  
<summary>Feature List</summary>  

## Key:

✅ - Implemented
☑️ - Planned
❌ - Not Implemented

| **Feature**                                         | Implemented | Planned |
| --------------------------------------------------- | ----------- | ------- |
| Console-style Achievements                          | ✅           | ☑️      |
| Legacy Console small world type                     | ✅           | ☑️      |
| Closer structure generation                         | ✅           | ☑️      |
| Dead bushes drop 1 stick                            | ✅           | ☑️      |
| Enchanted Golden Apple crafting recipe              | ✅           | ☑️      |
| Jack-O-Lantern & Jungle Tree Sapling names restored | ✅           | ☑️      |
| Fortune melons (up to 10 slices)                    | ✅           | ☑️      |
| Sand/Red Sand blast furnace smelting                | ✅           | ☑️      |
| Short Grass → Tall Grass                            | ✅           | ☑️      |
| Tall Grass → Double Tall Grass                      | ✅           | ☑️      |
| Minecarts move 2× faster                            | ✅           | ☑️      |
| Phantoms have 10 HP                                 | ✅           | ☑️      |
| Vindicators deal reduced damage                     | ✅           | ☑️      |
| Wandering Traders sell flowers & red sandstone      | ✅           | ☑️      |

</details>  

---

## 🌌 Nostalgia

For the best nostalgic experience, **Legacy Mechanics** pairs well with resource packs and mods that restore classic visuals and console-era gameplay, such as:

* [**Golden Days**](https://github.com/PoeticRainbow/golden-days/releases) by *PoeticRainbow* for authentic pre-1.14 textures.
* [**Nostalgic Tweaks**](https://modrinth.com/mod/nostalgic-tweaks) by *Adrenix* to bring back old fog, lighting, skies, and combat.
* [**Moderner Beta**](https://modrinth.com/mod/moderner-beta) for terrain generation in a console-like style.

---

## ⚙️ Compatibility

* ✅ Works in **Minecraft 1.21.x**.
* 🔧 Safe for multiplayer if all players have the mod installed.

---

## 📦 Installation

1. Download the mod.
2. Place it in your `mods/` folder.
3. Launch Minecraft with your preferred loader.
4. Generate a **new world** (or new chunks) to see console-style mechanics in action.

---

## 📸 Screenshots

<details>  
<summary>Images</summary>  

<img width="1920" height="1081" alt="2025-10-07_23 18 00" src="https://github.com/user-attachments/assets/11addb1c-7134-40a4-91f6-996dee5ebf91" />


</details>  

---

## 💡 Notes

* Some features require **new worlds or new chunks** to generate properly.
* Balancing is based directly on the **Legacy Console Edition values.**

---

## 🤝 Support

* 💬 Join the community on [**Discord**](https://discord.com/invite/discord-link)
* 🛠️ Report issues or contribute on [**GitHub**](https://github.com/Pigzone00/Legacy-Mechanics)
