/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws;

import dtnpaletteofpaws.common.util.Util;
import dtnpaletteofpaws.common.variant.WolfVariant;
import dtnpaletteofpaws.common.variant.biome_config.WolfBiomeConfig;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;

public class DTNRegistries {
    public static final Supplier<Registry<WolfVariant>> DTN_WOLF_VARIANT = DTNRegistries.makeRegistry(Keys.DTN_WOLF_VARIANT, WolfVariant.class, Util.getResource("birch"));

    public static void onNewRegistry(NewRegistryEvent event) {
        event.register(DTN_WOLF_VARIANT.get());
    }

    public static void onNewDataRegistry(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(DataKeys.WOLF_BIOME_CONFIG, WolfBiomeConfig.CODEC);
    }

    private static <T> ResourceKey<Registry<T>> regKey(String key) {
        ResourceLocation rl = Util.getResource(key);
        return ResourceKey.createRegistryKey((ResourceLocation)rl);
    }

    private static <T> Supplier<Registry<T>> makeRegistry(ResourceKey<Registry<T>> key, Class<T> type, ResourceLocation defaultKey) {
        RegistryBuilder builder = new RegistryBuilder(key);
        builder.sync(true);
        builder.defaultKey(defaultKey);
        Registry captured_ret = builder.create();
        return () -> captured_ret;
    }

    public static class DataKeys {
        public static final ResourceKey<Registry<WolfBiomeConfig>> WOLF_BIOME_CONFIG = Util.getRegistryKey(WolfBiomeConfig.class, "wolf_biome_config");
    }

    public static class Keys {
        public static final ResourceKey<Registry<WolfVariant>> DTN_WOLF_VARIANT = Keys.regKey("dtn_wolf_variant");

        private static <T> ResourceKey<Registry<T>> regKey(String key) {
            ResourceLocation rl = Util.getResource(key);
            return ResourceKey.createRegistryKey((ResourceLocation)rl);
        }
    }
}

