/*
 * Decompiled with CFR 0.152.
 */
package dtnpaletteofpaws;

import dtnpaletteofpaws.DTNRegistries;
import dtnpaletteofpaws.common.util.Util;
import dtnpaletteofpaws.common.variant.WolfVariant;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.DeferredRegister;

public class VanillaWolfVariants {
    public static final DeferredRegister<WolfVariant> VANILLA_WOLF_VARIANT = DeferredRegister.create(DTNRegistries.Keys.DTN_WOLF_VARIANT, (String)"minecraft");
    public static final Supplier<WolfVariant> PALE = VanillaWolfVariants.registerVanilla("pale");
    public static final Supplier<WolfVariant> CHESTNUT = VanillaWolfVariants.registerVanilla("chestnut");
    public static final Supplier<WolfVariant> STRIPED = VanillaWolfVariants.registerVanilla("striped");
    public static final Supplier<WolfVariant> WOOD = VanillaWolfVariants.registerVanilla("woods");
    public static final Supplier<WolfVariant> RUSTY = VanillaWolfVariants.registerVanilla("rusty");
    public static final Supplier<WolfVariant> BLACK = VanillaWolfVariants.registerVanilla("black");
    public static final Supplier<WolfVariant> SNOWY = VanillaWolfVariants.registerVanilla("snowy");
    public static final Supplier<WolfVariant> ASHEN = VanillaWolfVariants.registerVanilla("ashen");
    public static final Supplier<WolfVariant> SPOTTED = VanillaWolfVariants.registerVanilla("spotted");

    private static Supplier<WolfVariant> registerVanilla(String name) {
        WolfVariant.Props props = WolfVariant.builder(Util.getVanillaResource(name));
        VanillaWolfVariant captured_variant = new VanillaWolfVariant(props);
        return VANILLA_WOLF_VARIANT.register(name, () -> captured_variant);
    }

    public static class VanillaWolfVariant
    extends WolfVariant {
        public VanillaWolfVariant(WolfVariant.Props props) {
            super(props);
        }

        @Override
        public ResourceLocation createTextureLoc(ResourceLocation name) {
            return Util.getResource("textures/entity/dtnwolf/variants/vanilla/wolf_" + name.getPath() + ".png");
        }

        @Override
        public ResourceLocation createWildTextureLoc(ResourceLocation name) {
            return Util.getResource("textures/entity/dtnwolf/variants/vanilla/wolf_" + name.getPath() + "_wild.png");
        }
    }
}

